/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.droplets;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum State {
    EXPIRED("EXPIRED"),
    FAILED("FAILED"),
    PENDING("PENDING"),
    STAGED("STAGED"),
    STAGING("STAGING");

    private final String value;

    private State(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    static State from(String s) {
        switch (s.toLowerCase()) {
            case "expired": {
                return EXPIRED;
            }
            case "failed": {
                return FAILED;
            }
            case "pending": {
                return PENDING;
            }
            case "staged": {
                return STAGED;
            }
            case "staging": {
                return STAGING;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown state: %s", s));
    }
}

