/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Hash;
import org.cloudfoundry.client.v3.packages._BitsData;

public final class BitsData
extends _BitsData {
    @Nullable
    private final String error;
    @Nullable
    private final Hash hash;

    private BitsData(Builder builder) {
        this.error = builder.error;
        this.hash = builder.hash;
    }

    @Override
    @JsonProperty(value="error")
    @Nullable
    public String getError() {
        return this.error;
    }

    @Override
    @JsonProperty(value="hash")
    @Nullable
    public Hash getHash() {
        return this.hash;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BitsData && this.equalTo((BitsData)another);
    }

    private boolean equalTo(BitsData another) {
        return Objects.equals(this.error, another.error) && Objects.equals(this.hash, another.hash);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.error);
        h = h * 17 + Objects.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "BitsData{error=" + this.error + ", hash=" + this.hash + "}";
    }

    @Deprecated
    @JsonCreator
    static BitsData fromJson(Json json) {
        Builder builder = BitsData.builder();
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String error;
        private Hash hash;

        private Builder() {
        }

        public final Builder from(BitsData instance) {
            return this.from((_BitsData)instance);
        }

        final Builder from(_BitsData instance) {
            Hash hashValue;
            Objects.requireNonNull(instance, "instance");
            String errorValue = instance.getError();
            if (errorValue != null) {
                this.error(errorValue);
            }
            if ((hashValue = instance.getHash()) != null) {
                this.hash(hashValue);
            }
            return this;
        }

        public final Builder error(@Nullable String error) {
            this.error = error;
            return this;
        }

        public final Builder hash(@Nullable Hash hash) {
            this.hash = hash;
            return this;
        }

        public BitsData build() {
            return new BitsData(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _BitsData {
        String error;
        Hash hash;

        Json() {
        }

        @JsonProperty(value="error")
        public void setError(@Nullable String error) {
            this.error = error;
        }

        @JsonProperty(value="hash")
        public void setHash(@Nullable Hash hash) {
            this.hash = hash;
        }

        @Override
        public String getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash getHash() {
            throw new UnsupportedOperationException();
        }
    }
}

