/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Hash;
import org.cloudfoundry.client.v3.packages._DockerData;

public final class DockerData
extends _DockerData {
    @Nullable
    private final String error;
    @Nullable
    private final Hash hash;
    @Nullable
    private final String image;

    private DockerData(Builder builder) {
        this.error = builder.error;
        this.hash = builder.hash;
        this.image = builder.image;
    }

    @Override
    @JsonProperty(value="error")
    @Nullable
    public String getError() {
        return this.error;
    }

    @Override
    @JsonProperty(value="hash")
    @Nullable
    public Hash getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="image")
    @Nullable
    public String getImage() {
        return this.image;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DockerData && this.equalTo((DockerData)another);
    }

    private boolean equalTo(DockerData another) {
        return Objects.equals(this.error, another.error) && Objects.equals(this.hash, another.hash) && Objects.equals(this.image, another.image);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.error);
        h = h * 17 + Objects.hashCode(this.hash);
        h = h * 17 + Objects.hashCode(this.image);
        return h;
    }

    public String toString() {
        return "DockerData{error=" + this.error + ", hash=" + this.hash + ", image=" + this.image + "}";
    }

    @Deprecated
    @JsonCreator
    static DockerData fromJson(Json json) {
        Builder builder = DockerData.builder();
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.image != null) {
            builder.image(json.image);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String error;
        private Hash hash;
        private String image;

        private Builder() {
        }

        public final Builder from(DockerData instance) {
            return this.from((_DockerData)instance);
        }

        final Builder from(_DockerData instance) {
            String imageValue;
            Hash hashValue;
            Objects.requireNonNull(instance, "instance");
            String errorValue = instance.getError();
            if (errorValue != null) {
                this.error(errorValue);
            }
            if ((hashValue = instance.getHash()) != null) {
                this.hash(hashValue);
            }
            if ((imageValue = instance.getImage()) != null) {
                this.image(imageValue);
            }
            return this;
        }

        public final Builder error(@Nullable String error) {
            this.error = error;
            return this;
        }

        public final Builder hash(@Nullable Hash hash) {
            this.hash = hash;
            return this;
        }

        public final Builder image(@Nullable String image) {
            this.image = image;
            return this;
        }

        public DockerData build() {
            return new DockerData(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _DockerData {
        String error;
        Hash hash;
        String image;

        Json() {
        }

        @JsonProperty(value="error")
        public void setError(@Nullable String error) {
            this.error = error;
        }

        @JsonProperty(value="hash")
        public void setHash(@Nullable Hash hash) {
            this.hash = hash;
        }

        @JsonProperty(value="image")
        public void setImage(@Nullable String image) {
            this.image = image;
        }

        @Override
        public String getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getImage() {
            throw new UnsupportedOperationException();
        }
    }
}

