/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.packages._StagePackageRequest;

public final class StagePackageRequest
extends _StagePackageRequest {
    @Nullable
    private final Map<String, Object> environmentVariables;
    @Nullable
    private final Lifecycle lifecycle;
    private final String packageId;
    @Nullable
    private final Integer stagingDiskInMb;
    @Nullable
    private final Integer stagingMemoryInMb;

    private StagePackageRequest(Builder builder) {
        this.environmentVariables = builder.environmentVariables == null ? null : StagePackageRequest.createUnmodifiableMap(false, false, builder.environmentVariables);
        this.lifecycle = builder.lifecycle;
        this.packageId = builder.packageId;
        this.stagingDiskInMb = builder.stagingDiskInMb;
        this.stagingMemoryInMb = builder.stagingMemoryInMb;
    }

    @Override
    @Nullable
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    @Nullable
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Override
    public String getPackageId() {
        return this.packageId;
    }

    @Override
    @Nullable
    public Integer getStagingDiskInMb() {
        return this.stagingDiskInMb;
    }

    @Override
    @Nullable
    public Integer getStagingMemoryInMb() {
        return this.stagingMemoryInMb;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StagePackageRequest && this.equalTo((StagePackageRequest)another);
    }

    private boolean equalTo(StagePackageRequest another) {
        return Objects.equals(this.environmentVariables, another.environmentVariables) && Objects.equals(this.lifecycle, another.lifecycle) && this.packageId.equals(another.packageId) && Objects.equals(this.stagingDiskInMb, another.stagingDiskInMb) && Objects.equals(this.stagingMemoryInMb, another.stagingMemoryInMb);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.environmentVariables);
        h = h * 17 + Objects.hashCode(this.lifecycle);
        h = h * 17 + this.packageId.hashCode();
        h = h * 17 + Objects.hashCode(this.stagingDiskInMb);
        h = h * 17 + Objects.hashCode(this.stagingMemoryInMb);
        return h;
    }

    public String toString() {
        return "StagePackageRequest{environmentVariables=" + this.environmentVariables + ", lifecycle=" + this.lifecycle + ", packageId=" + this.packageId + ", stagingDiskInMb=" + this.stagingDiskInMb + ", stagingMemoryInMb=" + this.stagingMemoryInMb + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_PACKAGE_ID = 1L;
        private long initBits = 1L;
        private Map<String, Object> environmentVariables = null;
        private Lifecycle lifecycle;
        private String packageId;
        private Integer stagingDiskInMb;
        private Integer stagingMemoryInMb;

        private Builder() {
        }

        public final Builder from(StagePackageRequest instance) {
            return this.from((_StagePackageRequest)instance);
        }

        final Builder from(_StagePackageRequest instance) {
            Integer stagingMemoryInMbValue;
            Lifecycle lifecycleValue;
            Objects.requireNonNull(instance, "instance");
            Map<String, Object> environmentVariablesValue = instance.getEnvironmentVariables();
            if (environmentVariablesValue != null) {
                this.putAllEnvironmentVariables(environmentVariablesValue);
            }
            if ((lifecycleValue = instance.getLifecycle()) != null) {
                this.lifecycle(lifecycleValue);
            }
            this.packageId(instance.getPackageId());
            Integer stagingDiskInMbValue = instance.getStagingDiskInMb();
            if (stagingDiskInMbValue != null) {
                this.stagingDiskInMb(stagingDiskInMbValue);
            }
            if ((stagingMemoryInMbValue = instance.getStagingMemoryInMb()) != null) {
                this.stagingMemoryInMb(stagingMemoryInMbValue);
            }
            return this;
        }

        public final Builder environmentVariable(String key, Object value) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, Object>();
            }
            this.environmentVariables.put(Objects.requireNonNull(key, "environmentVariables key"), Objects.requireNonNull(value, "environmentVariables value"));
            return this;
        }

        public final Builder environmentVariable(Map.Entry<String, ? extends Object> entry) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.environmentVariables.put(Objects.requireNonNull(k, "environmentVariables key"), Objects.requireNonNull(v, "environmentVariables value"));
            return this;
        }

        public final Builder environmentVariables(@Nullable Map<String, ? extends Object> environmentVariables) {
            if (environmentVariables == null) {
                this.environmentVariables = null;
                return this;
            }
            this.environmentVariables = new LinkedHashMap<String, Object>();
            return this.putAllEnvironmentVariables(environmentVariables);
        }

        public final Builder putAllEnvironmentVariables(Map<String, ? extends Object> environmentVariables) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : environmentVariables.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.environmentVariables.put(Objects.requireNonNull(k, "environmentVariables key"), Objects.requireNonNull(v, "environmentVariables value"));
            }
            return this;
        }

        public final Builder lifecycle(@Nullable Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final Builder packageId(String packageId) {
            this.packageId = Objects.requireNonNull(packageId, "packageId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder stagingDiskInMb(@Nullable Integer stagingDiskInMb) {
            this.stagingDiskInMb = stagingDiskInMb;
            return this;
        }

        public final Builder stagingMemoryInMb(@Nullable Integer stagingMemoryInMb) {
            this.stagingMemoryInMb = stagingMemoryInMb;
            return this;
        }

        public StagePackageRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new StagePackageRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("packageId");
            }
            return "Cannot build StagePackageRequest, some of required attributes are not set " + attributes;
        }
    }
}

