/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.processes.Data;
import org.cloudfoundry.client.v3.processes.Type;
import org.cloudfoundry.client.v3.processes._HealthCheck;

public final class HealthCheck
extends _HealthCheck {
    @Nullable
    private final Data data;
    @Nullable
    private final Type type;

    private HealthCheck(Builder builder) {
        this.data = builder.data;
        this.type = builder.type;
    }

    @Override
    @JsonProperty(value="data")
    @Nullable
    public Data getData() {
        return this.data;
    }

    @Override
    @JsonProperty(value="type")
    @Nullable
    public Type getType() {
        return this.type;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof HealthCheck && this.equalTo((HealthCheck)another);
    }

    private boolean equalTo(HealthCheck another) {
        return Objects.equals(this.data, another.data) && Objects.equals((Object)this.type, (Object)another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.data);
        h = h * 17 + Objects.hashCode((Object)this.type);
        return h;
    }

    public String toString() {
        return "HealthCheck{data=" + this.data + ", type=" + (Object)((Object)this.type) + "}";
    }

    @Deprecated
    @JsonCreator
    static HealthCheck fromJson(Json json) {
        Builder builder = HealthCheck.builder();
        if (json.data != null) {
            builder.data(json.data);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Data data;
        private Type type;

        private Builder() {
        }

        public final Builder from(HealthCheck instance) {
            return this.from((_HealthCheck)instance);
        }

        final Builder from(_HealthCheck instance) {
            Type typeValue;
            Objects.requireNonNull(instance, "instance");
            Data dataValue = instance.getData();
            if (dataValue != null) {
                this.data(dataValue);
            }
            if ((typeValue = instance.getType()) != null) {
                this.type(typeValue);
            }
            return this;
        }

        public final Builder data(@Nullable Data data) {
            this.data = data;
            return this;
        }

        public final Builder type(@Nullable Type type) {
            this.type = type;
            return this;
        }

        public HealthCheck build() {
            return new HealthCheck(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _HealthCheck {
        Data data;
        Type type;

        Json() {
        }

        @JsonProperty(value="data")
        public void setData(@Nullable Data data) {
            this.data = data;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable Type type) {
            this.type = type;
        }

        @Override
        public Data getData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Type getType() {
            throw new UnsupportedOperationException();
        }
    }
}

