/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.processes._PortMapping;

public final class PortMapping
extends _PortMapping {
    @Nullable
    private final Integer external;
    @Nullable
    private final Integer internal;

    private PortMapping(Builder builder) {
        this.external = builder.external;
        this.internal = builder.internal;
    }

    @Override
    @JsonProperty(value="external")
    @Nullable
    public Integer getExternal() {
        return this.external;
    }

    @Override
    @JsonProperty(value="internal")
    @Nullable
    public Integer getInternal() {
        return this.internal;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PortMapping && this.equalTo((PortMapping)another);
    }

    private boolean equalTo(PortMapping another) {
        return Objects.equals(this.external, another.external) && Objects.equals(this.internal, another.internal);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.external);
        h = h * 17 + Objects.hashCode(this.internal);
        return h;
    }

    public String toString() {
        return "PortMapping{external=" + this.external + ", internal=" + this.internal + "}";
    }

    @Deprecated
    @JsonCreator
    static PortMapping fromJson(Json json) {
        Builder builder = PortMapping.builder();
        if (json.external != null) {
            builder.external(json.external);
        }
        if (json.internal != null) {
            builder.internal(json.internal);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer external;
        private Integer internal;

        private Builder() {
        }

        public final Builder from(PortMapping instance) {
            return this.from((_PortMapping)instance);
        }

        final Builder from(_PortMapping instance) {
            Integer internalValue;
            Objects.requireNonNull(instance, "instance");
            Integer externalValue = instance.getExternal();
            if (externalValue != null) {
                this.external(externalValue);
            }
            if ((internalValue = instance.getInternal()) != null) {
                this.internal(internalValue);
            }
            return this;
        }

        public final Builder external(@Nullable Integer external) {
            this.external = external;
            return this;
        }

        public final Builder internal(@Nullable Integer internal) {
            this.internal = internal;
            return this;
        }

        public PortMapping build() {
            return new PortMapping(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _PortMapping {
        Integer external;
        Integer internal;

        Json() {
        }

        @JsonProperty(value="external")
        public void setExternal(@Nullable Integer external) {
            this.external = external;
        }

        @JsonProperty(value="internal")
        public void setInternal(@Nullable Integer internal) {
            this.internal = internal;
        }

        @Override
        public Integer getExternal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getInternal() {
            throw new UnsupportedOperationException();
        }
    }
}

