/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.processes.PortMapping;
import org.cloudfoundry.client.v3.processes.ProcessStatistics;
import org.cloudfoundry.client.v3.processes.ProcessUsage;
import org.cloudfoundry.client.v3.processes._ProcessStatisticsResource;

public final class ProcessStatisticsResource
extends _ProcessStatisticsResource {
    @Nullable
    private final Long diskQuota;
    @Nullable
    private final Long fdsQuota;
    @Nullable
    private final String host;
    @Nullable
    private final Integer index;
    @Nullable
    private final List<PortMapping> instancePorts;
    @Nullable
    private final Long memoryQuota;
    @Nullable
    private final String state;
    @Nullable
    private final String type;
    @Nullable
    private final Long uptime;
    @Nullable
    private final ProcessUsage usage;

    private ProcessStatisticsResource(Builder builder) {
        this.diskQuota = builder.diskQuota;
        this.fdsQuota = builder.fdsQuota;
        this.host = builder.host;
        this.index = builder.index;
        this.instancePorts = builder.instancePorts == null ? null : ProcessStatisticsResource.createUnmodifiableList(true, builder.instancePorts);
        this.memoryQuota = builder.memoryQuota;
        this.state = builder.state;
        this.type = builder.type;
        this.uptime = builder.uptime;
        this.usage = builder.usage;
    }

    @Override
    @JsonProperty(value="disk_quota")
    @Nullable
    public Long getDiskQuota() {
        return this.diskQuota;
    }

    @Override
    @JsonProperty(value="fds_quota")
    @Nullable
    public Long getFdsQuota() {
        return this.fdsQuota;
    }

    @Override
    @JsonProperty(value="host")
    @Nullable
    public String getHost() {
        return this.host;
    }

    @Override
    @JsonProperty(value="index")
    @Nullable
    public Integer getIndex() {
        return this.index;
    }

    @Override
    @JsonProperty(value="instance_ports")
    @Nullable
    public List<PortMapping> getInstancePorts() {
        return this.instancePorts;
    }

    @Override
    @JsonProperty(value="mem_quota")
    @Nullable
    public Long getMemoryQuota() {
        return this.memoryQuota;
    }

    @Override
    @JsonProperty(value="state")
    @Nullable
    public String getState() {
        return this.state;
    }

    @Override
    @JsonProperty(value="type")
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="uptime")
    @Nullable
    public Long getUptime() {
        return this.uptime;
    }

    @Override
    @JsonProperty(value="usage")
    @Nullable
    public ProcessUsage getUsage() {
        return this.usage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ProcessStatisticsResource && this.equalTo((ProcessStatisticsResource)another);
    }

    private boolean equalTo(ProcessStatisticsResource another) {
        return Objects.equals(this.diskQuota, another.diskQuota) && Objects.equals(this.fdsQuota, another.fdsQuota) && Objects.equals(this.host, another.host) && Objects.equals(this.index, another.index) && Objects.equals(this.instancePorts, another.instancePorts) && Objects.equals(this.memoryQuota, another.memoryQuota) && Objects.equals(this.state, another.state) && Objects.equals(this.type, another.type) && Objects.equals(this.uptime, another.uptime) && Objects.equals(this.usage, another.usage);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.diskQuota);
        h = h * 17 + Objects.hashCode(this.fdsQuota);
        h = h * 17 + Objects.hashCode(this.host);
        h = h * 17 + Objects.hashCode(this.index);
        h = h * 17 + Objects.hashCode(this.instancePorts);
        h = h * 17 + Objects.hashCode(this.memoryQuota);
        h = h * 17 + Objects.hashCode(this.state);
        h = h * 17 + Objects.hashCode(this.type);
        h = h * 17 + Objects.hashCode(this.uptime);
        h = h * 17 + Objects.hashCode(this.usage);
        return h;
    }

    public String toString() {
        return "ProcessStatisticsResource{diskQuota=" + this.diskQuota + ", fdsQuota=" + this.fdsQuota + ", host=" + this.host + ", index=" + this.index + ", instancePorts=" + this.instancePorts + ", memoryQuota=" + this.memoryQuota + ", state=" + this.state + ", type=" + this.type + ", uptime=" + this.uptime + ", usage=" + this.usage + "}";
    }

    @Deprecated
    @JsonCreator
    static ProcessStatisticsResource fromJson(Json json) {
        Builder builder = ProcessStatisticsResource.builder();
        if (json.diskQuota != null) {
            builder.diskQuota(json.diskQuota);
        }
        if (json.fdsQuota != null) {
            builder.fdsQuota(json.fdsQuota);
        }
        if (json.host != null) {
            builder.host(json.host);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        if (json.instancePorts != null) {
            builder.addAllInstancePorts(json.instancePorts);
        }
        if (json.memoryQuota != null) {
            builder.memoryQuota(json.memoryQuota);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.uptime != null) {
            builder.uptime(json.uptime);
        }
        if (json.usage != null) {
            builder.usage(json.usage);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private Long diskQuota;
        private Long fdsQuota;
        private String host;
        private Integer index;
        private List<PortMapping> instancePorts = null;
        private Long memoryQuota;
        private String state;
        private String type;
        private Long uptime;
        private ProcessUsage usage;

        private Builder() {
        }

        public final Builder from(ProcessStatistics instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ProcessStatisticsResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ProcessStatisticsResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof ProcessStatistics) {
                Long uptimeValue;
                List<PortMapping> instancePortsValue;
                Long diskQuotaValue;
                String typeValue;
                String stateValue;
                Long memoryQuotaValue;
                Integer indexValue;
                String hostValue;
                ProcessUsage usageValue;
                ProcessStatistics instance = (ProcessStatistics)object;
                Long fdsQuotaValue = instance.getFdsQuota();
                if (fdsQuotaValue != null) {
                    this.fdsQuota(fdsQuotaValue);
                }
                if ((usageValue = instance.getUsage()) != null) {
                    this.usage(usageValue);
                }
                if ((hostValue = instance.getHost()) != null) {
                    this.host(hostValue);
                }
                if ((indexValue = instance.getIndex()) != null) {
                    this.index(indexValue);
                }
                if ((memoryQuotaValue = instance.getMemoryQuota()) != null) {
                    this.memoryQuota(memoryQuotaValue);
                }
                if ((stateValue = instance.getState()) != null) {
                    this.state(stateValue);
                }
                if ((typeValue = instance.getType()) != null) {
                    this.type(typeValue);
                }
                if ((diskQuotaValue = instance.getDiskQuota()) != null) {
                    this.diskQuota(diskQuotaValue);
                }
                if ((instancePortsValue = instance.getInstancePorts()) != null) {
                    this.addAllInstancePorts(instancePortsValue);
                }
                if ((uptimeValue = instance.getUptime()) != null) {
                    this.uptime(uptimeValue);
                }
            }
        }

        public final Builder diskQuota(@Nullable Long diskQuota) {
            this.diskQuota = diskQuota;
            return this;
        }

        public final Builder fdsQuota(@Nullable Long fdsQuota) {
            this.fdsQuota = fdsQuota;
            return this;
        }

        public final Builder host(@Nullable String host) {
            this.host = host;
            return this;
        }

        public final Builder index(@Nullable Integer index) {
            this.index = index;
            return this;
        }

        public final Builder instancePort(PortMapping element) {
            if (this.instancePorts == null) {
                this.instancePorts = new ArrayList<PortMapping>();
            }
            this.instancePorts.add(Objects.requireNonNull(element, "instancePorts element"));
            return this;
        }

        public final Builder instancePort(PortMapping ... elements) {
            if (this.instancePorts == null) {
                this.instancePorts = new ArrayList<PortMapping>();
            }
            for (PortMapping element : elements) {
                this.instancePorts.add(Objects.requireNonNull(element, "instancePorts element"));
            }
            return this;
        }

        public final Builder instancePorts(@Nullable Iterable<? extends PortMapping> elements) {
            if (elements == null) {
                this.instancePorts = null;
                return this;
            }
            this.instancePorts = new ArrayList<PortMapping>();
            return this.addAllInstancePorts(elements);
        }

        public final Builder addAllInstancePorts(Iterable<? extends PortMapping> elements) {
            Objects.requireNonNull(elements, "instancePorts element");
            if (this.instancePorts == null) {
                this.instancePorts = new ArrayList<PortMapping>();
            }
            for (PortMapping portMapping : elements) {
                this.instancePorts.add(Objects.requireNonNull(portMapping, "instancePorts element"));
            }
            return this;
        }

        public final Builder memoryQuota(@Nullable Long memoryQuota) {
            this.memoryQuota = memoryQuota;
            return this;
        }

        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public final Builder uptime(@Nullable Long uptime) {
            this.uptime = uptime;
            return this;
        }

        public final Builder usage(@Nullable ProcessUsage usage) {
            this.usage = usage;
            return this;
        }

        public ProcessStatisticsResource build() {
            return new ProcessStatisticsResource(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ProcessStatisticsResource {
        Long diskQuota;
        Long fdsQuota;
        String host;
        Integer index;
        List<PortMapping> instancePorts = null;
        Long memoryQuota;
        String state;
        String type;
        Long uptime;
        ProcessUsage usage;

        Json() {
        }

        @JsonProperty(value="disk_quota")
        public void setDiskQuota(@Nullable Long diskQuota) {
            this.diskQuota = diskQuota;
        }

        @JsonProperty(value="fds_quota")
        public void setFdsQuota(@Nullable Long fdsQuota) {
            this.fdsQuota = fdsQuota;
        }

        @JsonProperty(value="host")
        public void setHost(@Nullable String host) {
            this.host = host;
        }

        @JsonProperty(value="index")
        public void setIndex(@Nullable Integer index) {
            this.index = index;
        }

        @JsonProperty(value="instance_ports")
        public void setInstancePorts(@Nullable List<PortMapping> instancePorts) {
            this.instancePorts = instancePorts;
        }

        @JsonProperty(value="mem_quota")
        public void setMemoryQuota(@Nullable Long memoryQuota) {
            this.memoryQuota = memoryQuota;
        }

        @JsonProperty(value="state")
        public void setState(@Nullable String state) {
            this.state = state;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="uptime")
        public void setUptime(@Nullable Long uptime) {
            this.uptime = uptime;
        }

        @JsonProperty(value="usage")
        public void setUsage(@Nullable ProcessUsage usage) {
            this.usage = usage;
        }

        @Override
        public Long getDiskQuota() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getFdsQuota() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PortMapping> getInstancePorts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getMemoryQuota() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getUptime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ProcessUsage getUsage() {
            throw new UnsupportedOperationException();
        }
    }
}

