/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.processes.HealthCheck;
import org.cloudfoundry.client.v3.processes._UpdateProcessRequest;

public final class UpdateProcessRequest
extends _UpdateProcessRequest {
    private final String command;
    @Nullable
    private final HealthCheck healthCheck;
    @Nullable
    private final List<Integer> ports;
    private final String processId;

    private UpdateProcessRequest(Builder builder) {
        this.command = builder.command;
        this.healthCheck = builder.healthCheck;
        this.ports = builder.ports == null ? null : UpdateProcessRequest.createUnmodifiableList(true, builder.ports);
        this.processId = builder.processId;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    @Nullable
    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    @Override
    @Nullable
    public List<Integer> getPorts() {
        return this.ports;
    }

    @Override
    public String getProcessId() {
        return this.processId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateProcessRequest && this.equalTo((UpdateProcessRequest)another);
    }

    private boolean equalTo(UpdateProcessRequest another) {
        return this.command.equals(another.command) && Objects.equals(this.healthCheck, another.healthCheck) && Objects.equals(this.ports, another.ports) && this.processId.equals(another.processId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.command.hashCode();
        h = h * 17 + Objects.hashCode(this.healthCheck);
        h = h * 17 + Objects.hashCode(this.ports);
        h = h * 17 + this.processId.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateProcessRequest{command=" + this.command + ", healthCheck=" + this.healthCheck + ", ports=" + this.ports + ", processId=" + this.processId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_COMMAND = 1L;
        private static final long INIT_BIT_PROCESS_ID = 2L;
        private long initBits = 3L;
        private String command;
        private HealthCheck healthCheck;
        private List<Integer> ports = null;
        private String processId;

        private Builder() {
        }

        public final Builder from(UpdateProcessRequest instance) {
            return this.from((_UpdateProcessRequest)instance);
        }

        final Builder from(_UpdateProcessRequest instance) {
            List<Integer> portsValue;
            Objects.requireNonNull(instance, "instance");
            this.command(instance.getCommand());
            HealthCheck healthCheckValue = instance.getHealthCheck();
            if (healthCheckValue != null) {
                this.healthCheck(healthCheckValue);
            }
            if ((portsValue = instance.getPorts()) != null) {
                this.addAllPorts(portsValue);
            }
            this.processId(instance.getProcessId());
            return this;
        }

        public final Builder command(String command) {
            this.command = Objects.requireNonNull(command, "command");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder healthCheck(@Nullable HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final Builder port(int element) {
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            this.ports.add(element);
            return this;
        }

        public final Builder port(int ... elements) {
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.ports.add(element);
            }
            return this;
        }

        public final Builder ports(@Nullable Iterable<Integer> elements) {
            if (elements == null) {
                this.ports = null;
                return this;
            }
            this.ports = new ArrayList<Integer>();
            return this.addAllPorts(elements);
        }

        public final Builder addAllPorts(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "ports element");
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.ports.add(Objects.requireNonNull(Integer.valueOf(element), "ports element"));
            }
            return this;
        }

        public final Builder processId(String processId) {
            this.processId = Objects.requireNonNull(processId, "processId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public UpdateProcessRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateProcessRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("command");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("processId");
            }
            return "Cannot build UpdateProcessRequest, some of required attributes are not set " + attributes;
        }
    }
}

