/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.tasks;

import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.tasks._ListTasksRequest;

public final class ListTasksRequest
extends _ListTasksRequest {
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;

    private ListTasksRequest(Builder builder) {
        this.page = builder.page;
        this.perPage = builder.perPage;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListTasksRequest && this.equalTo((ListTasksRequest)another);
    }

    private boolean equalTo(ListTasksRequest another) {
        return Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.page);
        h = h * 17 + Objects.hashCode(this.perPage);
        return h;
    }

    public String toString() {
        return "ListTasksRequest{page=" + this.page + ", perPage=" + this.perPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer page;
        private Integer perPage;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListTasksRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListTasksRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                PaginatedRequest instance = (PaginatedRequest)object;
                Integer perPageValue = instance.getPerPage();
                if (perPageValue != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public ListTasksRequest build() {
            return new ListTasksRequest(this);
        }
    }
}

