/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.doppler.Method;
import org.cloudfoundry.doppler.PeerType;
import org.cloudfoundry.doppler._HttpStart;

public final class HttpStart
extends _HttpStart {
    @Nullable
    private final UUID applicationId;
    @Nullable
    private final String instanceId;
    @Nullable
    private final Integer instanceIndex;
    private final Method method;
    @Nullable
    private final UUID parentRequestId;
    private final PeerType peerType;
    private final String remoteAddress;
    private final UUID requestId;
    private final Long timestamp;
    private final String uri;
    private final String userAgent;

    private HttpStart(Builder builder) {
        this.applicationId = builder.applicationId;
        this.instanceId = builder.instanceId;
        this.instanceIndex = builder.instanceIndex;
        this.method = builder.method;
        this.parentRequestId = builder.parentRequestId;
        this.peerType = builder.peerType;
        this.remoteAddress = builder.remoteAddress;
        this.requestId = builder.requestId;
        this.timestamp = builder.timestamp;
        this.uri = builder.uri;
        this.userAgent = builder.userAgent;
    }

    @Override
    @Nullable
    public UUID getApplicationId() {
        return this.applicationId;
    }

    @Override
    @Nullable
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    @Nullable
    public Integer getInstanceIndex() {
        return this.instanceIndex;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    @Nullable
    public UUID getParentRequestId() {
        return this.parentRequestId;
    }

    @Override
    public PeerType getPeerType() {
        return this.peerType;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public UUID getRequestId() {
        return this.requestId;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof HttpStart && this.equalTo((HttpStart)another);
    }

    private boolean equalTo(HttpStart another) {
        return Objects.equals(this.applicationId, another.applicationId) && Objects.equals(this.instanceId, another.instanceId) && Objects.equals(this.instanceIndex, another.instanceIndex) && this.method.equals((Object)another.method) && Objects.equals(this.parentRequestId, another.parentRequestId) && this.peerType.equals((Object)another.peerType) && this.remoteAddress.equals(another.remoteAddress) && this.requestId.equals(another.requestId) && this.timestamp.equals(another.timestamp) && this.uri.equals(another.uri) && this.userAgent.equals(another.userAgent);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.applicationId);
        h = h * 17 + Objects.hashCode(this.instanceId);
        h = h * 17 + Objects.hashCode(this.instanceIndex);
        h = h * 17 + this.method.hashCode();
        h = h * 17 + Objects.hashCode(this.parentRequestId);
        h = h * 17 + this.peerType.hashCode();
        h = h * 17 + this.remoteAddress.hashCode();
        h = h * 17 + this.requestId.hashCode();
        h = h * 17 + this.timestamp.hashCode();
        h = h * 17 + this.uri.hashCode();
        h = h * 17 + this.userAgent.hashCode();
        return h;
    }

    public String toString() {
        return "HttpStart{applicationId=" + this.applicationId + ", instanceId=" + this.instanceId + ", instanceIndex=" + this.instanceIndex + ", method=" + (Object)((Object)this.method) + ", parentRequestId=" + this.parentRequestId + ", peerType=" + (Object)((Object)this.peerType) + ", remoteAddress=" + this.remoteAddress + ", requestId=" + this.requestId + ", timestamp=" + this.timestamp + ", uri=" + this.uri + ", userAgent=" + this.userAgent + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_METHOD = 1L;
        private static final long INIT_BIT_PEER_TYPE = 2L;
        private static final long INIT_BIT_REMOTE_ADDRESS = 4L;
        private static final long INIT_BIT_REQUEST_ID = 8L;
        private static final long INIT_BIT_TIMESTAMP = 16L;
        private static final long INIT_BIT_URI = 32L;
        private static final long INIT_BIT_USER_AGENT = 64L;
        private long initBits = 127L;
        private UUID applicationId;
        private String instanceId;
        private Integer instanceIndex;
        private Method method;
        private UUID parentRequestId;
        private PeerType peerType;
        private String remoteAddress;
        private UUID requestId;
        private Long timestamp;
        private String uri;
        private String userAgent;

        private Builder() {
        }

        public final Builder from(HttpStart instance) {
            return this.from((_HttpStart)instance);
        }

        final Builder from(_HttpStart instance) {
            Integer instanceIndexValue;
            String instanceIdValue;
            Objects.requireNonNull(instance, "instance");
            UUID applicationIdValue = instance.getApplicationId();
            if (applicationIdValue != null) {
                this.applicationId(applicationIdValue);
            }
            if ((instanceIdValue = instance.getInstanceId()) != null) {
                this.instanceId(instanceIdValue);
            }
            if ((instanceIndexValue = instance.getInstanceIndex()) != null) {
                this.instanceIndex(instanceIndexValue);
            }
            this.method(instance.getMethod());
            UUID parentRequestIdValue = instance.getParentRequestId();
            if (parentRequestIdValue != null) {
                this.parentRequestId(parentRequestIdValue);
            }
            this.peerType(instance.getPeerType());
            this.remoteAddress(instance.getRemoteAddress());
            this.requestId(instance.getRequestId());
            this.timestamp(instance.getTimestamp());
            this.uri(instance.getUri());
            this.userAgent(instance.getUserAgent());
            return this;
        }

        public final Builder applicationId(@Nullable UUID applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Builder instanceId(@Nullable String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Builder instanceIndex(@Nullable Integer instanceIndex) {
            this.instanceIndex = instanceIndex;
            return this;
        }

        public final Builder method(Method method) {
            this.method = Objects.requireNonNull(method, "method");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder parentRequestId(@Nullable UUID parentRequestId) {
            this.parentRequestId = parentRequestId;
            return this;
        }

        public final Builder peerType(PeerType peerType) {
            this.peerType = Objects.requireNonNull(peerType, "peerType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder remoteAddress(String remoteAddress) {
            this.remoteAddress = Objects.requireNonNull(remoteAddress, "remoteAddress");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder requestId(UUID requestId) {
            this.requestId = Objects.requireNonNull(requestId, "requestId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder timestamp(Long timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder uri(String uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder userAgent(String userAgent) {
            this.userAgent = Objects.requireNonNull(userAgent, "userAgent");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public HttpStart build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new HttpStart(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("method");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("peerType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("remoteAddress");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("requestId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("timestamp");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("uri");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("userAgent");
            }
            return "Cannot build HttpStart, some of required attributes are not set " + attributes;
        }
    }
}

