/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.clients.CreateClient;
import org.cloudfoundry.uaa.clients._BatchCreateClientsRequest;

public final class BatchCreateClientsRequest
extends _BatchCreateClientsRequest {
    @Nullable
    private final List<CreateClient> clients;
    @Nullable
    private final String identityZoneId;

    private BatchCreateClientsRequest(Builder builder) {
        this.clients = builder.clients == null ? null : BatchCreateClientsRequest.createUnmodifiableList(true, builder.clients);
        this.identityZoneId = builder.identityZoneId;
    }

    @Override
    @JsonProperty(value="clients")
    @JsonIgnore
    @Nullable
    public List<CreateClient> getClients() {
        return this.clients;
    }

    @Override
    @JsonProperty(value="identityZoneId")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BatchCreateClientsRequest && this.equalTo((BatchCreateClientsRequest)another);
    }

    private boolean equalTo(BatchCreateClientsRequest another) {
        return Objects.equals(this.clients, another.clients) && Objects.equals(this.identityZoneId, another.identityZoneId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.clients);
        h = h * 17 + Objects.hashCode(this.identityZoneId);
        return h;
    }

    public String toString() {
        return "BatchCreateClientsRequest{clients=" + this.clients + ", identityZoneId=" + this.identityZoneId + "}";
    }

    @Deprecated
    @JsonCreator
    static BatchCreateClientsRequest fromJson(Json json) {
        Builder builder = BatchCreateClientsRequest.builder();
        if (json.clients != null) {
            builder.addAllClients(json.clients);
        }
        if (json.identityZoneId != null) {
            builder.identityZoneId(json.identityZoneId);
        }
        return builder.build();
    }

    private static BatchCreateClientsRequest validate(BatchCreateClientsRequest instance) {
        instance.checkClients();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<CreateClient> clients = null;
        private String identityZoneId;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BatchCreateClientsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_BatchCreateClientsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            List<CreateClient> clientsValue;
            IdentityZoned instance;
            String identityZoneIdValue;
            if (object instanceof IdentityZoned && (identityZoneIdValue = (instance = (IdentityZoned)object).getIdentityZoneId()) != null) {
                this.identityZoneId(identityZoneIdValue);
            }
            if (object instanceof _BatchCreateClientsRequest && (clientsValue = ((_BatchCreateClientsRequest)(instance = (_BatchCreateClientsRequest)object)).getClients()) != null) {
                this.addAllClients(clientsValue);
            }
        }

        public final Builder client(CreateClient element) {
            if (this.clients == null) {
                this.clients = new ArrayList<CreateClient>();
            }
            this.clients.add(Objects.requireNonNull(element, "clients element"));
            return this;
        }

        public final Builder client(CreateClient ... elements) {
            if (this.clients == null) {
                this.clients = new ArrayList<CreateClient>();
            }
            for (CreateClient element : elements) {
                this.clients.add(Objects.requireNonNull(element, "clients element"));
            }
            return this;
        }

        public final Builder clients(@Nullable Iterable<? extends CreateClient> elements) {
            if (elements == null) {
                this.clients = null;
                return this;
            }
            this.clients = new ArrayList<CreateClient>();
            return this.addAllClients(elements);
        }

        public final Builder addAllClients(Iterable<? extends CreateClient> elements) {
            Objects.requireNonNull(elements, "clients element");
            if (this.clients == null) {
                this.clients = new ArrayList<CreateClient>();
            }
            for (CreateClient createClient : elements) {
                this.clients.add(Objects.requireNonNull(createClient, "clients element"));
            }
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public BatchCreateClientsRequest build() {
            return BatchCreateClientsRequest.validate(new BatchCreateClientsRequest(this));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _BatchCreateClientsRequest {
        List<CreateClient> clients = null;
        String identityZoneId;

        Json() {
        }

        @JsonProperty(value="clients")
        @JsonIgnore
        public void setClients(@Nullable List<CreateClient> clients) {
            this.clients = clients;
        }

        @JsonProperty(value="identityZoneId")
        @JsonIgnore
        public void setIdentityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
        }

        @Override
        public List<CreateClient> getClients() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneId() {
            throw new UnsupportedOperationException();
        }
    }
}

