/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.clients;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.clients._GetMetadataRequest;

public final class GetMetadataRequest
extends _GetMetadataRequest {
    private final String clientId;
    @Nullable
    private final String identityZoneId;

    private GetMetadataRequest(Builder builder) {
        this.clientId = builder.clientId;
        this.identityZoneId = builder.identityZoneId;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetMetadataRequest && this.equalTo((GetMetadataRequest)another);
    }

    private boolean equalTo(GetMetadataRequest another) {
        return this.clientId.equals(another.clientId) && Objects.equals(this.identityZoneId, another.identityZoneId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.clientId.hashCode();
        h = h * 17 + Objects.hashCode(this.identityZoneId);
        return h;
    }

    public String toString() {
        return "GetMetadataRequest{clientId=" + this.clientId + ", identityZoneId=" + this.identityZoneId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private long initBits = 1L;
        private String clientId;
        private String identityZoneId;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetMetadataRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_GetMetadataRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IdentityZoned instance;
            String identityZoneIdValue;
            if (object instanceof IdentityZoned && (identityZoneIdValue = (instance = (IdentityZoned)object).getIdentityZoneId()) != null) {
                this.identityZoneId(identityZoneIdValue);
            }
            if (object instanceof _GetMetadataRequest) {
                instance = (_GetMetadataRequest)object;
                this.clientId(((_GetMetadataRequest)instance).getClientId());
            }
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public GetMetadataRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetMetadataRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            return "Cannot build GetMetadataRequest, some of required attributes are not set " + attributes;
        }
    }
}

