/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.clients.AbstractClient;
import org.cloudfoundry.uaa.clients._UpdateClientResponse;
import org.cloudfoundry.uaa.tokens.GrantType;

public final class UpdateClientResponse
extends _UpdateClientResponse {
    @Nullable
    private final Long accessTokenValidity;
    @Nullable
    private final String action;
    @Nullable
    private final List<String> allowedProviders;
    @Nullable
    private final Boolean approvalsDeleted;
    private final List<String> authorities;
    private final List<GrantType> authorizedGrantTypes;
    private final List<String> autoApproves;
    private final String clientId;
    @Nullable
    private final String createdWith;
    @Nullable
    private final Long lastModified;
    @Nullable
    private final String name;
    @Nullable
    private final List<String> redirectUriPatterns;
    @Nullable
    private final Long refreshTokenValidity;
    private final List<String> resourceIds;
    private final List<String> scopes;
    @Nullable
    private final String tokenSalt;

    private UpdateClientResponse(Builder builder) {
        this.accessTokenValidity = builder.accessTokenValidity;
        this.action = builder.action;
        this.allowedProviders = builder.allowedProviders == null ? null : UpdateClientResponse.createUnmodifiableList(true, builder.allowedProviders);
        this.approvalsDeleted = builder.approvalsDeleted;
        this.authorities = UpdateClientResponse.createUnmodifiableList(true, builder.authorities);
        this.authorizedGrantTypes = UpdateClientResponse.createUnmodifiableList(true, builder.authorizedGrantTypes);
        this.autoApproves = UpdateClientResponse.createUnmodifiableList(true, builder.autoApproves);
        this.clientId = builder.clientId;
        this.createdWith = builder.createdWith;
        this.lastModified = builder.lastModified;
        this.name = builder.name;
        this.redirectUriPatterns = builder.redirectUriPatterns == null ? null : UpdateClientResponse.createUnmodifiableList(true, builder.redirectUriPatterns);
        this.refreshTokenValidity = builder.refreshTokenValidity;
        this.resourceIds = UpdateClientResponse.createUnmodifiableList(true, builder.resourceIds);
        this.scopes = UpdateClientResponse.createUnmodifiableList(true, builder.scopes);
        this.tokenSalt = builder.tokenSalt;
    }

    @Override
    @JsonProperty(value="access_token_validity")
    @Nullable
    public Long getAccessTokenValidity() {
        return this.accessTokenValidity;
    }

    @Override
    @JsonProperty(value="action")
    @Nullable
    public String getAction() {
        return this.action;
    }

    @Override
    @JsonProperty(value="allowedproviders")
    @Nullable
    public List<String> getAllowedProviders() {
        return this.allowedProviders;
    }

    @Override
    @JsonProperty(value="approvals_deleted")
    @Nullable
    public Boolean getApprovalsDeleted() {
        return this.approvalsDeleted;
    }

    @Override
    @JsonProperty(value="authorities")
    public List<String> getAuthorities() {
        return this.authorities;
    }

    @Override
    @JsonProperty(value="authorized_grant_types")
    public List<GrantType> getAuthorizedGrantTypes() {
        return this.authorizedGrantTypes;
    }

    @Override
    @JsonProperty(value="autoapprove")
    public List<String> getAutoApproves() {
        return this.autoApproves;
    }

    @Override
    @JsonProperty(value="client_id")
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="createdwith")
    @Nullable
    public String getCreatedWith() {
        return this.createdWith;
    }

    @Override
    @JsonProperty(value="lastModified")
    @Nullable
    public Long getLastModified() {
        return this.lastModified;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="redirect_uri")
    @Nullable
    public List<String> getRedirectUriPatterns() {
        return this.redirectUriPatterns;
    }

    @Override
    @JsonProperty(value="refresh_token_validity")
    @Nullable
    public Long getRefreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    @Override
    @JsonProperty(value="resource_ids")
    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    @Override
    @JsonProperty(value="scope")
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    @JsonProperty(value="token_salt")
    @Nullable
    public String getTokenSalt() {
        return this.tokenSalt;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateClientResponse && this.equalTo((UpdateClientResponse)another);
    }

    private boolean equalTo(UpdateClientResponse another) {
        return Objects.equals(this.accessTokenValidity, another.accessTokenValidity) && Objects.equals(this.action, another.action) && Objects.equals(this.allowedProviders, another.allowedProviders) && Objects.equals(this.approvalsDeleted, another.approvalsDeleted) && this.authorities.equals(another.authorities) && this.authorizedGrantTypes.equals(another.authorizedGrantTypes) && this.autoApproves.equals(another.autoApproves) && this.clientId.equals(another.clientId) && Objects.equals(this.createdWith, another.createdWith) && Objects.equals(this.lastModified, another.lastModified) && Objects.equals(this.name, another.name) && Objects.equals(this.redirectUriPatterns, another.redirectUriPatterns) && Objects.equals(this.refreshTokenValidity, another.refreshTokenValidity) && this.resourceIds.equals(another.resourceIds) && this.scopes.equals(another.scopes) && Objects.equals(this.tokenSalt, another.tokenSalt);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.accessTokenValidity);
        h = h * 17 + Objects.hashCode(this.action);
        h = h * 17 + Objects.hashCode(this.allowedProviders);
        h = h * 17 + Objects.hashCode(this.approvalsDeleted);
        h = h * 17 + this.authorities.hashCode();
        h = h * 17 + this.authorizedGrantTypes.hashCode();
        h = h * 17 + this.autoApproves.hashCode();
        h = h * 17 + this.clientId.hashCode();
        h = h * 17 + Objects.hashCode(this.createdWith);
        h = h * 17 + Objects.hashCode(this.lastModified);
        h = h * 17 + Objects.hashCode(this.name);
        h = h * 17 + Objects.hashCode(this.redirectUriPatterns);
        h = h * 17 + Objects.hashCode(this.refreshTokenValidity);
        h = h * 17 + this.resourceIds.hashCode();
        h = h * 17 + this.scopes.hashCode();
        h = h * 17 + Objects.hashCode(this.tokenSalt);
        return h;
    }

    public String toString() {
        return "UpdateClientResponse{accessTokenValidity=" + this.accessTokenValidity + ", action=" + this.action + ", allowedProviders=" + this.allowedProviders + ", approvalsDeleted=" + this.approvalsDeleted + ", authorities=" + this.authorities + ", authorizedGrantTypes=" + this.authorizedGrantTypes + ", autoApproves=" + this.autoApproves + ", clientId=" + this.clientId + ", createdWith=" + this.createdWith + ", lastModified=" + this.lastModified + ", name=" + this.name + ", redirectUriPatterns=" + this.redirectUriPatterns + ", refreshTokenValidity=" + this.refreshTokenValidity + ", resourceIds=" + this.resourceIds + ", scopes=" + this.scopes + ", tokenSalt=" + this.tokenSalt + "}";
    }

    @Deprecated
    @JsonCreator
    static UpdateClientResponse fromJson(Json json) {
        Builder builder = UpdateClientResponse.builder();
        if (json.accessTokenValidity != null) {
            builder.accessTokenValidity(json.accessTokenValidity);
        }
        if (json.action != null) {
            builder.action(json.action);
        }
        if (json.allowedProviders != null) {
            builder.addAllAllowedProviders(json.allowedProviders);
        }
        if (json.approvalsDeleted != null) {
            builder.approvalsDeleted(json.approvalsDeleted);
        }
        if (json.authorities != null) {
            builder.addAllAuthorities(json.authorities);
        }
        if (json.authorizedGrantTypes != null) {
            builder.addAllAuthorizedGrantTypes(json.authorizedGrantTypes);
        }
        if (json.autoApproves != null) {
            builder.addAllAutoApproves(json.autoApproves);
        }
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        if (json.createdWith != null) {
            builder.createdWith(json.createdWith);
        }
        if (json.lastModified != null) {
            builder.lastModified(json.lastModified);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.redirectUriPatterns != null) {
            builder.addAllRedirectUriPatterns(json.redirectUriPatterns);
        }
        if (json.refreshTokenValidity != null) {
            builder.refreshTokenValidity(json.refreshTokenValidity);
        }
        if (json.resourceIds != null) {
            builder.addAllResourceIds(json.resourceIds);
        }
        if (json.scopes != null) {
            builder.addAllScopes(json.scopes);
        }
        if (json.tokenSalt != null) {
            builder.tokenSalt(json.tokenSalt);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private long initBits = 1L;
        private Long accessTokenValidity;
        private String action;
        private List<String> allowedProviders = null;
        private Boolean approvalsDeleted;
        private List<String> authorities = new ArrayList<String>();
        private List<GrantType> authorizedGrantTypes = new ArrayList<GrantType>();
        private List<String> autoApproves = new ArrayList<String>();
        private String clientId;
        private String createdWith;
        private Long lastModified;
        private String name;
        private List<String> redirectUriPatterns = null;
        private Long refreshTokenValidity;
        private List<String> resourceIds = new ArrayList<String>();
        private List<String> scopes = new ArrayList<String>();
        private String tokenSalt;

        private Builder() {
        }

        public final Builder from(AbstractClient instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateClientResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_UpdateClientResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof AbstractClient) {
                Long lastModifiedValue;
                Boolean approvalsDeletedValue;
                String actionValue;
                String nameValue;
                Long accessTokenValidityValue;
                List<String> redirectUriPatternsValue;
                AbstractClient instance = (AbstractClient)object;
                this.addAllAuthorizedGrantTypes(instance.getAuthorizedGrantTypes());
                String tokenSaltValue = instance.getTokenSalt();
                if (tokenSaltValue != null) {
                    this.tokenSalt(tokenSaltValue);
                }
                this.clientId(instance.getClientId());
                String createdWithValue = instance.getCreatedWith();
                if (createdWithValue != null) {
                    this.createdWith(createdWithValue);
                }
                if ((redirectUriPatternsValue = instance.getRedirectUriPatterns()) != null) {
                    this.addAllRedirectUriPatterns(redirectUriPatternsValue);
                }
                if ((accessTokenValidityValue = instance.getAccessTokenValidity()) != null) {
                    this.accessTokenValidity(accessTokenValidityValue);
                }
                this.addAllAuthorities(instance.getAuthorities());
                Long refreshTokenValidityValue = instance.getRefreshTokenValidity();
                if (refreshTokenValidityValue != null) {
                    this.refreshTokenValidity(refreshTokenValidityValue);
                }
                if ((nameValue = instance.getName()) != null) {
                    this.name(nameValue);
                }
                if ((actionValue = instance.getAction()) != null) {
                    this.action(actionValue);
                }
                if ((approvalsDeletedValue = instance.getApprovalsDeleted()) != null) {
                    this.approvalsDeleted(approvalsDeletedValue);
                }
                if ((lastModifiedValue = instance.getLastModified()) != null) {
                    this.lastModified(lastModifiedValue);
                }
                this.addAllScopes(instance.getScopes());
                this.addAllAutoApproves(instance.getAutoApproves());
                List<String> allowedProvidersValue = instance.getAllowedProviders();
                if (allowedProvidersValue != null) {
                    this.addAllAllowedProviders(allowedProvidersValue);
                }
                this.addAllResourceIds(instance.getResourceIds());
            }
        }

        public final Builder accessTokenValidity(@Nullable Long accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
            return this;
        }

        public final Builder action(@Nullable String action) {
            this.action = action;
            return this;
        }

        public final Builder allowedProvider(String element) {
            if (this.allowedProviders == null) {
                this.allowedProviders = new ArrayList<String>();
            }
            this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
            return this;
        }

        public final Builder allowedProvider(String ... elements) {
            if (this.allowedProviders == null) {
                this.allowedProviders = new ArrayList<String>();
            }
            for (String element : elements) {
                this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
            }
            return this;
        }

        public final Builder allowedProviders(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.allowedProviders = null;
                return this;
            }
            this.allowedProviders = new ArrayList<String>();
            return this.addAllAllowedProviders(elements);
        }

        public final Builder addAllAllowedProviders(Iterable<String> elements) {
            Objects.requireNonNull(elements, "allowedProviders element");
            if (this.allowedProviders == null) {
                this.allowedProviders = new ArrayList<String>();
            }
            for (String element : elements) {
                this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
            }
            return this;
        }

        public final Builder approvalsDeleted(@Nullable Boolean approvalsDeleted) {
            this.approvalsDeleted = approvalsDeleted;
            return this;
        }

        public final Builder authority(String element) {
            this.authorities.add(Objects.requireNonNull(element, "authorities element"));
            return this;
        }

        public final Builder authority(String ... elements) {
            for (String element : elements) {
                this.authorities.add(Objects.requireNonNull(element, "authorities element"));
            }
            return this;
        }

        public final Builder authorities(Iterable<String> elements) {
            this.authorities.clear();
            return this.addAllAuthorities(elements);
        }

        public final Builder addAllAuthorities(Iterable<String> elements) {
            for (String element : elements) {
                this.authorities.add(Objects.requireNonNull(element, "authorities element"));
            }
            return this;
        }

        public final Builder authorizedGrantType(GrantType element) {
            this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
            return this;
        }

        public final Builder authorizedGrantType(GrantType ... elements) {
            for (GrantType element : elements) {
                this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
            }
            return this;
        }

        public final Builder authorizedGrantTypes(Iterable<? extends GrantType> elements) {
            this.authorizedGrantTypes.clear();
            return this.addAllAuthorizedGrantTypes(elements);
        }

        public final Builder addAllAuthorizedGrantTypes(Iterable<? extends GrantType> elements) {
            for (GrantType grantType : elements) {
                this.authorizedGrantTypes.add(Objects.requireNonNull(grantType, "authorizedGrantTypes element"));
            }
            return this;
        }

        public final Builder autoApprove(String element) {
            this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
            return this;
        }

        public final Builder autoApprove(String ... elements) {
            for (String element : elements) {
                this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
            }
            return this;
        }

        public final Builder autoApproves(Iterable<String> elements) {
            this.autoApproves.clear();
            return this.addAllAutoApproves(elements);
        }

        public final Builder addAllAutoApproves(Iterable<String> elements) {
            for (String element : elements) {
                this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
            }
            return this;
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder createdWith(@Nullable String createdWith) {
            this.createdWith = createdWith;
            return this;
        }

        public final Builder lastModified(@Nullable Long lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder redirectUriPattern(String element) {
            if (this.redirectUriPatterns == null) {
                this.redirectUriPatterns = new ArrayList<String>();
            }
            this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
            return this;
        }

        public final Builder redirectUriPattern(String ... elements) {
            if (this.redirectUriPatterns == null) {
                this.redirectUriPatterns = new ArrayList<String>();
            }
            for (String element : elements) {
                this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
            }
            return this;
        }

        public final Builder redirectUriPatterns(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.redirectUriPatterns = null;
                return this;
            }
            this.redirectUriPatterns = new ArrayList<String>();
            return this.addAllRedirectUriPatterns(elements);
        }

        public final Builder addAllRedirectUriPatterns(Iterable<String> elements) {
            Objects.requireNonNull(elements, "redirectUriPatterns element");
            if (this.redirectUriPatterns == null) {
                this.redirectUriPatterns = new ArrayList<String>();
            }
            for (String element : elements) {
                this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
            }
            return this;
        }

        public final Builder refreshTokenValidity(@Nullable Long refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
            return this;
        }

        public final Builder resourceId(String element) {
            this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
            return this;
        }

        public final Builder resourceId(String ... elements) {
            for (String element : elements) {
                this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
            }
            return this;
        }

        public final Builder resourceIds(Iterable<String> elements) {
            this.resourceIds.clear();
            return this.addAllResourceIds(elements);
        }

        public final Builder addAllResourceIds(Iterable<String> elements) {
            for (String element : elements) {
                this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
            }
            return this;
        }

        public final Builder scope(String element) {
            this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            return this;
        }

        public final Builder scope(String ... elements) {
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        public final Builder scopes(Iterable<String> elements) {
            this.scopes.clear();
            return this.addAllScopes(elements);
        }

        public final Builder addAllScopes(Iterable<String> elements) {
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        public final Builder tokenSalt(@Nullable String tokenSalt) {
            this.tokenSalt = tokenSalt;
            return this;
        }

        public UpdateClientResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateClientResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            return "Cannot build UpdateClientResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _UpdateClientResponse {
        Long accessTokenValidity;
        String action;
        List<String> allowedProviders = null;
        Boolean approvalsDeleted;
        List<String> authorities = Collections.emptyList();
        List<GrantType> authorizedGrantTypes = Collections.emptyList();
        List<String> autoApproves = Collections.emptyList();
        String clientId;
        String createdWith;
        Long lastModified;
        String name;
        List<String> redirectUriPatterns = null;
        Long refreshTokenValidity;
        List<String> resourceIds = Collections.emptyList();
        List<String> scopes = Collections.emptyList();
        String tokenSalt;

        Json() {
        }

        @JsonProperty(value="access_token_validity")
        public void setAccessTokenValidity(@Nullable Long accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
        }

        @JsonProperty(value="action")
        public void setAction(@Nullable String action) {
            this.action = action;
        }

        @JsonProperty(value="allowedproviders")
        public void setAllowedProviders(@Nullable List<String> allowedProviders) {
            this.allowedProviders = allowedProviders;
        }

        @JsonProperty(value="approvals_deleted")
        public void setApprovalsDeleted(@Nullable Boolean approvalsDeleted) {
            this.approvalsDeleted = approvalsDeleted;
        }

        @JsonProperty(value="authorities")
        public void setAuthorities(List<String> authorities) {
            this.authorities = authorities;
        }

        @JsonProperty(value="authorized_grant_types")
        public void setAuthorizedGrantTypes(List<GrantType> authorizedGrantTypes) {
            this.authorizedGrantTypes = authorizedGrantTypes;
        }

        @JsonProperty(value="autoapprove")
        public void setAutoApproves(List<String> autoApproves) {
            this.autoApproves = autoApproves;
        }

        @JsonProperty(value="client_id")
        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @JsonProperty(value="createdwith")
        public void setCreatedWith(@Nullable String createdWith) {
            this.createdWith = createdWith;
        }

        @JsonProperty(value="lastModified")
        public void setLastModified(@Nullable Long lastModified) {
            this.lastModified = lastModified;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="redirect_uri")
        public void setRedirectUriPatterns(@Nullable List<String> redirectUriPatterns) {
            this.redirectUriPatterns = redirectUriPatterns;
        }

        @JsonProperty(value="refresh_token_validity")
        public void setRefreshTokenValidity(@Nullable Long refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
        }

        @JsonProperty(value="resource_ids")
        public void setResourceIds(List<String> resourceIds) {
            this.resourceIds = resourceIds;
        }

        @JsonProperty(value="scope")
        public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }

        @JsonProperty(value="token_salt")
        public void setTokenSalt(@Nullable String tokenSalt) {
            this.tokenSalt = tokenSalt;
        }

        @Override
        public Long getAccessTokenValidity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAction() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAllowedProviders() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getApprovalsDeleted() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAuthorities() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<GrantType> getAuthorizedGrantTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAutoApproves() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCreatedWith() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getLastModified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getRedirectUriPatterns() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getRefreshTokenValidity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getResourceIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getScopes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTokenSalt() {
            throw new UnsupportedOperationException();
        }
    }
}

