/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.clients.BatchDeleteClientsRequest;
import org.immutables.value.Value;

@JsonSerialize(using=BatchDeleteClientsSerializer.class)
@Value.Immutable
abstract class _BatchDeleteClientsRequest
implements IdentityZoned {
    _BatchDeleteClientsRequest() {
    }

    @Value.Check
    void checkClientIds() {
        if (this.getClientIds() == null) {
            throw new IllegalStateException("Cannot build BatchDeleteClientsRequest, required attribute clientIds is not set");
        }
    }

    @Nullable
    @JsonIgnore
    abstract List<String> getClientIds();

    static class BatchDeleteClientsSerializer
    extends StdSerializer<BatchDeleteClientsRequest> {
        private static final long serialVersionUID = 621601835573250942L;

        BatchDeleteClientsSerializer() {
            super(BatchDeleteClientsRequest.class);
        }

        public void serialize(BatchDeleteClientsRequest request, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeObject((Object)request.getClientIds().stream().map(clientId -> Collections.singletonMap("client_id", clientId)).toArray());
        }
    }
}

