/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.uaa.groups._CheckMembershipRequest;

public final class CheckMembershipRequest
extends _CheckMembershipRequest {
    private final String groupId;
    private final String memberId;

    private CheckMembershipRequest(Builder builder) {
        this.groupId = builder.groupId;
        this.memberId = builder.memberId;
    }

    @Override
    @JsonProperty(value="groupId")
    @JsonIgnore
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty(value="memberId")
    @JsonIgnore
    public String getMemberId() {
        return this.memberId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CheckMembershipRequest && this.equalTo((CheckMembershipRequest)another);
    }

    private boolean equalTo(CheckMembershipRequest another) {
        return this.groupId.equals(another.groupId) && this.memberId.equals(another.memberId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.groupId.hashCode();
        h = h * 17 + this.memberId.hashCode();
        return h;
    }

    public String toString() {
        return "CheckMembershipRequest{groupId=" + this.groupId + ", memberId=" + this.memberId + "}";
    }

    @Deprecated
    @JsonCreator
    static CheckMembershipRequest fromJson(Json json) {
        Builder builder = CheckMembershipRequest.builder();
        if (json.groupId != null) {
            builder.groupId(json.groupId);
        }
        if (json.memberId != null) {
            builder.memberId(json.memberId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GROUP_ID = 1L;
        private static final long INIT_BIT_MEMBER_ID = 2L;
        private long initBits = 3L;
        private String groupId;
        private String memberId;

        private Builder() {
        }

        public final Builder from(CheckMembershipRequest instance) {
            return this.from((_CheckMembershipRequest)instance);
        }

        final Builder from(_CheckMembershipRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.groupId(instance.getGroupId());
            this.memberId(instance.getMemberId());
            return this;
        }

        public final Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder memberId(String memberId) {
            this.memberId = Objects.requireNonNull(memberId, "memberId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CheckMembershipRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CheckMembershipRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("memberId");
            }
            return "Cannot build CheckMembershipRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _CheckMembershipRequest {
        String groupId;
        String memberId;

        Json() {
        }

        @JsonProperty(value="groupId")
        @JsonIgnore
        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @JsonProperty(value="memberId")
        @JsonIgnore
        public void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @Override
        public String getGroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMemberId() {
            throw new UnsupportedOperationException();
        }
    }
}

