/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.groups;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.groups._ListMembersRequest;

public final class ListMembersRequest
extends _ListMembersRequest {
    private final String groupId;
    @Nullable
    private final Boolean returnEntities;
    @Nullable
    private final String identityZoneId;

    private ListMembersRequest(Builder builder) {
        this.groupId = builder.groupId;
        this.returnEntities = builder.returnEntities;
        this.identityZoneId = builder.identityZoneId;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @Nullable
    public Boolean getReturnEntities() {
        return this.returnEntities;
    }

    @Override
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListMembersRequest && this.equalTo((ListMembersRequest)another);
    }

    private boolean equalTo(ListMembersRequest another) {
        return this.groupId.equals(another.groupId) && Objects.equals(this.returnEntities, another.returnEntities) && Objects.equals(this.identityZoneId, another.identityZoneId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.groupId.hashCode();
        h = h * 17 + Objects.hashCode(this.returnEntities);
        h = h * 17 + Objects.hashCode(this.identityZoneId);
        return h;
    }

    public String toString() {
        return "ListMembersRequest{groupId=" + this.groupId + ", returnEntities=" + this.returnEntities + ", identityZoneId=" + this.identityZoneId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_GROUP_ID = 1L;
        private long initBits = 1L;
        private String groupId;
        private Boolean returnEntities;
        private String identityZoneId;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListMembersRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListMembersRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IdentityZoned instance;
            String identityZoneIdValue;
            if (object instanceof IdentityZoned && (identityZoneIdValue = (instance = (IdentityZoned)object).getIdentityZoneId()) != null) {
                this.identityZoneId(identityZoneIdValue);
            }
            if (object instanceof _ListMembersRequest) {
                instance = (_ListMembersRequest)object;
                Boolean returnEntitiesValue = ((_ListMembersRequest)instance).getReturnEntities();
                if (returnEntitiesValue != null) {
                    this.returnEntities(returnEntitiesValue);
                }
                this.groupId(((_ListMembersRequest)instance).getGroupId());
            }
        }

        public final Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder returnEntities(@Nullable Boolean returnEntities) {
            this.returnEntities = returnEntities;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public ListMembersRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListMembersRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("groupId");
            }
            return "Cannot build ListMembersRequest, some of required attributes are not set " + attributes;
        }
    }
}

