/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityproviders;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.identityproviders.Type;
import org.cloudfoundry.uaa.identityproviders._CreateIdentityProviderRequest;

public final class CreateIdentityProviderRequest
extends _CreateIdentityProviderRequest {
    @Nullable
    private final Boolean active;
    private final String configuration;
    private final String name;
    private final String originKey;
    private final Type type;
    @Nullable
    private final String identityZoneId;

    private CreateIdentityProviderRequest(Builder builder) {
        this.active = builder.active;
        this.configuration = builder.configuration;
        this.name = builder.name;
        this.originKey = builder.originKey;
        this.type = builder.type;
        this.identityZoneId = builder.identityZoneId;
    }

    @Override
    @Nullable
    public Boolean getActive() {
        return this.active;
    }

    @Override
    public String getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOriginKey() {
        return this.originKey;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateIdentityProviderRequest && this.equalTo((CreateIdentityProviderRequest)another);
    }

    private boolean equalTo(CreateIdentityProviderRequest another) {
        return Objects.equals(this.active, another.active) && this.configuration.equals(another.configuration) && this.name.equals(another.name) && this.originKey.equals(another.originKey) && this.type.equals((Object)another.type) && Objects.equals(this.identityZoneId, another.identityZoneId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.active);
        h = h * 17 + this.configuration.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.originKey.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + Objects.hashCode(this.identityZoneId);
        return h;
    }

    public String toString() {
        return "CreateIdentityProviderRequest{active=" + this.active + ", configuration=" + this.configuration + ", name=" + this.name + ", originKey=" + this.originKey + ", type=" + (Object)((Object)this.type) + ", identityZoneId=" + this.identityZoneId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CONFIGURATION = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_ORIGIN_KEY = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private long initBits = 15L;
        private Boolean active;
        private String configuration;
        private String name;
        private String originKey;
        private Type type;
        private String identityZoneId;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CreateIdentityProviderRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_CreateIdentityProviderRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IdentityZoned instance;
            String identityZoneIdValue;
            if (object instanceof IdentityZoned && (identityZoneIdValue = (instance = (IdentityZoned)object).getIdentityZoneId()) != null) {
                this.identityZoneId(identityZoneIdValue);
            }
            if (object instanceof _CreateIdentityProviderRequest) {
                instance = (_CreateIdentityProviderRequest)object;
                this.name(((_CreateIdentityProviderRequest)instance).getName());
                Boolean activeValue = ((_CreateIdentityProviderRequest)instance).getActive();
                if (activeValue != null) {
                    this.active(activeValue);
                }
                this.type(((_CreateIdentityProviderRequest)instance).getType());
                this.configuration(((_CreateIdentityProviderRequest)instance).getConfiguration());
                this.originKey(((_CreateIdentityProviderRequest)instance).getOriginKey());
            }
        }

        public final Builder active(@Nullable Boolean active) {
            this.active = active;
            return this;
        }

        public final Builder configuration(String configuration) {
            this.configuration = Objects.requireNonNull(configuration, "configuration");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder originKey(String originKey) {
            this.originKey = Objects.requireNonNull(originKey, "originKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder type(Type type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public CreateIdentityProviderRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateIdentityProviderRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("configuration");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("originKey");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build CreateIdentityProviderRequest, some of required attributes are not set " + attributes;
        }
    }
}

