/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.identityproviders.AbstractIdentityProvider;
import org.cloudfoundry.uaa.identityproviders.Type;
import org.cloudfoundry.uaa.identityproviders._IdentityProvider;

public final class IdentityProvider
extends _IdentityProvider {
    private final Boolean active;
    @Nullable
    private final String configuration;
    private final Long createdAt;
    private final String id;
    private final String identityZoneId;
    private final Long lastModified;
    private final String name;
    private final String originKey;
    private final Type type;
    private final Integer version;

    private IdentityProvider(Builder builder) {
        this.active = builder.active;
        this.configuration = builder.configuration;
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.identityZoneId = builder.identityZoneId;
        this.lastModified = builder.lastModified;
        this.name = builder.name;
        this.originKey = builder.originKey;
        this.type = builder.type;
        this.version = builder.version;
    }

    @Override
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    @Override
    @JsonProperty(value="config")
    @Nullable
    public String getConfiguration() {
        return this.configuration;
    }

    @Override
    @JsonProperty(value="created")
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="identityZoneId")
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @JsonProperty(value="last_modified")
    public Long getLastModified() {
        return this.lastModified;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="originKey")
    public String getOriginKey() {
        return this.originKey;
    }

    @Override
    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof IdentityProvider && this.equalTo((IdentityProvider)another);
    }

    private boolean equalTo(IdentityProvider another) {
        return this.active.equals(another.active) && Objects.equals(this.configuration, another.configuration) && this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.identityZoneId.equals(another.identityZoneId) && this.lastModified.equals(another.lastModified) && this.name.equals(another.name) && this.originKey.equals(another.originKey) && this.type.equals((Object)another.type) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.active.hashCode();
        h = h * 17 + Objects.hashCode(this.configuration);
        h = h * 17 + this.createdAt.hashCode();
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.identityZoneId.hashCode();
        h = h * 17 + this.lastModified.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.originKey.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return "IdentityProvider{active=" + this.active + ", configuration=" + this.configuration + ", createdAt=" + this.createdAt + ", id=" + this.id + ", identityZoneId=" + this.identityZoneId + ", lastModified=" + this.lastModified + ", name=" + this.name + ", originKey=" + this.originKey + ", type=" + (Object)((Object)this.type) + ", version=" + this.version + "}";
    }

    @Deprecated
    @JsonCreator
    static IdentityProvider fromJson(Json json) {
        Builder builder = IdentityProvider.builder();
        if (json.active != null) {
            builder.active(json.active);
        }
        if (json.configuration != null) {
            builder.configuration(json.configuration);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.identityZoneId != null) {
            builder.identityZoneId(json.identityZoneId);
        }
        if (json.lastModified != null) {
            builder.lastModified(json.lastModified);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.originKey != null) {
            builder.originKey(json.originKey);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ACTIVE = 1L;
        private static final long INIT_BIT_CREATED_AT = 2L;
        private static final long INIT_BIT_ID = 4L;
        private static final long INIT_BIT_IDENTITY_ZONE_ID = 8L;
        private static final long INIT_BIT_LAST_MODIFIED = 16L;
        private static final long INIT_BIT_NAME = 32L;
        private static final long INIT_BIT_ORIGIN_KEY = 64L;
        private static final long INIT_BIT_TYPE = 128L;
        private static final long INIT_BIT_VERSION = 256L;
        private long initBits = 511L;
        private Boolean active;
        private String configuration;
        private Long createdAt;
        private String id;
        private String identityZoneId;
        private Long lastModified;
        private String name;
        private String originKey;
        private Type type;
        private Integer version;

        private Builder() {
        }

        public final Builder from(AbstractIdentityProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IdentityProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_IdentityProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof AbstractIdentityProvider) {
                AbstractIdentityProvider instance = (AbstractIdentityProvider)object;
                this.createdAt(instance.getCreatedAt());
                String configurationValue = instance.getConfiguration();
                if (configurationValue != null) {
                    this.configuration(configurationValue);
                }
                this.originKey(instance.getOriginKey());
                this.name(instance.getName());
                this.active(instance.getActive());
                this.id(instance.getId());
                this.lastModified(instance.getLastModified());
                this.type(instance.getType());
                this.identityZoneId(instance.getIdentityZoneId());
                this.version(instance.getVersion());
            }
        }

        public final Builder active(Boolean active) {
            this.active = Objects.requireNonNull(active, "active");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder configuration(@Nullable String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Builder createdAt(Long createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder identityZoneId(String identityZoneId) {
            this.identityZoneId = Objects.requireNonNull(identityZoneId, "identityZoneId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder lastModified(Long lastModified) {
            this.lastModified = Objects.requireNonNull(lastModified, "lastModified");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder originKey(String originKey) {
            this.originKey = Objects.requireNonNull(originKey, "originKey");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder type(Type type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder version(Integer version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public IdentityProvider build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new IdentityProvider(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("active");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("identityZoneId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("lastModified");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("originKey");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build IdentityProvider, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _IdentityProvider {
        Boolean active;
        String configuration;
        Long createdAt;
        String id;
        String identityZoneId;
        Long lastModified;
        String name;
        String originKey;
        Type type;
        Integer version;

        Json() {
        }

        @JsonProperty(value="active")
        public void setActive(Boolean active) {
            this.active = active;
        }

        @JsonProperty(value="config")
        public void setConfiguration(@Nullable String configuration) {
            this.configuration = configuration;
        }

        @JsonProperty(value="created")
        public void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="identityZoneId")
        public void setIdentityZoneId(String identityZoneId) {
            this.identityZoneId = identityZoneId;
        }

        @JsonProperty(value="last_modified")
        public void setLastModified(Long lastModified) {
            this.lastModified = lastModified;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="originKey")
        public void setOriginKey(String originKey) {
            this.originKey = originKey;
        }

        @JsonProperty(value="type")
        public void setType(Type type) {
            this.type = type;
        }

        @JsonProperty(value="version")
        public void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public Boolean getActive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getConfiguration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getLastModified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getOriginKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Type getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getVersion() {
            throw new UnsupportedOperationException();
        }
    }
}

