/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum LdapGroupFile {
    NoGroup("ldap/ldap-groups-null.xml"),
    GroupsAsScopes("ldap/ldap-groups-as-scopes.xml"),
    GroupsMapToScopes("ldap/ldap-groups-map-to-scopes.xml");

    private final String value;

    private LdapGroupFile(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    static LdapGroupFile from(String s) {
        switch (s.toLowerCase()) {
            case "ldap/ldap-groups-null.xml": {
                return NoGroup;
            }
            case "ldap/ldap-groups-as-scopes.xml": {
                return GroupsAsScopes;
            }
            case "ldap/ldap-groups-map-to-scopes.xml": {
                return GroupsMapToScopes;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown ldap group file: %s", s));
    }
}

