/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.identityproviders.AbstractExternalIdentityProviderConfiguration;
import org.cloudfoundry.uaa.identityproviders.AbstractIdentityProviderConfiguration;
import org.cloudfoundry.uaa.identityproviders.AttributeMappings;
import org.cloudfoundry.uaa.identityproviders.ExternalGroupMappingMode;
import org.cloudfoundry.uaa.identityproviders._SamlConfiguration;

public final class SamlConfiguration
extends _SamlConfiguration {
    @Nullable
    private final Boolean addShadowUserOnLogin;
    @Nullable
    private final Integer assertionConsumerIndex;
    @Nullable
    private final ExternalGroupMappingMode groupMappingMode;
    @Nullable
    private final String iconUrl;
    @Nullable
    private final String idpEntityAlias;
    @Nullable
    private final String linkText;
    private final String metaDataLocation;
    @Nullable
    private final Boolean metadataTrustCheck;
    @Nullable
    private final String nameId;
    @Nullable
    private final Boolean showSamlLink;
    @Nullable
    private final String socketFactoryClassName;
    @Nullable
    private final String zoneId;
    @Nullable
    private final AttributeMappings attributeMappings;
    @Nullable
    private final List<String> externalGroupsWhitelist;
    @Nullable
    private final List<String> emailDomains;
    @Nullable
    private final String providerDescription;

    private SamlConfiguration(Builder builder) {
        this.addShadowUserOnLogin = builder.addShadowUserOnLogin;
        this.assertionConsumerIndex = builder.assertionConsumerIndex;
        this.groupMappingMode = builder.groupMappingMode;
        this.iconUrl = builder.iconUrl;
        this.idpEntityAlias = builder.idpEntityAlias;
        this.linkText = builder.linkText;
        this.metaDataLocation = builder.metaDataLocation;
        this.metadataTrustCheck = builder.metadataTrustCheck;
        this.nameId = builder.nameId;
        this.showSamlLink = builder.showSamlLink;
        this.socketFactoryClassName = builder.socketFactoryClassName;
        this.zoneId = builder.zoneId;
        this.attributeMappings = builder.attributeMappings;
        this.externalGroupsWhitelist = builder.externalGroupsWhitelist == null ? null : SamlConfiguration.createUnmodifiableList(true, builder.externalGroupsWhitelist);
        this.emailDomains = builder.emailDomains == null ? null : SamlConfiguration.createUnmodifiableList(true, builder.emailDomains);
        this.providerDescription = builder.providerDescription;
    }

    @Override
    @JsonProperty(value="addShadowUserOnLogin")
    @Nullable
    public Boolean getAddShadowUserOnLogin() {
        return this.addShadowUserOnLogin;
    }

    @Override
    @JsonProperty(value="assertionConsumerIndex")
    @Nullable
    public Integer getAssertionConsumerIndex() {
        return this.assertionConsumerIndex;
    }

    @Override
    @JsonProperty(value="groupMappingMode")
    @Nullable
    public ExternalGroupMappingMode getGroupMappingMode() {
        return this.groupMappingMode;
    }

    @Override
    @JsonProperty(value="iconUrl")
    @Nullable
    public String getIconUrl() {
        return this.iconUrl;
    }

    @Override
    @JsonProperty(value="idpEntityAlias")
    @Nullable
    public String getIdpEntityAlias() {
        return this.idpEntityAlias;
    }

    @Override
    @JsonProperty(value="linkText")
    @Nullable
    public String getLinkText() {
        return this.linkText;
    }

    @Override
    @JsonProperty(value="metaDataLocation")
    public String getMetaDataLocation() {
        return this.metaDataLocation;
    }

    @Override
    @JsonProperty(value="metadataTrustCheck")
    @Nullable
    public Boolean getMetadataTrustCheck() {
        return this.metadataTrustCheck;
    }

    @Override
    @JsonProperty(value="nameID")
    @Nullable
    public String getNameId() {
        return this.nameId;
    }

    @Override
    @JsonProperty(value="showSamlLink")
    @Nullable
    public Boolean getShowSamlLink() {
        return this.showSamlLink;
    }

    @Override
    @JsonProperty(value="socketFactoryClassName")
    @Nullable
    public String getSocketFactoryClassName() {
        return this.socketFactoryClassName;
    }

    @Override
    @JsonProperty(value="zoneId")
    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    @Override
    @JsonProperty(value="attributeMappings")
    @Nullable
    public AttributeMappings getAttributeMappings() {
        return this.attributeMappings;
    }

    @Override
    @JsonProperty(value="externalGroupsWhitelist")
    @Nullable
    public List<String> getExternalGroupsWhitelist() {
        return this.externalGroupsWhitelist;
    }

    @Override
    @JsonProperty(value="emailDomain")
    @Nullable
    public List<String> getEmailDomains() {
        return this.emailDomains;
    }

    @Override
    @JsonProperty(value="providerDescription")
    @Nullable
    public String getProviderDescription() {
        return this.providerDescription;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SamlConfiguration && this.equalTo((SamlConfiguration)another);
    }

    private boolean equalTo(SamlConfiguration another) {
        return Objects.equals(this.addShadowUserOnLogin, another.addShadowUserOnLogin) && Objects.equals(this.assertionConsumerIndex, another.assertionConsumerIndex) && Objects.equals((Object)this.groupMappingMode, (Object)another.groupMappingMode) && Objects.equals(this.iconUrl, another.iconUrl) && Objects.equals(this.idpEntityAlias, another.idpEntityAlias) && Objects.equals(this.linkText, another.linkText) && this.metaDataLocation.equals(another.metaDataLocation) && Objects.equals(this.metadataTrustCheck, another.metadataTrustCheck) && Objects.equals(this.nameId, another.nameId) && Objects.equals(this.showSamlLink, another.showSamlLink) && Objects.equals(this.socketFactoryClassName, another.socketFactoryClassName) && Objects.equals(this.zoneId, another.zoneId) && Objects.equals(this.attributeMappings, another.attributeMappings) && Objects.equals(this.externalGroupsWhitelist, another.externalGroupsWhitelist) && Objects.equals(this.emailDomains, another.emailDomains) && Objects.equals(this.providerDescription, another.providerDescription);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.addShadowUserOnLogin);
        h = h * 17 + Objects.hashCode(this.assertionConsumerIndex);
        h = h * 17 + Objects.hashCode((Object)this.groupMappingMode);
        h = h * 17 + Objects.hashCode(this.iconUrl);
        h = h * 17 + Objects.hashCode(this.idpEntityAlias);
        h = h * 17 + Objects.hashCode(this.linkText);
        h = h * 17 + this.metaDataLocation.hashCode();
        h = h * 17 + Objects.hashCode(this.metadataTrustCheck);
        h = h * 17 + Objects.hashCode(this.nameId);
        h = h * 17 + Objects.hashCode(this.showSamlLink);
        h = h * 17 + Objects.hashCode(this.socketFactoryClassName);
        h = h * 17 + Objects.hashCode(this.zoneId);
        h = h * 17 + Objects.hashCode(this.attributeMappings);
        h = h * 17 + Objects.hashCode(this.externalGroupsWhitelist);
        h = h * 17 + Objects.hashCode(this.emailDomains);
        h = h * 17 + Objects.hashCode(this.providerDescription);
        return h;
    }

    public String toString() {
        return "SamlConfiguration{addShadowUserOnLogin=" + this.addShadowUserOnLogin + ", assertionConsumerIndex=" + this.assertionConsumerIndex + ", groupMappingMode=" + (Object)((Object)this.groupMappingMode) + ", iconUrl=" + this.iconUrl + ", idpEntityAlias=" + this.idpEntityAlias + ", linkText=" + this.linkText + ", metaDataLocation=" + this.metaDataLocation + ", metadataTrustCheck=" + this.metadataTrustCheck + ", nameId=" + this.nameId + ", showSamlLink=" + this.showSamlLink + ", socketFactoryClassName=" + this.socketFactoryClassName + ", zoneId=" + this.zoneId + ", attributeMappings=" + this.attributeMappings + ", externalGroupsWhitelist=" + this.externalGroupsWhitelist + ", emailDomains=" + this.emailDomains + ", providerDescription=" + this.providerDescription + "}";
    }

    @Deprecated
    @JsonCreator
    static SamlConfiguration fromJson(Json json) {
        Builder builder = SamlConfiguration.builder();
        if (json.addShadowUserOnLogin != null) {
            builder.addShadowUserOnLogin(json.addShadowUserOnLogin);
        }
        if (json.assertionConsumerIndex != null) {
            builder.assertionConsumerIndex(json.assertionConsumerIndex);
        }
        if (json.groupMappingMode != null) {
            builder.groupMappingMode(json.groupMappingMode);
        }
        if (json.iconUrl != null) {
            builder.iconUrl(json.iconUrl);
        }
        if (json.idpEntityAlias != null) {
            builder.idpEntityAlias(json.idpEntityAlias);
        }
        if (json.linkText != null) {
            builder.linkText(json.linkText);
        }
        if (json.metaDataLocation != null) {
            builder.metaDataLocation(json.metaDataLocation);
        }
        if (json.metadataTrustCheck != null) {
            builder.metadataTrustCheck(json.metadataTrustCheck);
        }
        if (json.nameId != null) {
            builder.nameId(json.nameId);
        }
        if (json.showSamlLink != null) {
            builder.showSamlLink(json.showSamlLink);
        }
        if (json.socketFactoryClassName != null) {
            builder.socketFactoryClassName(json.socketFactoryClassName);
        }
        if (json.zoneId != null) {
            builder.zoneId(json.zoneId);
        }
        if (json.attributeMappings != null) {
            builder.attributeMappings(json.attributeMappings);
        }
        if (json.externalGroupsWhitelist != null) {
            builder.addAllExternalGroupsWhitelist(json.externalGroupsWhitelist);
        }
        if (json.emailDomains != null) {
            builder.addAllEmailDomains(json.emailDomains);
        }
        if (json.providerDescription != null) {
            builder.providerDescription(json.providerDescription);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_META_DATA_LOCATION = 1L;
        private long initBits = 1L;
        private Boolean addShadowUserOnLogin;
        private Integer assertionConsumerIndex;
        private ExternalGroupMappingMode groupMappingMode;
        private String iconUrl;
        private String idpEntityAlias;
        private String linkText;
        private String metaDataLocation;
        private Boolean metadataTrustCheck;
        private String nameId;
        private Boolean showSamlLink;
        private String socketFactoryClassName;
        private String zoneId;
        private AttributeMappings attributeMappings;
        private List<String> externalGroupsWhitelist = null;
        private List<String> emailDomains = null;
        private String providerDescription;

        private Builder() {
        }

        public final Builder from(AbstractIdentityProviderConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractExternalIdentityProviderConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SamlConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_SamlConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractIdentityProviderConfiguration instance;
            if (object instanceof AbstractIdentityProviderConfiguration) {
                String providerDescriptionValue;
                instance = (AbstractIdentityProviderConfiguration)object;
                List<String> emailDomainsValue = instance.getEmailDomains();
                if (emailDomainsValue != null) {
                    this.addAllEmailDomains(emailDomainsValue);
                }
                if ((providerDescriptionValue = instance.getProviderDescription()) != null) {
                    this.providerDescription(providerDescriptionValue);
                }
            }
            if (object instanceof AbstractExternalIdentityProviderConfiguration) {
                AttributeMappings attributeMappingsValue;
                instance = (AbstractExternalIdentityProviderConfiguration)object;
                List<String> externalGroupsWhitelistValue = ((AbstractExternalIdentityProviderConfiguration)instance).getExternalGroupsWhitelist();
                if (externalGroupsWhitelistValue != null) {
                    this.addAllExternalGroupsWhitelist(externalGroupsWhitelistValue);
                }
                if ((attributeMappingsValue = ((AbstractExternalIdentityProviderConfiguration)instance).getAttributeMappings()) != null) {
                    this.attributeMappings(attributeMappingsValue);
                }
            }
            if (object instanceof _SamlConfiguration) {
                String socketFactoryClassNameValue;
                Boolean addShadowUserOnLoginValue;
                String iconUrlValue;
                Integer assertionConsumerIndexValue;
                String idpEntityAliasValue;
                String linkTextValue;
                String zoneIdValue;
                String nameIdValue;
                Boolean metadataTrustCheckValue;
                instance = (_SamlConfiguration)object;
                Boolean showSamlLinkValue = ((_SamlConfiguration)instance).getShowSamlLink();
                if (showSamlLinkValue != null) {
                    this.showSamlLink(showSamlLinkValue);
                }
                if ((metadataTrustCheckValue = ((_SamlConfiguration)instance).getMetadataTrustCheck()) != null) {
                    this.metadataTrustCheck(metadataTrustCheckValue);
                }
                if ((nameIdValue = ((_SamlConfiguration)instance).getNameId()) != null) {
                    this.nameId(nameIdValue);
                }
                if ((zoneIdValue = ((_SamlConfiguration)instance).getZoneId()) != null) {
                    this.zoneId(zoneIdValue);
                }
                if ((linkTextValue = ((_SamlConfiguration)instance).getLinkText()) != null) {
                    this.linkText(linkTextValue);
                }
                if ((idpEntityAliasValue = ((_SamlConfiguration)instance).getIdpEntityAlias()) != null) {
                    this.idpEntityAlias(idpEntityAliasValue);
                }
                if ((assertionConsumerIndexValue = ((_SamlConfiguration)instance).getAssertionConsumerIndex()) != null) {
                    this.assertionConsumerIndex(assertionConsumerIndexValue);
                }
                if ((iconUrlValue = ((_SamlConfiguration)instance).getIconUrl()) != null) {
                    this.iconUrl(iconUrlValue);
                }
                if ((addShadowUserOnLoginValue = ((_SamlConfiguration)instance).getAddShadowUserOnLogin()) != null) {
                    this.addShadowUserOnLogin(addShadowUserOnLoginValue);
                }
                this.metaDataLocation(((_SamlConfiguration)instance).getMetaDataLocation());
                ExternalGroupMappingMode groupMappingModeValue = ((_SamlConfiguration)instance).getGroupMappingMode();
                if (groupMappingModeValue != null) {
                    this.groupMappingMode(groupMappingModeValue);
                }
                if ((socketFactoryClassNameValue = ((_SamlConfiguration)instance).getSocketFactoryClassName()) != null) {
                    this.socketFactoryClassName(socketFactoryClassNameValue);
                }
            }
        }

        public final Builder addShadowUserOnLogin(@Nullable Boolean addShadowUserOnLogin) {
            this.addShadowUserOnLogin = addShadowUserOnLogin;
            return this;
        }

        public final Builder assertionConsumerIndex(@Nullable Integer assertionConsumerIndex) {
            this.assertionConsumerIndex = assertionConsumerIndex;
            return this;
        }

        public final Builder groupMappingMode(@Nullable ExternalGroupMappingMode groupMappingMode) {
            this.groupMappingMode = groupMappingMode;
            return this;
        }

        public final Builder iconUrl(@Nullable String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public final Builder idpEntityAlias(@Nullable String idpEntityAlias) {
            this.idpEntityAlias = idpEntityAlias;
            return this;
        }

        public final Builder linkText(@Nullable String linkText) {
            this.linkText = linkText;
            return this;
        }

        public final Builder metaDataLocation(String metaDataLocation) {
            this.metaDataLocation = Objects.requireNonNull(metaDataLocation, "metaDataLocation");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder metadataTrustCheck(@Nullable Boolean metadataTrustCheck) {
            this.metadataTrustCheck = metadataTrustCheck;
            return this;
        }

        public final Builder nameId(@Nullable String nameId) {
            this.nameId = nameId;
            return this;
        }

        public final Builder showSamlLink(@Nullable Boolean showSamlLink) {
            this.showSamlLink = showSamlLink;
            return this;
        }

        public final Builder socketFactoryClassName(@Nullable String socketFactoryClassName) {
            this.socketFactoryClassName = socketFactoryClassName;
            return this;
        }

        public final Builder zoneId(@Nullable String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public final Builder attributeMappings(@Nullable AttributeMappings attributeMappings) {
            this.attributeMappings = attributeMappings;
            return this;
        }

        public final Builder externalGroupsWhitelist(String element) {
            if (this.externalGroupsWhitelist == null) {
                this.externalGroupsWhitelist = new ArrayList<String>();
            }
            this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
            return this;
        }

        public final Builder externalGroupsWhitelist(String ... elements) {
            if (this.externalGroupsWhitelist == null) {
                this.externalGroupsWhitelist = new ArrayList<String>();
            }
            for (String element : elements) {
                this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
            }
            return this;
        }

        public final Builder externalGroupsWhitelist(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.externalGroupsWhitelist = null;
                return this;
            }
            this.externalGroupsWhitelist = new ArrayList<String>();
            return this.addAllExternalGroupsWhitelist(elements);
        }

        public final Builder addAllExternalGroupsWhitelist(Iterable<String> elements) {
            Objects.requireNonNull(elements, "externalGroupsWhitelist element");
            if (this.externalGroupsWhitelist == null) {
                this.externalGroupsWhitelist = new ArrayList<String>();
            }
            for (String element : elements) {
                this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
            }
            return this;
        }

        public final Builder emailDomain(String element) {
            if (this.emailDomains == null) {
                this.emailDomains = new ArrayList<String>();
            }
            this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
            return this;
        }

        public final Builder emailDomain(String ... elements) {
            if (this.emailDomains == null) {
                this.emailDomains = new ArrayList<String>();
            }
            for (String element : elements) {
                this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
            }
            return this;
        }

        public final Builder emailDomains(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.emailDomains = null;
                return this;
            }
            this.emailDomains = new ArrayList<String>();
            return this.addAllEmailDomains(elements);
        }

        public final Builder addAllEmailDomains(Iterable<String> elements) {
            Objects.requireNonNull(elements, "emailDomains element");
            if (this.emailDomains == null) {
                this.emailDomains = new ArrayList<String>();
            }
            for (String element : elements) {
                this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
            }
            return this;
        }

        public final Builder providerDescription(@Nullable String providerDescription) {
            this.providerDescription = providerDescription;
            return this;
        }

        public SamlConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new SamlConfiguration(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("metaDataLocation");
            }
            return "Cannot build SamlConfiguration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _SamlConfiguration {
        Boolean addShadowUserOnLogin;
        Integer assertionConsumerIndex;
        ExternalGroupMappingMode groupMappingMode;
        String iconUrl;
        String idpEntityAlias;
        String linkText;
        String metaDataLocation;
        Boolean metadataTrustCheck;
        String nameId;
        Boolean showSamlLink;
        String socketFactoryClassName;
        String zoneId;
        AttributeMappings attributeMappings;
        List<String> externalGroupsWhitelist = null;
        List<String> emailDomains = null;
        String providerDescription;

        Json() {
        }

        @JsonProperty(value="addShadowUserOnLogin")
        public void setAddShadowUserOnLogin(@Nullable Boolean addShadowUserOnLogin) {
            this.addShadowUserOnLogin = addShadowUserOnLogin;
        }

        @JsonProperty(value="assertionConsumerIndex")
        public void setAssertionConsumerIndex(@Nullable Integer assertionConsumerIndex) {
            this.assertionConsumerIndex = assertionConsumerIndex;
        }

        @JsonProperty(value="groupMappingMode")
        public void setGroupMappingMode(@Nullable ExternalGroupMappingMode groupMappingMode) {
            this.groupMappingMode = groupMappingMode;
        }

        @JsonProperty(value="iconUrl")
        public void setIconUrl(@Nullable String iconUrl) {
            this.iconUrl = iconUrl;
        }

        @JsonProperty(value="idpEntityAlias")
        public void setIdpEntityAlias(@Nullable String idpEntityAlias) {
            this.idpEntityAlias = idpEntityAlias;
        }

        @JsonProperty(value="linkText")
        public void setLinkText(@Nullable String linkText) {
            this.linkText = linkText;
        }

        @JsonProperty(value="metaDataLocation")
        public void setMetaDataLocation(String metaDataLocation) {
            this.metaDataLocation = metaDataLocation;
        }

        @JsonProperty(value="metadataTrustCheck")
        public void setMetadataTrustCheck(@Nullable Boolean metadataTrustCheck) {
            this.metadataTrustCheck = metadataTrustCheck;
        }

        @JsonProperty(value="nameID")
        public void setNameId(@Nullable String nameId) {
            this.nameId = nameId;
        }

        @JsonProperty(value="showSamlLink")
        public void setShowSamlLink(@Nullable Boolean showSamlLink) {
            this.showSamlLink = showSamlLink;
        }

        @JsonProperty(value="socketFactoryClassName")
        public void setSocketFactoryClassName(@Nullable String socketFactoryClassName) {
            this.socketFactoryClassName = socketFactoryClassName;
        }

        @JsonProperty(value="zoneId")
        public void setZoneId(@Nullable String zoneId) {
            this.zoneId = zoneId;
        }

        @JsonProperty(value="attributeMappings")
        public void setAttributeMappings(@Nullable AttributeMappings attributeMappings) {
            this.attributeMappings = attributeMappings;
        }

        @JsonProperty(value="externalGroupsWhitelist")
        public void setExternalGroupsWhitelist(@Nullable List<String> externalGroupsWhitelist) {
            this.externalGroupsWhitelist = externalGroupsWhitelist;
        }

        @JsonProperty(value="emailDomain")
        public void setEmailDomains(@Nullable List<String> emailDomains) {
            this.emailDomains = emailDomains;
        }

        @JsonProperty(value="providerDescription")
        public void setProviderDescription(@Nullable String providerDescription) {
            this.providerDescription = providerDescription;
        }

        @Override
        public Boolean getAddShadowUserOnLogin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getAssertionConsumerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ExternalGroupMappingMode getGroupMappingMode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIconUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdpEntityAlias() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLinkText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMetaDataLocation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getMetadataTrustCheck() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNameId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getShowSamlLink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSocketFactoryClassName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getZoneId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AttributeMappings getAttributeMappings() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getExternalGroupsWhitelist() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getEmailDomains() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getProviderDescription() {
            throw new UnsupportedOperationException();
        }
    }
}

