/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.identityzones.AbstractIdentityZone;
import org.cloudfoundry.uaa.identityzones.IdentityZoneConfiguration;
import org.cloudfoundry.uaa.identityzones._GetIdentityZoneResponse;

public final class GetIdentityZoneResponse
extends _GetIdentityZoneResponse {
    @Nullable
    private final IdentityZoneConfiguration configuration;
    private final Long createdAt;
    @Nullable
    private final String description;
    private final String id;
    private final Long lastModified;
    private final String name;
    private final String subdomain;
    @Nullable
    private final Integer version;

    private GetIdentityZoneResponse(Builder builder) {
        this.configuration = builder.configuration;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.id = builder.id;
        this.lastModified = builder.lastModified;
        this.name = builder.name;
        this.subdomain = builder.subdomain;
        this.version = builder.version;
    }

    @Override
    @JsonProperty(value="config")
    @Nullable
    public IdentityZoneConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    @JsonProperty(value="created")
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="last_modified")
    public Long getLastModified() {
        return this.lastModified;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="subdomain")
    public String getSubdomain() {
        return this.subdomain;
    }

    @Override
    @JsonProperty(value="version")
    @Nullable
    public Integer getVersion() {
        return this.version;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetIdentityZoneResponse && this.equalTo((GetIdentityZoneResponse)another);
    }

    private boolean equalTo(GetIdentityZoneResponse another) {
        return Objects.equals(this.configuration, another.configuration) && this.createdAt.equals(another.createdAt) && Objects.equals(this.description, another.description) && this.id.equals(another.id) && this.lastModified.equals(another.lastModified) && this.name.equals(another.name) && this.subdomain.equals(another.subdomain) && Objects.equals(this.version, another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.configuration);
        h = h * 17 + this.createdAt.hashCode();
        h = h * 17 + Objects.hashCode(this.description);
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.lastModified.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.subdomain.hashCode();
        h = h * 17 + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        return "GetIdentityZoneResponse{configuration=" + this.configuration + ", createdAt=" + this.createdAt + ", description=" + this.description + ", id=" + this.id + ", lastModified=" + this.lastModified + ", name=" + this.name + ", subdomain=" + this.subdomain + ", version=" + this.version + "}";
    }

    @Deprecated
    @JsonCreator
    static GetIdentityZoneResponse fromJson(Json json) {
        Builder builder = GetIdentityZoneResponse.builder();
        if (json.configuration != null) {
            builder.configuration(json.configuration);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.lastModified != null) {
            builder.lastModified(json.lastModified);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.subdomain != null) {
            builder.subdomain(json.subdomain);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CREATED_AT = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_LAST_MODIFIED = 4L;
        private static final long INIT_BIT_NAME = 8L;
        private static final long INIT_BIT_SUBDOMAIN = 16L;
        private long initBits = 31L;
        private IdentityZoneConfiguration configuration;
        private Long createdAt;
        private String description;
        private String id;
        private Long lastModified;
        private String name;
        private String subdomain;
        private Integer version;

        private Builder() {
        }

        public final Builder from(AbstractIdentityZone instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetIdentityZoneResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_GetIdentityZoneResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof AbstractIdentityZone) {
                AbstractIdentityZone instance = (AbstractIdentityZone)object;
                this.createdAt(instance.getCreatedAt());
                IdentityZoneConfiguration configurationValue = instance.getConfiguration();
                if (configurationValue != null) {
                    this.configuration(configurationValue);
                }
                this.name(instance.getName());
                String descriptionValue = instance.getDescription();
                if (descriptionValue != null) {
                    this.description(descriptionValue);
                }
                this.subdomain(instance.getSubdomain());
                this.id(instance.getId());
                this.lastModified(instance.getLastModified());
                Integer versionValue = instance.getVersion();
                if (versionValue != null) {
                    this.version(versionValue);
                }
            }
        }

        public final Builder configuration(@Nullable IdentityZoneConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Builder createdAt(Long createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder lastModified(Long lastModified) {
            this.lastModified = Objects.requireNonNull(lastModified, "lastModified");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder subdomain(String subdomain) {
            this.subdomain = Objects.requireNonNull(subdomain, "subdomain");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder version(@Nullable Integer version) {
            this.version = version;
            return this;
        }

        public GetIdentityZoneResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetIdentityZoneResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lastModified");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("subdomain");
            }
            return "Cannot build GetIdentityZoneResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _GetIdentityZoneResponse {
        IdentityZoneConfiguration configuration;
        Long createdAt;
        String description;
        String id;
        Long lastModified;
        String name;
        String subdomain;
        Integer version;

        Json() {
        }

        @JsonProperty(value="config")
        public void setConfiguration(@Nullable IdentityZoneConfiguration configuration) {
            this.configuration = configuration;
        }

        @JsonProperty(value="created")
        public void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="last_modified")
        public void setLastModified(Long lastModified) {
            this.lastModified = lastModified;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="subdomain")
        public void setSubdomain(String subdomain) {
            this.subdomain = subdomain;
        }

        @JsonProperty(value="version")
        public void setVersion(@Nullable Integer version) {
            this.version = version;
        }

        @Override
        public IdentityZoneConfiguration getConfiguration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getLastModified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSubdomain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getVersion() {
            throw new UnsupportedOperationException();
        }
    }
}

