/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.tokens;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.BasicAuthorized;
import org.cloudfoundry.uaa.tokens.TokenFormat;
import org.cloudfoundry.uaa.tokens._GetTokenByOneTimePasscodeRequest;

public final class GetTokenByOneTimePasscodeRequest
extends _GetTokenByOneTimePasscodeRequest {
    private final String passcode;
    @Nullable
    private final TokenFormat tokenFormat;
    private final String clientId;
    private final String clientSecret;

    private GetTokenByOneTimePasscodeRequest(Builder builder) {
        this.passcode = builder.passcode;
        this.tokenFormat = builder.tokenFormat;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
    }

    @Override
    public String getPasscode() {
        return this.passcode;
    }

    @Override
    @Nullable
    public TokenFormat getTokenFormat() {
        return this.tokenFormat;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetTokenByOneTimePasscodeRequest && this.equalTo((GetTokenByOneTimePasscodeRequest)another);
    }

    private boolean equalTo(GetTokenByOneTimePasscodeRequest another) {
        return this.passcode.equals(another.passcode) && Objects.equals((Object)this.tokenFormat, (Object)another.tokenFormat) && this.clientId.equals(another.clientId) && this.clientSecret.equals(another.clientSecret);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.passcode.hashCode();
        h = h * 17 + Objects.hashCode((Object)this.tokenFormat);
        h = h * 17 + this.clientId.hashCode();
        h = h * 17 + this.clientSecret.hashCode();
        return h;
    }

    public String toString() {
        return "GetTokenByOneTimePasscodeRequest{passcode=" + this.passcode + ", tokenFormat=" + (Object)((Object)this.tokenFormat) + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PASSCODE = 1L;
        private static final long INIT_BIT_CLIENT_ID = 2L;
        private static final long INIT_BIT_CLIENT_SECRET = 4L;
        private long initBits = 7L;
        private String passcode;
        private TokenFormat tokenFormat;
        private String clientId;
        private String clientSecret;

        private Builder() {
        }

        public final Builder from(BasicAuthorized instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GetTokenByOneTimePasscodeRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_GetTokenByOneTimePasscodeRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BasicAuthorized instance;
            if (object instanceof BasicAuthorized) {
                instance = (BasicAuthorized)object;
                this.clientSecret(instance.getClientSecret());
                this.clientId(instance.getClientId());
            }
            if (object instanceof _GetTokenByOneTimePasscodeRequest) {
                instance = (_GetTokenByOneTimePasscodeRequest)object;
                TokenFormat tokenFormatValue = ((_GetTokenByOneTimePasscodeRequest)instance).getTokenFormat();
                if (tokenFormatValue != null) {
                    this.tokenFormat(tokenFormatValue);
                }
                this.passcode(((_GetTokenByOneTimePasscodeRequest)instance).getPasscode());
            }
        }

        public final Builder passcode(String passcode) {
            this.passcode = Objects.requireNonNull(passcode, "passcode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder tokenFormat(@Nullable TokenFormat tokenFormat) {
            this.tokenFormat = tokenFormat;
            return this;
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public GetTokenByOneTimePasscodeRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetTokenByOneTimePasscodeRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("passcode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("clientSecret");
            }
            return "Cannot build GetTokenByOneTimePasscodeRequest, some of required attributes are not set " + attributes;
        }
    }
}

