/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.users;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.uaa.users._ChangeUserPasswordRequest;

public final class ChangeUserPasswordRequest
extends _ChangeUserPasswordRequest {
    private final String oldPassword;
    private final String password;
    private final String userId;

    private ChangeUserPasswordRequest(Builder builder) {
        this.oldPassword = builder.oldPassword;
        this.password = builder.password;
        this.userId = builder.userId;
    }

    @Override
    public String getOldPassword() {
        return this.oldPassword;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChangeUserPasswordRequest && this.equalTo((ChangeUserPasswordRequest)another);
    }

    private boolean equalTo(ChangeUserPasswordRequest another) {
        return this.oldPassword.equals(another.oldPassword) && this.password.equals(another.password) && this.userId.equals(another.userId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.oldPassword.hashCode();
        h = h * 17 + this.password.hashCode();
        h = h * 17 + this.userId.hashCode();
        return h;
    }

    public String toString() {
        return "ChangeUserPasswordRequest{oldPassword=" + this.oldPassword + ", password=" + this.password + ", userId=" + this.userId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OLD_PASSWORD = 1L;
        private static final long INIT_BIT_PASSWORD = 2L;
        private static final long INIT_BIT_USER_ID = 4L;
        private long initBits = 7L;
        private String oldPassword;
        private String password;
        private String userId;

        private Builder() {
        }

        public final Builder from(ChangeUserPasswordRequest instance) {
            return this.from((_ChangeUserPasswordRequest)instance);
        }

        final Builder from(_ChangeUserPasswordRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.oldPassword(instance.getOldPassword());
            this.password(instance.getPassword());
            this.userId(instance.getUserId());
            return this;
        }

        public final Builder oldPassword(String oldPassword) {
            this.oldPassword = Objects.requireNonNull(oldPassword, "oldPassword");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder userId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ChangeUserPasswordRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ChangeUserPasswordRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("oldPassword");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("password");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build ChangeUserPasswordRequest, some of required attributes are not set " + attributes;
        }
    }
}

