/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.users;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.users.Email;
import org.cloudfoundry.uaa.users.Name;
import org.cloudfoundry.uaa.users._CreateUserRequest;

public final class CreateUserRequest
extends _CreateUserRequest {
    @Nullable
    private final Boolean active;
    private final List<Email> email;
    @Nullable
    private final String externalId;
    private final Name name;
    @Nullable
    private final String origin;
    private final String password;
    private final String userName;
    @Nullable
    private final Boolean verified;

    private CreateUserRequest(Builder builder) {
        this.active = builder.active;
        this.email = CreateUserRequest.createUnmodifiableList(true, builder.email);
        this.externalId = builder.externalId;
        this.name = builder.name;
        this.origin = builder.origin;
        this.password = builder.password;
        this.userName = builder.userName;
        this.verified = builder.verified;
    }

    @Override
    @Nullable
    public Boolean getActive() {
        return this.active;
    }

    @Override
    public List<Email> getEmail() {
        return this.email;
    }

    @Override
    @Nullable
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    @Nullable
    public Boolean getVerified() {
        return this.verified;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateUserRequest && this.equalTo((CreateUserRequest)another);
    }

    private boolean equalTo(CreateUserRequest another) {
        return Objects.equals(this.active, another.active) && this.email.equals(another.email) && Objects.equals(this.externalId, another.externalId) && this.name.equals(another.name) && Objects.equals(this.origin, another.origin) && this.password.equals(another.password) && this.userName.equals(another.userName) && Objects.equals(this.verified, another.verified);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.active);
        h = h * 17 + this.email.hashCode();
        h = h * 17 + Objects.hashCode(this.externalId);
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Objects.hashCode(this.origin);
        h = h * 17 + this.password.hashCode();
        h = h * 17 + this.userName.hashCode();
        h = h * 17 + Objects.hashCode(this.verified);
        return h;
    }

    public String toString() {
        return "CreateUserRequest{active=" + this.active + ", email=" + this.email + ", externalId=" + this.externalId + ", name=" + this.name + ", origin=" + this.origin + ", password=" + this.password + ", userName=" + this.userName + ", verified=" + this.verified + "}";
    }

    private static CreateUserRequest validate(CreateUserRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_PASSWORD = 2L;
        private static final long INIT_BIT_USER_NAME = 4L;
        private long initBits = 7L;
        private Boolean active;
        private List<Email> email = new ArrayList<Email>();
        private String externalId;
        private Name name;
        private String origin;
        private String password;
        private String userName;
        private Boolean verified;

        private Builder() {
        }

        public final Builder from(CreateUserRequest instance) {
            return this.from((_CreateUserRequest)instance);
        }

        final Builder from(_CreateUserRequest instance) {
            Objects.requireNonNull(instance, "instance");
            Boolean activeValue = instance.getActive();
            if (activeValue != null) {
                this.active(activeValue);
            }
            this.addAllEmail(instance.getEmail());
            String externalIdValue = instance.getExternalId();
            if (externalIdValue != null) {
                this.externalId(externalIdValue);
            }
            this.name(instance.getName());
            String originValue = instance.getOrigin();
            if (originValue != null) {
                this.origin(originValue);
            }
            this.password(instance.getPassword());
            this.userName(instance.getUserName());
            Boolean verifiedValue = instance.getVerified();
            if (verifiedValue != null) {
                this.verified(verifiedValue);
            }
            return this;
        }

        public final Builder active(@Nullable Boolean active) {
            this.active = active;
            return this;
        }

        public final Builder email(Email element) {
            this.email.add(Objects.requireNonNull(element, "email element"));
            return this;
        }

        public final Builder email(Email ... elements) {
            for (Email element : elements) {
                this.email.add(Objects.requireNonNull(element, "email element"));
            }
            return this;
        }

        public final Builder email(Iterable<? extends Email> elements) {
            this.email.clear();
            return this.addAllEmail(elements);
        }

        public final Builder addAllEmail(Iterable<? extends Email> elements) {
            for (Email email : elements) {
                this.email.add(Objects.requireNonNull(email, "email element"));
            }
            return this;
        }

        public final Builder externalId(@Nullable String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final Builder name(Name name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder origin(@Nullable String origin) {
            this.origin = origin;
            return this;
        }

        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder userName(String userName) {
            this.userName = Objects.requireNonNull(userName, "userName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder verified(@Nullable Boolean verified) {
            this.verified = verified;
            return this;
        }

        public CreateUserRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return CreateUserRequest.validate(new CreateUserRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("password");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("userName");
            }
            return "Cannot build CreateUserRequest, some of required attributes are not set " + attributes;
        }
    }
}

