/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.uaa.users._Email;

public final class Email
extends _Email {
    private final String value;
    private final Boolean primary;

    private Email(Builder builder) {
        this.value = builder.value;
        this.primary = builder.primary;
    }

    @Override
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @Override
    @JsonProperty(value="primary")
    public Boolean getPrimary() {
        return this.primary;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Email && this.equalTo((Email)another);
    }

    private boolean equalTo(Email another) {
        return this.value.equals(another.value) && this.primary.equals(another.primary);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.value.hashCode();
        h = h * 17 + this.primary.hashCode();
        return h;
    }

    public String toString() {
        return "Email{value=" + this.value + ", primary=" + this.primary + "}";
    }

    @Deprecated
    @JsonCreator
    static Email fromJson(Json json) {
        Builder builder = Email.builder();
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.primary != null) {
            builder.primary(json.primary);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_PRIMARY = 2L;
        private long initBits = 3L;
        private String value;
        private Boolean primary;

        private Builder() {
        }

        public final Builder from(Email instance) {
            return this.from((_Email)instance);
        }

        final Builder from(_Email instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.getValue());
            this.primary(instance.getPrimary());
            return this;
        }

        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder primary(Boolean primary) {
            this.primary = Objects.requireNonNull(primary, "primary");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Email build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Email(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("primary");
            }
            return "Cannot build Email, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Email {
        String value;
        Boolean primary;

        Json() {
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="primary")
        public void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getPrimary() {
            throw new UnsupportedOperationException();
        }
    }
}

