/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.users;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.uaa.users._GetUserVerificationLinkRequest;

public final class GetUserVerificationLinkRequest
extends _GetUserVerificationLinkRequest {
    private final String redirectUri;
    private final String userId;

    private GetUserVerificationLinkRequest(Builder builder) {
        this.redirectUri = builder.redirectUri;
        this.userId = builder.userId;
    }

    @Override
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetUserVerificationLinkRequest && this.equalTo((GetUserVerificationLinkRequest)another);
    }

    private boolean equalTo(GetUserVerificationLinkRequest another) {
        return this.redirectUri.equals(another.redirectUri) && this.userId.equals(another.userId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.redirectUri.hashCode();
        h = h * 17 + this.userId.hashCode();
        return h;
    }

    public String toString() {
        return "GetUserVerificationLinkRequest{redirectUri=" + this.redirectUri + ", userId=" + this.userId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_REDIRECT_URI = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private long initBits = 3L;
        private String redirectUri;
        private String userId;

        private Builder() {
        }

        public final Builder from(GetUserVerificationLinkRequest instance) {
            return this.from((_GetUserVerificationLinkRequest)instance);
        }

        final Builder from(_GetUserVerificationLinkRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.redirectUri(instance.getRedirectUri());
            this.userId(instance.getUserId());
            return this;
        }

        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = Objects.requireNonNull(redirectUri, "redirectUri");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder userId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public GetUserVerificationLinkRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetUserVerificationLinkRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("redirectUri");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build GetUserVerificationLinkRequest, some of required attributes are not set " + attributes;
        }
    }
}

