package org.cloudfoundry.client.v2.organizationquotadefinitions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _GetOrganizationQuotaDefinitionRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetOrganizationQuotaDefinitionRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_GetOrganizationQuotaDefinitionRequest"})
public final class GetOrganizationQuotaDefinitionRequest
    extends org.cloudfoundry.client.v2.organizationquotadefinitions._GetOrganizationQuotaDefinitionRequest {
  private final String organizationQuotaDefinitionId;

  private GetOrganizationQuotaDefinitionRequest(GetOrganizationQuotaDefinitionRequest.Builder builder) {
    this.organizationQuotaDefinitionId = builder.organizationQuotaDefinitionId;
  }

  /**
   * The quota definition id
   */
  @Override
  public String getOrganizationQuotaDefinitionId() {
    return organizationQuotaDefinitionId;
  }

  /**
   * This instance is equal to all instances of {@code GetOrganizationQuotaDefinitionRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetOrganizationQuotaDefinitionRequest
        && equalTo((GetOrganizationQuotaDefinitionRequest) another);
  }

  private boolean equalTo(GetOrganizationQuotaDefinitionRequest another) {
    return organizationQuotaDefinitionId.equals(another.organizationQuotaDefinitionId);
  }

  /**
   * Computes a hash code from attributes: {@code organizationQuotaDefinitionId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + organizationQuotaDefinitionId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetOrganizationQuotaDefinitionRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetOrganizationQuotaDefinitionRequest{"
        + "organizationQuotaDefinitionId=" + organizationQuotaDefinitionId
        + "}";
  }

  /**
   * Creates a builder for {@link GetOrganizationQuotaDefinitionRequest GetOrganizationQuotaDefinitionRequest}.
   * @return A new GetOrganizationQuotaDefinitionRequest builder
   */
  public static GetOrganizationQuotaDefinitionRequest.Builder builder() {
    return new GetOrganizationQuotaDefinitionRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetOrganizationQuotaDefinitionRequest GetOrganizationQuotaDefinitionRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_QUOTA_DEFINITION_ID = 0x1L;
    private long initBits = 0x1L;

    private String organizationQuotaDefinitionId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetOrganizationQuotaDefinitionRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetOrganizationQuotaDefinitionRequest instance) {
      return from((_GetOrganizationQuotaDefinitionRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetOrganizationQuotaDefinitionRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetOrganizationQuotaDefinitionRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationQuotaDefinitionId(instance.getOrganizationQuotaDefinitionId());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetOrganizationQuotaDefinitionRequest#getOrganizationQuotaDefinitionId() organizationQuotaDefinitionId} attribute.
     * @param organizationQuotaDefinitionId The value for organizationQuotaDefinitionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationQuotaDefinitionId(String organizationQuotaDefinitionId) {
      this.organizationQuotaDefinitionId = Objects.requireNonNull(organizationQuotaDefinitionId, "organizationQuotaDefinitionId");
      initBits &= ~INIT_BIT_ORGANIZATION_QUOTA_DEFINITION_ID;
      return this;
    }

    /**
     * Builds a new {@link GetOrganizationQuotaDefinitionRequest GetOrganizationQuotaDefinitionRequest}.
     * @return An immutable instance of GetOrganizationQuotaDefinitionRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetOrganizationQuotaDefinitionRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetOrganizationQuotaDefinitionRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ORGANIZATION_QUOTA_DEFINITION_ID) != 0) attributes.add("organizationQuotaDefinitionId");
      return "Cannot build GetOrganizationQuotaDefinitionRequest, some of required attributes are not set " + attributes;
    }
  }
}
