package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _AssociateOrganizationUserRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code AssociateOrganizationUserRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_AssociateOrganizationUserRequest"})
public final class AssociateOrganizationUserRequest
    extends org.cloudfoundry.client.v2.organizations._AssociateOrganizationUserRequest {
  private final String organizationId;
  private final String userId;

  private AssociateOrganizationUserRequest(AssociateOrganizationUserRequest.Builder builder) {
    this.organizationId = builder.organizationId;
    this.userId = builder.userId;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The user id
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code AssociateOrganizationUserRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateOrganizationUserRequest
        && equalTo((AssociateOrganizationUserRequest) another);
  }

  private boolean equalTo(AssociateOrganizationUserRequest another) {
    return organizationId.equals(another.organizationId)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + organizationId.hashCode();
    h = h * 17 + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateOrganizationUserRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateOrganizationUserRequest{"
        + "organizationId=" + organizationId
        + ", userId=" + userId
        + "}";
  }

  /**
   * Creates a builder for {@link AssociateOrganizationUserRequest AssociateOrganizationUserRequest}.
   * @return A new AssociateOrganizationUserRequest builder
   */
  public static AssociateOrganizationUserRequest.Builder builder() {
    return new AssociateOrganizationUserRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateOrganizationUserRequest AssociateOrganizationUserRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private long initBits = 0x3L;

    private String organizationId;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateOrganizationUserRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateOrganizationUserRequest instance) {
      return from((_AssociateOrganizationUserRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateOrganizationUserRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateOrganizationUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationId(instance.getOrganizationId());
      userId(instance.getUserId());
      return this;
    }

    /**
     * Initializes the value for the {@link _AssociateOrganizationUserRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _AssociateOrganizationUserRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link AssociateOrganizationUserRequest AssociateOrganizationUserRequest}.
     * @return An immutable instance of AssociateOrganizationUserRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateOrganizationUserRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateOrganizationUserRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build AssociateOrganizationUserRequest, some of required attributes are not set " + attributes;
    }
  }
}
