package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _SummaryOrganizationRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SummaryOrganizationRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_SummaryOrganizationRequest"})
public final class SummaryOrganizationRequest
    extends org.cloudfoundry.client.v2.organizations._SummaryOrganizationRequest {
  private final String organizationId;

  private SummaryOrganizationRequest(SummaryOrganizationRequest.Builder builder) {
    this.organizationId = builder.organizationId;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * This instance is equal to all instances of {@code SummaryOrganizationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SummaryOrganizationRequest
        && equalTo((SummaryOrganizationRequest) another);
  }

  private boolean equalTo(SummaryOrganizationRequest another) {
    return organizationId.equals(another.organizationId);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + organizationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SummaryOrganizationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SummaryOrganizationRequest{"
        + "organizationId=" + organizationId
        + "}";
  }

  /**
   * Creates a builder for {@link SummaryOrganizationRequest SummaryOrganizationRequest}.
   * @return A new SummaryOrganizationRequest builder
   */
  public static SummaryOrganizationRequest.Builder builder() {
    return new SummaryOrganizationRequest.Builder();
  }

  /**
   * Builds instances of type {@link SummaryOrganizationRequest SummaryOrganizationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String organizationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SummaryOrganizationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SummaryOrganizationRequest instance) {
      return from((_SummaryOrganizationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _SummaryOrganizationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SummaryOrganizationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationId(instance.getOrganizationId());
      return this;
    }

    /**
     * Initializes the value for the {@link _SummaryOrganizationRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Builds a new {@link SummaryOrganizationRequest SummaryOrganizationRequest}.
     * @return An immutable instance of SummaryOrganizationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SummaryOrganizationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new SummaryOrganizationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build SummaryOrganizationRequest, some of required attributes are not set " + attributes;
    }
  }
}
