package org.cloudfoundry.client.v2.routes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _DeleteRouteRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DeleteRouteRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_DeleteRouteRequest"})
public final class DeleteRouteRequest extends org.cloudfoundry.client.v2.routes._DeleteRouteRequest {
  private final @Nullable Boolean async;
  private final String routeId;

  private DeleteRouteRequest(DeleteRouteRequest.Builder builder) {
    this.async = builder.async;
    this.routeId = builder.routeId;
  }

  /**
   * The async
   */
  @Override
  public @Nullable Boolean getAsync() {
    return async;
  }

  /**
   * The route id
   */
  @Override
  public String getRouteId() {
    return routeId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteRouteRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteRouteRequest
        && equalTo((DeleteRouteRequest) another);
  }

  private boolean equalTo(DeleteRouteRequest another) {
    return Objects.equals(async, another.async)
        && routeId.equals(another.routeId);
  }

  /**
   * Computes a hash code from attributes: {@code async}, {@code routeId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(async);
    h = h * 17 + routeId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteRouteRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteRouteRequest{"
        + "async=" + async
        + ", routeId=" + routeId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteRouteRequest DeleteRouteRequest}.
   * @return A new DeleteRouteRequest builder
   */
  public static DeleteRouteRequest.Builder builder() {
    return new DeleteRouteRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteRouteRequest DeleteRouteRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ROUTE_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean async;
    private String routeId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteRouteRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteRouteRequest instance) {
      return from((_DeleteRouteRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteRouteRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteRouteRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean asyncValue = instance.getAsync();
      if (asyncValue != null) {
        async(asyncValue);
      }
      routeId(instance.getRouteId());
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteRouteRequest#getAsync() async} attribute.
     * @param async The value for async (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder async(@Nullable Boolean async) {
      this.async = async;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteRouteRequest#getRouteId() routeId} attribute.
     * @param routeId The value for routeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String routeId) {
      this.routeId = Objects.requireNonNull(routeId, "routeId");
      initBits &= ~INIT_BIT_ROUTE_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteRouteRequest DeleteRouteRequest}.
     * @return An immutable instance of DeleteRouteRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteRouteRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteRouteRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ROUTE_ID) != 0) attributes.add("routeId");
      return "Cannot build DeleteRouteRequest, some of required attributes are not set " + attributes;
    }
  }
}
