package org.cloudfoundry.client.v2.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.domains.Domain;

/**
 * Immutable implementation of {@link _Route}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Route.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_Route"})
public final class Route extends org.cloudfoundry.client.v2.routes._Route {
  private final @Nullable Domain domain;
  private final @Nullable String host;
  private final @Nullable String id;
  private final @Nullable String path;
  private final @Nullable Integer port;

  private Route(Route.Builder builder) {
    this.domain = builder.domain;
    this.host = builder.host;
    this.id = builder.id;
    this.path = builder.path;
    this.port = builder.port;
  }

  /**
   * The domain
   */
  @JsonProperty("domain")
  @Override
  public @Nullable Domain getDomain() {
    return domain;
  }

  /**
   * The host
   */
  @JsonProperty("host")
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * The path
   */
  @JsonProperty("path")
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The port
   */
  @JsonProperty("port")
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * This instance is equal to all instances of {@code Route} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Route
        && equalTo((Route) another);
  }

  private boolean equalTo(Route another) {
    return Objects.equals(domain, another.domain)
        && Objects.equals(host, another.host)
        && Objects.equals(id, another.id)
        && Objects.equals(path, another.path)
        && Objects.equals(port, another.port);
  }

  /**
   * Computes a hash code from attributes: {@code domain}, {@code host}, {@code id}, {@code path}, {@code port}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(domain);
    h = h * 17 + Objects.hashCode(host);
    h = h * 17 + Objects.hashCode(id);
    h = h * 17 + Objects.hashCode(path);
    h = h * 17 + Objects.hashCode(port);
    return h;
  }

  /**
   * Prints the immutable value {@code Route} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Route{"
        + "domain=" + domain
        + ", host=" + host
        + ", id=" + id
        + ", path=" + path
        + ", port=" + port
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.routes._Route {
    Domain domain;
    String host;
    String id;
    String path;
    Integer port;
    @JsonProperty("domain")
    public void setDomain(@Nullable Domain domain) {
      this.domain = domain;
    }
    @JsonProperty("host")
    public void setHost(@Nullable String host) {
      this.host = host;
    }
    @JsonProperty("guid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("path")
    public void setPath(@Nullable String path) {
      this.path = path;
    }
    @JsonProperty("port")
    public void setPort(@Nullable Integer port) {
      this.port = port;
    }
    @Override
    public Domain getDomain() { throw new UnsupportedOperationException(); }
    @Override
    public String getHost() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getPath() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPort() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Route fromJson(Json json) {
    Route.Builder builder = Route.builder();
    if (json.domain != null) {
      builder.domain(json.domain);
    }
    if (json.host != null) {
      builder.host(json.host);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Route Route}.
   * @return A new Route builder
   */
  public static Route.Builder builder() {
    return new Route.Builder();
  }

  /**
   * Builds instances of type {@link Route Route}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Domain domain;
    private String host;
    private String id;
    private String path;
    private Integer port;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Route} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Route instance) {
      return from((_Route) instance);
    }

    /**
     * Copy abstract value type {@code _Route} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Route instance) {
      Objects.requireNonNull(instance, "instance");
      Domain domainValue = instance.getDomain();
      if (domainValue != null) {
        domain(domainValue);
      }
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      Integer portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Route#getDomain() domain} attribute.
     * @param domain The value for domain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(@Nullable Domain domain) {
      this.domain = domain;
      return this;
    }

    /**
     * Initializes the value for the {@link _Route#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link _Route#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link _Route#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link _Route#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Builds a new {@link Route Route}.
     * @return An immutable instance of Route
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Route build() {
      return new Route(this);
    }
  }
}
