package org.cloudfoundry.client.v2.serviceinstances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _CreateServiceInstanceRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CreateServiceInstanceRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_CreateServiceInstanceRequest"})
public final class CreateServiceInstanceRequest
    extends org.cloudfoundry.client.v2.serviceinstances._CreateServiceInstanceRequest {
  private final @Nullable Boolean acceptsIncomplete;
  private final String name;
  private final @Nullable Map<String, Object> parameters;
  private final String servicePlanId;
  private final String spaceId;
  private final @Nullable List<String> tags;

  private CreateServiceInstanceRequest(CreateServiceInstanceRequest.Builder builder) {
    this.acceptsIncomplete = builder.acceptsIncomplete;
    this.name = builder.name;
    this.parameters = builder.parameters == null ? null : createUnmodifiableMap(false, false, builder.parameters);
    this.servicePlanId = builder.servicePlanId;
    this.spaceId = builder.spaceId;
    this.tags = builder.tags == null ? null : createUnmodifiableList(true, builder.tags);
  }

  /**
   * The accept incomplete flag
   */
  @Override
  public @Nullable Boolean getAcceptsIncomplete() {
    return acceptsIncomplete;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * Key/value pairs of all arbitrary parameters to pass along to the service broker
   */
  @Override
  public @Nullable Map<String, Object> getParameters() {
    return parameters;
  }

  /**
   * The service plan id
   */
  @Override
  public String getServicePlanId() {
    return servicePlanId;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * A list of tags for the service instance
   */
  @Override
  public @Nullable List<String> getTags() {
    return tags;
  }

  /**
   * This instance is equal to all instances of {@code CreateServiceInstanceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateServiceInstanceRequest
        && equalTo((CreateServiceInstanceRequest) another);
  }

  private boolean equalTo(CreateServiceInstanceRequest another) {
    return Objects.equals(acceptsIncomplete, another.acceptsIncomplete)
        && name.equals(another.name)
        && Objects.equals(parameters, another.parameters)
        && servicePlanId.equals(another.servicePlanId)
        && spaceId.equals(another.spaceId)
        && Objects.equals(tags, another.tags);
  }

  /**
   * Computes a hash code from attributes: {@code acceptsIncomplete}, {@code name}, {@code parameters}, {@code servicePlanId}, {@code spaceId}, {@code tags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(acceptsIncomplete);
    h = h * 17 + name.hashCode();
    h = h * 17 + Objects.hashCode(parameters);
    h = h * 17 + servicePlanId.hashCode();
    h = h * 17 + spaceId.hashCode();
    h = h * 17 + Objects.hashCode(tags);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateServiceInstanceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateServiceInstanceRequest{"
        + "acceptsIncomplete=" + acceptsIncomplete
        + ", name=" + name
        + ", parameters=" + parameters
        + ", servicePlanId=" + servicePlanId
        + ", spaceId=" + spaceId
        + ", tags=" + tags
        + "}";
  }

  /**
   * Creates a builder for {@link CreateServiceInstanceRequest CreateServiceInstanceRequest}.
   * @return A new CreateServiceInstanceRequest builder
   */
  public static CreateServiceInstanceRequest.Builder builder() {
    return new CreateServiceInstanceRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateServiceInstanceRequest CreateServiceInstanceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_SERVICE_PLAN_ID = 0x2L;
    private static final long INIT_BIT_SPACE_ID = 0x4L;
    private long initBits = 0x7L;

    private Boolean acceptsIncomplete;
    private String name;
    private Map<String, Object> parameters = null;
    private String servicePlanId;
    private String spaceId;
    private List<String> tags = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateServiceInstanceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateServiceInstanceRequest instance) {
      return from((_CreateServiceInstanceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateServiceInstanceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateServiceInstanceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean acceptsIncompleteValue = instance.getAcceptsIncomplete();
      if (acceptsIncompleteValue != null) {
        acceptsIncomplete(acceptsIncompleteValue);
      }
      name(instance.getName());
      Map<String, Object> parametersValue = instance.getParameters();
      if (parametersValue != null) {
        putAllParameters(parametersValue);
      }
      servicePlanId(instance.getServicePlanId());
      spaceId(instance.getSpaceId());
      List<String> tagsValue = instance.getTags();
      if (tagsValue != null) {
        addAllTags(tagsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceInstanceRequest#getAcceptsIncomplete() acceptsIncomplete} attribute.
     * @param acceptsIncomplete The value for acceptsIncomplete (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder acceptsIncomplete(@Nullable Boolean acceptsIncomplete) {
      this.acceptsIncomplete = acceptsIncomplete;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceInstanceRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Put one entry to the {@link _CreateServiceInstanceRequest#getParameters() parameters} map.
     * @param key The key in the parameters map
     * @param value The associated value in the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(String key, Object value) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      this.parameters.put(
          Objects.requireNonNull(key, "parameters key"),
          Objects.requireNonNull(value, "parameters value"));
      return this;
    }

    /**
     * Put one entry to the {@link _CreateServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.parameters.put(
          Objects.requireNonNull(k, "parameters key"),
          Objects.requireNonNull(v, "parameters value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _CreateServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param parameters The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameters(@Nullable Map<String, ? extends Object> parameters) {
      if (parameters == null) {
        this.parameters = null;
        return this;
      }
      this.parameters = new LinkedHashMap<String, Object>();
      return putAllParameters(parameters);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _CreateServiceInstanceRequest#getParameters() parameters} map. Nulls are not permitted
     * @param parameters The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllParameters(Map<String, ? extends Object> parameters) {
      if (this.parameters == null) {
        this.parameters = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : parameters.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.parameters.put(
            Objects.requireNonNull(k, "parameters key"),
            Objects.requireNonNull(v, "parameters value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceInstanceRequest#getServicePlanId() servicePlanId} attribute.
     * @param servicePlanId The value for servicePlanId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanId(String servicePlanId) {
      this.servicePlanId = Objects.requireNonNull(servicePlanId, "servicePlanId");
      initBits &= ~INIT_BIT_SERVICE_PLAN_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceInstanceRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Adds one element to {@link _CreateServiceInstanceRequest#getTags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String element) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link _CreateServiceInstanceRequest#getTags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String... elements) {
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _CreateServiceInstanceRequest#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.tags = null;
        return this;
      }
      this.tags = new ArrayList<String>();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link _CreateServiceInstanceRequest#getTags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      Objects.requireNonNull(elements, "tags element");
      if (this.tags == null) {
        this.tags = new ArrayList<String>();
      }
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Builds a new {@link CreateServiceInstanceRequest CreateServiceInstanceRequest}.
     * @return An immutable instance of CreateServiceInstanceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateServiceInstanceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateServiceInstanceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SERVICE_PLAN_ID) != 0) attributes.add("servicePlanId");
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build CreateServiceInstanceRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
