package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.serviceinstances.ServiceInstance;

/**
 * Immutable implementation of {@link _GetSpaceSummaryResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetSpaceSummaryResponse.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_GetSpaceSummaryResponse"})
public final class GetSpaceSummaryResponse extends org.cloudfoundry.client.v2.spaces._GetSpaceSummaryResponse {
  private final @Nullable List<SpaceApplicationSummary> applications;
  private final @Nullable String id;
  private final @Nullable String name;
  private final @Nullable List<ServiceInstance> services;

  private GetSpaceSummaryResponse(GetSpaceSummaryResponse.Builder builder) {
    this.applications = builder.applications == null ? null : createUnmodifiableList(true, builder.applications);
    this.id = builder.id;
    this.name = builder.name;
    this.services = builder.services == null ? null : createUnmodifiableList(true, builder.services);
  }

  /**
   * The applications
   */
  @JsonProperty("apps")
  @Override
  public @Nullable List<SpaceApplicationSummary> getApplications() {
    return applications;
  }

  /**
   * The id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The services
   */
  @JsonProperty("services")
  @Override
  public @Nullable List<ServiceInstance> getServices() {
    return services;
  }

  /**
   * This instance is equal to all instances of {@code GetSpaceSummaryResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetSpaceSummaryResponse
        && equalTo((GetSpaceSummaryResponse) another);
  }

  private boolean equalTo(GetSpaceSummaryResponse another) {
    return Objects.equals(applications, another.applications)
        && Objects.equals(id, another.id)
        && Objects.equals(name, another.name)
        && Objects.equals(services, another.services);
  }

  /**
   * Computes a hash code from attributes: {@code applications}, {@code id}, {@code name}, {@code services}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(applications);
    h = h * 17 + Objects.hashCode(id);
    h = h * 17 + Objects.hashCode(name);
    h = h * 17 + Objects.hashCode(services);
    return h;
  }

  /**
   * Prints the immutable value {@code GetSpaceSummaryResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetSpaceSummaryResponse{"
        + "applications=" + applications
        + ", id=" + id
        + ", name=" + name
        + ", services=" + services
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.spaces._GetSpaceSummaryResponse {
    List<SpaceApplicationSummary> applications = null;
    String id;
    String name;
    List<ServiceInstance> services = null;
    @JsonProperty("apps")
    public void setApplications(@Nullable List<SpaceApplicationSummary> applications) {
      this.applications = applications;
    }
    @JsonProperty("guid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("services")
    public void setServices(@Nullable List<ServiceInstance> services) {
      this.services = services;
    }
    @Override
    public List<SpaceApplicationSummary> getApplications() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public List<ServiceInstance> getServices() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static GetSpaceSummaryResponse fromJson(Json json) {
    GetSpaceSummaryResponse.Builder builder = GetSpaceSummaryResponse.builder();
    if (json.applications != null) {
      builder.addAllApplications(json.applications);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.services != null) {
      builder.addAllServices(json.services);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetSpaceSummaryResponse GetSpaceSummaryResponse}.
   * @return A new GetSpaceSummaryResponse builder
   */
  public static GetSpaceSummaryResponse.Builder builder() {
    return new GetSpaceSummaryResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetSpaceSummaryResponse GetSpaceSummaryResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<SpaceApplicationSummary> applications = null;
    private String id;
    private String name;
    private List<ServiceInstance> services = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetSpaceSummaryResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetSpaceSummaryResponse instance) {
      return from((_GetSpaceSummaryResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetSpaceSummaryResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetSpaceSummaryResponse instance) {
      Objects.requireNonNull(instance, "instance");
      List<SpaceApplicationSummary> applicationsValue = instance.getApplications();
      if (applicationsValue != null) {
        addAllApplications(applicationsValue);
      }
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      List<ServiceInstance> servicesValue = instance.getServices();
      if (servicesValue != null) {
        addAllServices(servicesValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link _GetSpaceSummaryResponse#getApplications() applications} list.
     * @param element A applications element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder application(SpaceApplicationSummary element) {
      if (this.applications == null) {
        this.applications = new ArrayList<SpaceApplicationSummary>();
      }
      this.applications.add(Objects.requireNonNull(element, "applications element"));
      return this;
    }

    /**
     * Adds elements to {@link _GetSpaceSummaryResponse#getApplications() applications} list.
     * @param elements An array of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder application(SpaceApplicationSummary... elements) {
      if (this.applications == null) {
        this.applications = new ArrayList<SpaceApplicationSummary>();
      }
      for (SpaceApplicationSummary element : elements) {
        this.applications.add(Objects.requireNonNull(element, "applications element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _GetSpaceSummaryResponse#getApplications() applications} list.
     * @param elements An iterable of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applications(@Nullable Iterable<? extends SpaceApplicationSummary> elements) {
      if (elements == null) {
        this.applications = null;
        return this;
      }
      this.applications = new ArrayList<SpaceApplicationSummary>();
      return addAllApplications(elements);
    }

    /**
     * Adds elements to {@link _GetSpaceSummaryResponse#getApplications() applications} list.
     * @param elements An iterable of applications elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplications(Iterable<? extends SpaceApplicationSummary> elements) {
      Objects.requireNonNull(elements, "applications element");
      if (this.applications == null) {
        this.applications = new ArrayList<SpaceApplicationSummary>();
      }
      for (SpaceApplicationSummary element : elements) {
        this.applications.add(Objects.requireNonNull(element, "applications element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _GetSpaceSummaryResponse#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetSpaceSummaryResponse#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Adds one element to {@link _GetSpaceSummaryResponse#getServices() services} list.
     * @param element A services element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder service(ServiceInstance element) {
      if (this.services == null) {
        this.services = new ArrayList<ServiceInstance>();
      }
      this.services.add(Objects.requireNonNull(element, "services element"));
      return this;
    }

    /**
     * Adds elements to {@link _GetSpaceSummaryResponse#getServices() services} list.
     * @param elements An array of services elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder service(ServiceInstance... elements) {
      if (this.services == null) {
        this.services = new ArrayList<ServiceInstance>();
      }
      for (ServiceInstance element : elements) {
        this.services.add(Objects.requireNonNull(element, "services element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _GetSpaceSummaryResponse#getServices() services} list.
     * @param elements An iterable of services elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder services(@Nullable Iterable<? extends ServiceInstance> elements) {
      if (elements == null) {
        this.services = null;
        return this;
      }
      this.services = new ArrayList<ServiceInstance>();
      return addAllServices(elements);
    }

    /**
     * Adds elements to {@link _GetSpaceSummaryResponse#getServices() services} list.
     * @param elements An iterable of services elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServices(Iterable<? extends ServiceInstance> elements) {
      Objects.requireNonNull(elements, "services element");
      if (this.services == null) {
        this.services = new ArrayList<ServiceInstance>();
      }
      for (ServiceInstance element : elements) {
        this.services.add(Objects.requireNonNull(element, "services element"));
      }
      return this;
    }

    /**
     * Builds a new {@link GetSpaceSummaryResponse GetSpaceSummaryResponse}.
     * @return An immutable instance of GetSpaceSummaryResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetSpaceSummaryResponse build() {
      return new GetSpaceSummaryResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
