package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _Pagination}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Pagination.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_Pagination"})
public final class Pagination extends org.cloudfoundry.client.v3._Pagination {
  private final @Nullable Link first;
  private final @Nullable Link last;
  private final @Nullable Link next;
  private final @Nullable Link previous;
  private final @Nullable Integer totalPages;
  private final @Nullable Integer totalResults;

  private Pagination(Pagination.Builder builder) {
    this.first = builder.first;
    this.last = builder.last;
    this.next = builder.next;
    this.previous = builder.previous;
    this.totalPages = builder.totalPages;
    this.totalResults = builder.totalResults;
  }

  /**
   * The first
   */
  @JsonProperty("first")
  @Override
  public @Nullable Link getFirst() {
    return first;
  }

  /**
   * The last
   */
  @JsonProperty("last")
  @Override
  public @Nullable Link getLast() {
    return last;
  }

  /**
   * The next
   */
  @JsonProperty("next")
  @Override
  public @Nullable Link getNext() {
    return next;
  }

  /**
   * The previous
   */
  @JsonProperty("previous")
  @Override
  public @Nullable Link getPrevious() {
    return previous;
  }

  /**
   * The total pages
   */
  @JsonProperty("total_pages")
  @Override
  public @Nullable Integer getTotalPages() {
    return totalPages;
  }

  /**
   * The total results
   */
  @JsonProperty("total_results")
  @Override
  public @Nullable Integer getTotalResults() {
    return totalResults;
  }

  /**
   * This instance is equal to all instances of {@code Pagination} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Pagination
        && equalTo((Pagination) another);
  }

  private boolean equalTo(Pagination another) {
    return Objects.equals(first, another.first)
        && Objects.equals(last, another.last)
        && Objects.equals(next, another.next)
        && Objects.equals(previous, another.previous)
        && Objects.equals(totalPages, another.totalPages)
        && Objects.equals(totalResults, another.totalResults);
  }

  /**
   * Computes a hash code from attributes: {@code first}, {@code last}, {@code next}, {@code previous}, {@code totalPages}, {@code totalResults}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(first);
    h = h * 17 + Objects.hashCode(last);
    h = h * 17 + Objects.hashCode(next);
    h = h * 17 + Objects.hashCode(previous);
    h = h * 17 + Objects.hashCode(totalPages);
    h = h * 17 + Objects.hashCode(totalResults);
    return h;
  }

  /**
   * Prints the immutable value {@code Pagination} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Pagination{"
        + "first=" + first
        + ", last=" + last
        + ", next=" + next
        + ", previous=" + previous
        + ", totalPages=" + totalPages
        + ", totalResults=" + totalResults
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._Pagination {
    Link first;
    Link last;
    Link next;
    Link previous;
    Integer totalPages;
    Integer totalResults;
    @JsonProperty("first")
    public void setFirst(@Nullable Link first) {
      this.first = first;
    }
    @JsonProperty("last")
    public void setLast(@Nullable Link last) {
      this.last = last;
    }
    @JsonProperty("next")
    public void setNext(@Nullable Link next) {
      this.next = next;
    }
    @JsonProperty("previous")
    public void setPrevious(@Nullable Link previous) {
      this.previous = previous;
    }
    @JsonProperty("total_pages")
    public void setTotalPages(@Nullable Integer totalPages) {
      this.totalPages = totalPages;
    }
    @JsonProperty("total_results")
    public void setTotalResults(@Nullable Integer totalResults) {
      this.totalResults = totalResults;
    }
    @Override
    public Link getFirst() { throw new UnsupportedOperationException(); }
    @Override
    public Link getLast() { throw new UnsupportedOperationException(); }
    @Override
    public Link getNext() { throw new UnsupportedOperationException(); }
    @Override
    public Link getPrevious() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalPages() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalResults() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Pagination fromJson(Json json) {
    Pagination.Builder builder = Pagination.builder();
    if (json.first != null) {
      builder.first(json.first);
    }
    if (json.last != null) {
      builder.last(json.last);
    }
    if (json.next != null) {
      builder.next(json.next);
    }
    if (json.previous != null) {
      builder.previous(json.previous);
    }
    if (json.totalPages != null) {
      builder.totalPages(json.totalPages);
    }
    if (json.totalResults != null) {
      builder.totalResults(json.totalResults);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Pagination Pagination}.
   * @return A new Pagination builder
   */
  public static Pagination.Builder builder() {
    return new Pagination.Builder();
  }

  /**
   * Builds instances of type {@link Pagination Pagination}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Link first;
    private Link last;
    private Link next;
    private Link previous;
    private Integer totalPages;
    private Integer totalResults;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Pagination} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Pagination instance) {
      return from((_Pagination) instance);
    }

    /**
     * Copy abstract value type {@code _Pagination} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Pagination instance) {
      Objects.requireNonNull(instance, "instance");
      Link firstValue = instance.getFirst();
      if (firstValue != null) {
        first(firstValue);
      }
      Link lastValue = instance.getLast();
      if (lastValue != null) {
        last(lastValue);
      }
      Link nextValue = instance.getNext();
      if (nextValue != null) {
        next(nextValue);
      }
      Link previousValue = instance.getPrevious();
      if (previousValue != null) {
        previous(previousValue);
      }
      Integer totalPagesValue = instance.getTotalPages();
      if (totalPagesValue != null) {
        totalPages(totalPagesValue);
      }
      Integer totalResultsValue = instance.getTotalResults();
      if (totalResultsValue != null) {
        totalResults(totalResultsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Pagination#getFirst() first} attribute.
     * @param first The value for first (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder first(@Nullable Link first) {
      this.first = first;
      return this;
    }

    /**
     * Initializes the value for the {@link _Pagination#getLast() last} attribute.
     * @param last The value for last (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder last(@Nullable Link last) {
      this.last = last;
      return this;
    }

    /**
     * Initializes the value for the {@link _Pagination#getNext() next} attribute.
     * @param next The value for next (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder next(@Nullable Link next) {
      this.next = next;
      return this;
    }

    /**
     * Initializes the value for the {@link _Pagination#getPrevious() previous} attribute.
     * @param previous The value for previous (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder previous(@Nullable Link previous) {
      this.previous = previous;
      return this;
    }

    /**
     * Initializes the value for the {@link _Pagination#getTotalPages() totalPages} attribute.
     * @param totalPages The value for totalPages (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalPages(@Nullable Integer totalPages) {
      this.totalPages = totalPages;
      return this;
    }

    /**
     * Initializes the value for the {@link _Pagination#getTotalResults() totalResults} attribute.
     * @param totalResults The value for totalResults (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder totalResults(@Nullable Integer totalResults) {
      this.totalResults = totalResults;
      return this;
    }

    /**
     * Builds a new {@link Pagination Pagination}.
     * @return An immutable instance of Pagination
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Pagination build() {
      return new Pagination(this);
    }
  }
}
