package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _CancelApplicationTaskRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code CancelApplicationTaskRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_CancelApplicationTaskRequest"})
public final class CancelApplicationTaskRequest
    extends org.cloudfoundry.client.v3.applications._CancelApplicationTaskRequest {
  private final String applicationId;
  private final String taskId;

  private CancelApplicationTaskRequest(CancelApplicationTaskRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.taskId = builder.taskId;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The task taskId
   */
  @Override
  public String getTaskId() {
    return taskId;
  }

  /**
   * This instance is equal to all instances of {@code CancelApplicationTaskRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CancelApplicationTaskRequest
        && equalTo((CancelApplicationTaskRequest) another);
  }

  private boolean equalTo(CancelApplicationTaskRequest another) {
    return applicationId.equals(another.applicationId)
        && taskId.equals(another.taskId);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code taskId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationId.hashCode();
    h = h * 17 + taskId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CancelApplicationTaskRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CancelApplicationTaskRequest{"
        + "applicationId=" + applicationId
        + ", taskId=" + taskId
        + "}";
  }

  /**
   * Creates a builder for {@link CancelApplicationTaskRequest CancelApplicationTaskRequest}.
   * @return A new CancelApplicationTaskRequest builder
   */
  public static CancelApplicationTaskRequest.Builder builder() {
    return new CancelApplicationTaskRequest.Builder();
  }

  /**
   * Builds instances of type {@link CancelApplicationTaskRequest CancelApplicationTaskRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_TASK_ID = 0x2L;
    private long initBits = 0x3L;

    private String applicationId;
    private String taskId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CancelApplicationTaskRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CancelApplicationTaskRequest instance) {
      return from((_CancelApplicationTaskRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CancelApplicationTaskRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CancelApplicationTaskRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      taskId(instance.getTaskId());
      return this;
    }

    /**
     * Initializes the value for the {@link _CancelApplicationTaskRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _CancelApplicationTaskRequest#getTaskId() taskId} attribute.
     * @param taskId The value for taskId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder taskId(String taskId) {
      this.taskId = Objects.requireNonNull(taskId, "taskId");
      initBits &= ~INIT_BIT_TASK_ID;
      return this;
    }

    /**
     * Builds a new {@link CancelApplicationTaskRequest CancelApplicationTaskRequest}.
     * @return An immutable instance of CancelApplicationTaskRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CancelApplicationTaskRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CancelApplicationTaskRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_TASK_ID) != 0) attributes.add("taskId");
      return "Cannot build CancelApplicationTaskRequest, some of required attributes are not set " + attributes;
    }
  }
}
