package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _StartApplicationRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code StartApplicationRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_StartApplicationRequest"})
public final class StartApplicationRequest
    extends org.cloudfoundry.client.v3.applications._StartApplicationRequest {
  private final String applicationId;

  private StartApplicationRequest(StartApplicationRequest.Builder builder) {
    this.applicationId = builder.applicationId;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * This instance is equal to all instances of {@code StartApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof StartApplicationRequest
        && equalTo((StartApplicationRequest) another);
  }

  private boolean equalTo(StartApplicationRequest another) {
    return applicationId.equals(another.applicationId);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StartApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StartApplicationRequest{"
        + "applicationId=" + applicationId
        + "}";
  }

  /**
   * Creates a builder for {@link StartApplicationRequest StartApplicationRequest}.
   * @return A new StartApplicationRequest builder
   */
  public static StartApplicationRequest.Builder builder() {
    return new StartApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link StartApplicationRequest StartApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StartApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StartApplicationRequest instance) {
      return from((_StartApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _StartApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_StartApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      return this;
    }

    /**
     * Initializes the value for the {@link _StartApplicationRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Builds a new {@link StartApplicationRequest StartApplicationRequest}.
     * @return An immutable instance of StartApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public StartApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new StartApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build StartApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
