package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;

/**
 * Immutable implementation of {@link _UpdateApplicationRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UpdateApplicationRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_UpdateApplicationRequest"})
public final class UpdateApplicationRequest
    extends org.cloudfoundry.client.v3.applications._UpdateApplicationRequest {
  private final String applicationId;
  private final @Nullable Map<String, Object> environmentVariables;
  private final @Nullable Lifecycle lifecycle;
  private final @Nullable String name;

  private UpdateApplicationRequest(UpdateApplicationRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.environmentVariables = builder.environmentVariables == null ? null : createUnmodifiableMap(false, false, builder.environmentVariables);
    this.lifecycle = builder.lifecycle;
    this.name = builder.name;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The environment variables
   */
  @Override
  public @Nullable Map<String, Object> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * The lifecycle
   */
  @Override
  public @Nullable Lifecycle getLifecycle() {
    return lifecycle;
  }

  /**
   * The name
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code UpdateApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateApplicationRequest
        && equalTo((UpdateApplicationRequest) another);
  }

  private boolean equalTo(UpdateApplicationRequest another) {
    return applicationId.equals(another.applicationId)
        && Objects.equals(environmentVariables, another.environmentVariables)
        && Objects.equals(lifecycle, another.lifecycle)
        && Objects.equals(name, another.name);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code environmentVariables}, {@code lifecycle}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + applicationId.hashCode();
    h = h * 17 + Objects.hashCode(environmentVariables);
    h = h * 17 + Objects.hashCode(lifecycle);
    h = h * 17 + Objects.hashCode(name);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateApplicationRequest{"
        + "applicationId=" + applicationId
        + ", environmentVariables=" + environmentVariables
        + ", lifecycle=" + lifecycle
        + ", name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateApplicationRequest UpdateApplicationRequest}.
   * @return A new UpdateApplicationRequest builder
   */
  public static UpdateApplicationRequest.Builder builder() {
    return new UpdateApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateApplicationRequest UpdateApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationId;
    private Map<String, Object> environmentVariables = null;
    private Lifecycle lifecycle;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateApplicationRequest instance) {
      return from((_UpdateApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      Map<String, Object> environmentVariablesValue = instance.getEnvironmentVariables();
      if (environmentVariablesValue != null) {
        putAllEnvironmentVariables(environmentVariablesValue);
      }
      Lifecycle lifecycleValue = instance.getLifecycle();
      if (lifecycleValue != null) {
        lifecycle(lifecycleValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Put one entry to the {@link _UpdateApplicationRequest#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(String key, Object value) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      this.environmentVariables.put(
          Objects.requireNonNull(key, "environmentVariables key"),
          Objects.requireNonNull(value, "environmentVariables value"));
      return this;
    }

    /**
     * Put one entry to the {@link _UpdateApplicationRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(Map.Entry<String, ? extends Object> entry) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.environmentVariables.put(
          Objects.requireNonNull(k, "environmentVariables key"),
          Objects.requireNonNull(v, "environmentVariables value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _UpdateApplicationRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariables(@Nullable Map<String, ? extends Object> environmentVariables) {
      if (environmentVariables == null) {
        this.environmentVariables = null;
        return this;
      }
      this.environmentVariables = new LinkedHashMap<String, Object>();
      return putAllEnvironmentVariables(environmentVariables);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _UpdateApplicationRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<String, ? extends Object> environmentVariables) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : environmentVariables.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.environmentVariables.put(
            Objects.requireNonNull(k, "environmentVariables key"),
            Objects.requireNonNull(v, "environmentVariables value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getLifecycle() lifecycle} attribute.
     * @param lifecycle The value for lifecycle (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lifecycle(@Nullable Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Builds a new {@link UpdateApplicationRequest UpdateApplicationRequest}.
     * @return An immutable instance of UpdateApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build UpdateApplicationRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
