package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Hash;

/**
 * Immutable implementation of {@link _BitsData}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code BitsData.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_BitsData"})
public final class BitsData extends org.cloudfoundry.client.v3.packages._BitsData {
  private final @Nullable String error;
  private final @Nullable Hash hash;

  private BitsData(BitsData.Builder builder) {
    this.error = builder.error;
    this.hash = builder.hash;
  }

  /**
   * The error for the package
   */
  @JsonProperty("error")
  @Override
  public @Nullable String getError() {
    return error;
  }

  /**
   * The hash of the package
   */
  @JsonProperty("hash")
  @Override
  public @Nullable Hash getHash() {
    return hash;
  }

  /**
   * This instance is equal to all instances of {@code BitsData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BitsData
        && equalTo((BitsData) another);
  }

  private boolean equalTo(BitsData another) {
    return Objects.equals(error, another.error)
        && Objects.equals(hash, another.hash);
  }

  /**
   * Computes a hash code from attributes: {@code error}, {@code hash}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(error);
    h = h * 17 + Objects.hashCode(hash);
    return h;
  }

  /**
   * Prints the immutable value {@code BitsData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BitsData{"
        + "error=" + error
        + ", hash=" + hash
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.packages._BitsData {
    String error;
    Hash hash;
    @JsonProperty("error")
    public void setError(@Nullable String error) {
      this.error = error;
    }
    @JsonProperty("hash")
    public void setHash(@Nullable Hash hash) {
      this.hash = hash;
    }
    @Override
    public String getError() { throw new UnsupportedOperationException(); }
    @Override
    public Hash getHash() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static BitsData fromJson(Json json) {
    BitsData.Builder builder = BitsData.builder();
    if (json.error != null) {
      builder.error(json.error);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link BitsData BitsData}.
   * @return A new BitsData builder
   */
  public static BitsData.Builder builder() {
    return new BitsData.Builder();
  }

  /**
   * Builds instances of type {@link BitsData BitsData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String error;
    private Hash hash;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BitsData} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BitsData instance) {
      return from((_BitsData) instance);
    }

    /**
     * Copy abstract value type {@code _BitsData} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_BitsData instance) {
      Objects.requireNonNull(instance, "instance");
      String errorValue = instance.getError();
      if (errorValue != null) {
        error(errorValue);
      }
      Hash hashValue = instance.getHash();
      if (hashValue != null) {
        hash(hashValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _BitsData#getError() error} attribute.
     * @param error The value for error (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder error(@Nullable String error) {
      this.error = error;
      return this;
    }

    /**
     * Initializes the value for the {@link _BitsData#getHash() hash} attribute.
     * @param hash The value for hash (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hash(@Nullable Hash hash) {
      this.hash = hash;
      return this;
    }

    /**
     * Builds a new {@link BitsData BitsData}.
     * @return An immutable instance of BitsData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BitsData build() {
      return new BitsData(this);
    }
  }
}
