package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _Envelope}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Envelope.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_Envelope"})
public final class Envelope extends org.cloudfoundry.doppler._Envelope {
  private final @Nullable ContainerMetric containerMetric;
  private final @Nullable CounterEvent counterEvent;
  private final @Nullable String deployment;
  private final @Nullable Error error;
  private final EventType eventType;
  private final @Nullable HttpStart httpStart;
  private final @Nullable HttpStartStop httpStartStop;
  private final @Nullable HttpStop httpStop;
  private final @Nullable String index;
  private final @Nullable String ip;
  private final @Nullable String job;
  private final @Nullable LogMessage logMessage;
  private final String origin;
  private final Map<String, String> tags;
  private final @Nullable Long timestamp;
  private final @Nullable ValueMetric valueMetric;

  private Envelope(Envelope.Builder builder) {
    this.containerMetric = builder.containerMetric;
    this.counterEvent = builder.counterEvent;
    this.deployment = builder.deployment;
    this.error = builder.error;
    this.eventType = builder.eventType;
    this.httpStart = builder.httpStart;
    this.httpStartStop = builder.httpStartStop;
    this.httpStop = builder.httpStop;
    this.index = builder.index;
    this.ip = builder.ip;
    this.job = builder.job;
    this.logMessage = builder.logMessage;
    this.origin = builder.origin;
    this.tags = createUnmodifiableMap(false, false, builder.tags);
    this.timestamp = builder.timestamp;
    this.valueMetric = builder.valueMetric;
  }

  /**
   * The enclosed {@link ContainerMetric}
   */
  @Override
  public @Nullable ContainerMetric getContainerMetric() {
    return containerMetric;
  }

  /**
   * The enclosed {@link CounterEvent}
   */
  @Override
  public @Nullable CounterEvent getCounterEvent() {
    return counterEvent;
  }

  /**
   * Deployment name (used to uniquely identify source)
   */
  @Override
  public @Nullable String getDeployment() {
    return deployment;
  }

  /**
   * The enclosed {@link Error}
   */
  @Override
  public @Nullable Error getError() {
    return error;
  }

  /**
   * Type of wrapped event. Only the optional field corresponding to the value of eventType should be set.
   */
  @Override
  public EventType getEventType() {
    return eventType;
  }

  /**
   * The enclosed {@link HttpStart}
   */
  @Override
  public @Nullable HttpStart getHttpStart() {
    return httpStart;
  }

  /**
   * The enclosed {@link HttpStartStop}
   */
  @Override
  public @Nullable HttpStartStop getHttpStartStop() {
    return httpStartStop;
  }

  /**
   * The enclosed {@link HttpStop}
   */
  @Override
  public @Nullable HttpStop getHttpStop() {
    return httpStop;
  }

  /**
   * Index of job (used to uniquely identify source)
   */
  @Override
  public @Nullable String getIndex() {
    return index;
  }

  /**
   * IP address (used to uniquely identify source)
   */
  @Override
  public @Nullable String getIp() {
    return ip;
  }

  /**
   * Job name (used to uniquely identify source)
   */
  @Override
  public @Nullable String getJob() {
    return job;
  }

  /**
   * The enclosed {@link LogMessage}
   */
  @Override
  public @Nullable LogMessage getLogMessage() {
    return logMessage;
  }

  /**
   * Unique description of the origin of this event
   */
  @Override
  public String getOrigin() {
    return origin;
  }

  /**
   * key/value tags to include additional identifying information
   */
  @Override
  public Map<String, String> getTags() {
    return tags;
  }

  /**
   * UNIX timestamp (in nanoseconds) event was wrapped in this Envelope.
   */
  @Override
  public @Nullable Long getTimestamp() {
    return timestamp;
  }

  /**
   * The enclosed {@link ValueMetric}
   */
  @Override
  public @Nullable ValueMetric getValueMetric() {
    return valueMetric;
  }

  /**
   * This instance is equal to all instances of {@code Envelope} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Envelope
        && equalTo((Envelope) another);
  }

  private boolean equalTo(Envelope another) {
    return Objects.equals(containerMetric, another.containerMetric)
        && Objects.equals(counterEvent, another.counterEvent)
        && Objects.equals(deployment, another.deployment)
        && Objects.equals(error, another.error)
        && eventType.equals(another.eventType)
        && Objects.equals(httpStart, another.httpStart)
        && Objects.equals(httpStartStop, another.httpStartStop)
        && Objects.equals(httpStop, another.httpStop)
        && Objects.equals(index, another.index)
        && Objects.equals(ip, another.ip)
        && Objects.equals(job, another.job)
        && Objects.equals(logMessage, another.logMessage)
        && origin.equals(another.origin)
        && tags.equals(another.tags)
        && Objects.equals(timestamp, another.timestamp)
        && Objects.equals(valueMetric, another.valueMetric);
  }

  /**
   * Computes a hash code from attributes: {@code containerMetric}, {@code counterEvent}, {@code deployment}, {@code error}, {@code eventType}, {@code httpStart}, {@code httpStartStop}, {@code httpStop}, {@code index}, {@code ip}, {@code job}, {@code logMessage}, {@code origin}, {@code tags}, {@code timestamp}, {@code valueMetric}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(containerMetric);
    h = h * 17 + Objects.hashCode(counterEvent);
    h = h * 17 + Objects.hashCode(deployment);
    h = h * 17 + Objects.hashCode(error);
    h = h * 17 + eventType.hashCode();
    h = h * 17 + Objects.hashCode(httpStart);
    h = h * 17 + Objects.hashCode(httpStartStop);
    h = h * 17 + Objects.hashCode(httpStop);
    h = h * 17 + Objects.hashCode(index);
    h = h * 17 + Objects.hashCode(ip);
    h = h * 17 + Objects.hashCode(job);
    h = h * 17 + Objects.hashCode(logMessage);
    h = h * 17 + origin.hashCode();
    h = h * 17 + tags.hashCode();
    h = h * 17 + Objects.hashCode(timestamp);
    h = h * 17 + Objects.hashCode(valueMetric);
    return h;
  }

  /**
   * Prints the immutable value {@code Envelope} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Envelope{"
        + "containerMetric=" + containerMetric
        + ", counterEvent=" + counterEvent
        + ", deployment=" + deployment
        + ", error=" + error
        + ", eventType=" + eventType
        + ", httpStart=" + httpStart
        + ", httpStartStop=" + httpStartStop
        + ", httpStop=" + httpStop
        + ", index=" + index
        + ", ip=" + ip
        + ", job=" + job
        + ", logMessage=" + logMessage
        + ", origin=" + origin
        + ", tags=" + tags
        + ", timestamp=" + timestamp
        + ", valueMetric=" + valueMetric
        + "}";
  }

  /**
   * Creates a builder for {@link Envelope Envelope}.
   * @return A new Envelope builder
   */
  public static Envelope.Builder builder() {
    return new Envelope.Builder();
  }

  /**
   * Builds instances of type {@link Envelope Envelope}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_EVENT_TYPE = 0x1L;
    private static final long INIT_BIT_ORIGIN = 0x2L;
    private long initBits = 0x3L;

    private ContainerMetric containerMetric;
    private CounterEvent counterEvent;
    private String deployment;
    private Error error;
    private EventType eventType;
    private HttpStart httpStart;
    private HttpStartStop httpStartStop;
    private HttpStop httpStop;
    private String index;
    private String ip;
    private String job;
    private LogMessage logMessage;
    private String origin;
    private Map<String, String> tags = new LinkedHashMap<String, String>();
    private Long timestamp;
    private ValueMetric valueMetric;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Envelope} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Envelope instance) {
      return from((_Envelope) instance);
    }

    /**
     * Copy abstract value type {@code _Envelope} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Envelope instance) {
      Objects.requireNonNull(instance, "instance");
      ContainerMetric containerMetricValue = instance.getContainerMetric();
      if (containerMetricValue != null) {
        containerMetric(containerMetricValue);
      }
      CounterEvent counterEventValue = instance.getCounterEvent();
      if (counterEventValue != null) {
        counterEvent(counterEventValue);
      }
      String deploymentValue = instance.getDeployment();
      if (deploymentValue != null) {
        deployment(deploymentValue);
      }
      Error errorValue = instance.getError();
      if (errorValue != null) {
        error(errorValue);
      }
      eventType(instance.getEventType());
      HttpStart httpStartValue = instance.getHttpStart();
      if (httpStartValue != null) {
        httpStart(httpStartValue);
      }
      HttpStartStop httpStartStopValue = instance.getHttpStartStop();
      if (httpStartStopValue != null) {
        httpStartStop(httpStartStopValue);
      }
      HttpStop httpStopValue = instance.getHttpStop();
      if (httpStopValue != null) {
        httpStop(httpStopValue);
      }
      String indexValue = instance.getIndex();
      if (indexValue != null) {
        index(indexValue);
      }
      String ipValue = instance.getIp();
      if (ipValue != null) {
        ip(ipValue);
      }
      String jobValue = instance.getJob();
      if (jobValue != null) {
        job(jobValue);
      }
      LogMessage logMessageValue = instance.getLogMessage();
      if (logMessageValue != null) {
        logMessage(logMessageValue);
      }
      origin(instance.getOrigin());
      putAllTags(instance.getTags());
      Long timestampValue = instance.getTimestamp();
      if (timestampValue != null) {
        timestamp(timestampValue);
      }
      ValueMetric valueMetricValue = instance.getValueMetric();
      if (valueMetricValue != null) {
        valueMetric(valueMetricValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Envelope#getContainerMetric() containerMetric} attribute.
     * @param containerMetric The value for containerMetric (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder containerMetric(@Nullable ContainerMetric containerMetric) {
      this.containerMetric = containerMetric;
      return this;
    }

    /**
     * Initializes the value for the {@link _Envelope#getCounterEvent() counterEvent} attribute.
     * @param counterEvent The value for counterEvent (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder counterEvent(@Nullable CounterEvent counterEvent) {
      this.counterEvent = counterEvent;
      return this;
    }

    /**
     * Initializes the value for the {@link _Envelope#getDeployment() deployment} attribute.
     * @param deployment The value for deployment (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder deployment(@Nullable String deployment) {
      this.deployment = deployment;
      return this;
    }

    /**
     * Initializes the value for the {@link _Envelope#getError() error} attribute.
     * @param error The value for error (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder error(@Nullable Error error) {
      this.error = error;
      return this;
    }

    /**
     * Initializes the value for the {@link _Envelope#getEventType() eventType} attribute.
     * @param eventType The value for eventType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder eventType(EventType eventType) {
      this.eventType = Objects.requireNonNull(eventType, "eventType");
      initBits &= ~INIT_BIT_EVENT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link _Envelope#getHttpStart() httpStart} attribute.
     * @param httpStart The value for httpStart (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder httpStart(@Nullable HttpStart httpStart) {
      this.httpStart = httpStart;
      return this;
    }

    /**
     * Initializes the value for the {@link _Envelope#getHttpStartStop() httpStartStop} attribute.
     * @param httpStartStop The value for httpStartStop (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder httpStartStop(@Nullable HttpStartStop httpStartStop) {
      this.httpStartStop = httpStartStop;
      return this;
    }

    /**
     * Initializes the value for the {@link _Envelope#getHttpStop() httpStop} attribute.
     * @param httpStop The value for httpStop (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder httpStop(@Nullable HttpStop httpStop) {
      this.httpStop = httpStop;
      return this;
    }

    /**
     * Initializes the value for the {@link _Envelope#getIndex() index} attribute.
     * @param index The value for index (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder index(@Nullable String index) {
      this.index = index;
      return this;
    }

    /**
     * Initializes the value for the {@link _Envelope#getIp() ip} attribute.
     * @param ip The value for ip (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ip(@Nullable String ip) {
      this.ip = ip;
      return this;
    }

    /**
     * Initializes the value for the {@link _Envelope#getJob() job} attribute.
     * @param job The value for job (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder job(@Nullable String job) {
      this.job = job;
      return this;
    }

    /**
     * Initializes the value for the {@link _Envelope#getLogMessage() logMessage} attribute.
     * @param logMessage The value for logMessage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder logMessage(@Nullable LogMessage logMessage) {
      this.logMessage = logMessage;
      return this;
    }

    /**
     * Initializes the value for the {@link _Envelope#getOrigin() origin} attribute.
     * @param origin The value for origin 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(String origin) {
      this.origin = Objects.requireNonNull(origin, "origin");
      initBits &= ~INIT_BIT_ORIGIN;
      return this;
    }

    /**
     * Put one entry to the {@link _Envelope#getTags() tags} map.
     * @param key The key in the tags map
     * @param value The associated value in the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(String key, String value) {
      this.tags.put(
          Objects.requireNonNull(key, "tags key"),
          Objects.requireNonNull(value, "tags value"));
      return this;
    }

    /**
     * Put one entry to the {@link _Envelope#getTags() tags} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tag(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.tags.put(
          Objects.requireNonNull(k, "tags key"),
          Objects.requireNonNull(v, "tags value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _Envelope#getTags() tags} map. Nulls are not permitted
     * @param tags The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tags(Map<String, ? extends String> tags) {
      this.tags.clear();
      return putAllTags(tags);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _Envelope#getTags() tags} map. Nulls are not permitted
     * @param tags The entries that will be added to the tags map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllTags(Map<String, ? extends String> tags) {
      for (Map.Entry<String, ? extends String> entry : tags.entrySet()) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.tags.put(
            Objects.requireNonNull(k, "tags key"),
            Objects.requireNonNull(v, "tags value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Envelope#getTimestamp() timestamp} attribute.
     * @param timestamp The value for timestamp (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timestamp(@Nullable Long timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    /**
     * Initializes the value for the {@link _Envelope#getValueMetric() valueMetric} attribute.
     * @param valueMetric The value for valueMetric (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder valueMetric(@Nullable ValueMetric valueMetric) {
      this.valueMetric = valueMetric;
      return this;
    }

    /**
     * Builds a new {@link Envelope Envelope}.
     * @return An immutable instance of Envelope
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Envelope build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Envelope(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_EVENT_TYPE) != 0) attributes.add("eventType");
      if ((initBits & INIT_BIT_ORIGIN) != 0) attributes.add("origin");
      return "Cannot build Envelope, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
