package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _HttpStart}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code HttpStart.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_HttpStart"})
public final class HttpStart extends org.cloudfoundry.doppler._HttpStart {
  private final @Nullable UUID applicationId;
  private final @Nullable String instanceId;
  private final @Nullable Integer instanceIndex;
  private final Method method;
  private final @Nullable UUID parentRequestId;
  private final PeerType peerType;
  private final String remoteAddress;
  private final UUID requestId;
  private final Long timestamp;
  private final String uri;
  private final String userAgent;

  private HttpStart(HttpStart.Builder builder) {
    this.applicationId = builder.applicationId;
    this.instanceId = builder.instanceId;
    this.instanceIndex = builder.instanceIndex;
    this.method = builder.method;
    this.parentRequestId = builder.parentRequestId;
    this.peerType = builder.peerType;
    this.remoteAddress = builder.remoteAddress;
    this.requestId = builder.requestId;
    this.timestamp = builder.timestamp;
    this.uri = builder.uri;
    this.userAgent = builder.userAgent;
  }

  /**
   * The application id
   */
  @Override
  public @Nullable UUID getApplicationId() {
    return applicationId;
  }

  /**
   * The ID of the application instance
   */
  @Override
  public @Nullable String getInstanceId() {
    return instanceId;
  }

  /**
   * The index of the application instance
   */
  @Override
  public @Nullable Integer getInstanceIndex() {
    return instanceIndex;
  }

  /**
   * The method of the request
   */
  @Override
  public Method getMethod() {
    return method;
  }

  /**
   * The ID of the parent request of any request made to service an incoming request
   */
  @Override
  public @Nullable UUID getParentRequestId() {
    return parentRequestId;
  }

  /**
   * The role of the emitting process in the request cycle
   */
  @Override
  public PeerType getPeerType() {
    return peerType;
  }

  /**
   * The remote address of the request. (For a server, this should be the origin of the request.)
   */
  @Override
  public String getRemoteAddress() {
    return remoteAddress;
  }

  /**
   * The ID for tracking lifecycle of request. Should match requestId of a {@link HttpStop} event
   */
  @Override
  public UUID getRequestId() {
    return requestId;
  }

  /**
   * The UNIX timestamp (in nanoseconds) when the request was sent (by a client) or received (by a server)
   */
  @Override
  public Long getTimestamp() {
    return timestamp;
  }

  /**
   * The uri of the request
   */
  @Override
  public String getUri() {
    return uri;
  }

  /**
   * The contents of the UserAgent header on the request
   */
  @Override
  public String getUserAgent() {
    return userAgent;
  }

  /**
   * This instance is equal to all instances of {@code HttpStart} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof HttpStart
        && equalTo((HttpStart) another);
  }

  private boolean equalTo(HttpStart another) {
    return Objects.equals(applicationId, another.applicationId)
        && Objects.equals(instanceId, another.instanceId)
        && Objects.equals(instanceIndex, another.instanceIndex)
        && method.equals(another.method)
        && Objects.equals(parentRequestId, another.parentRequestId)
        && peerType.equals(another.peerType)
        && remoteAddress.equals(another.remoteAddress)
        && requestId.equals(another.requestId)
        && timestamp.equals(another.timestamp)
        && uri.equals(another.uri)
        && userAgent.equals(another.userAgent);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code instanceId}, {@code instanceIndex}, {@code method}, {@code parentRequestId}, {@code peerType}, {@code remoteAddress}, {@code requestId}, {@code timestamp}, {@code uri}, {@code userAgent}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(applicationId);
    h = h * 17 + Objects.hashCode(instanceId);
    h = h * 17 + Objects.hashCode(instanceIndex);
    h = h * 17 + method.hashCode();
    h = h * 17 + Objects.hashCode(parentRequestId);
    h = h * 17 + peerType.hashCode();
    h = h * 17 + remoteAddress.hashCode();
    h = h * 17 + requestId.hashCode();
    h = h * 17 + timestamp.hashCode();
    h = h * 17 + uri.hashCode();
    h = h * 17 + userAgent.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code HttpStart} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "HttpStart{"
        + "applicationId=" + applicationId
        + ", instanceId=" + instanceId
        + ", instanceIndex=" + instanceIndex
        + ", method=" + method
        + ", parentRequestId=" + parentRequestId
        + ", peerType=" + peerType
        + ", remoteAddress=" + remoteAddress
        + ", requestId=" + requestId
        + ", timestamp=" + timestamp
        + ", uri=" + uri
        + ", userAgent=" + userAgent
        + "}";
  }

  /**
   * Creates a builder for {@link HttpStart HttpStart}.
   * @return A new HttpStart builder
   */
  public static HttpStart.Builder builder() {
    return new HttpStart.Builder();
  }

  /**
   * Builds instances of type {@link HttpStart HttpStart}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_METHOD = 0x1L;
    private static final long INIT_BIT_PEER_TYPE = 0x2L;
    private static final long INIT_BIT_REMOTE_ADDRESS = 0x4L;
    private static final long INIT_BIT_REQUEST_ID = 0x8L;
    private static final long INIT_BIT_TIMESTAMP = 0x10L;
    private static final long INIT_BIT_URI = 0x20L;
    private static final long INIT_BIT_USER_AGENT = 0x40L;
    private long initBits = 0x7fL;

    private UUID applicationId;
    private String instanceId;
    private Integer instanceIndex;
    private Method method;
    private UUID parentRequestId;
    private PeerType peerType;
    private String remoteAddress;
    private UUID requestId;
    private Long timestamp;
    private String uri;
    private String userAgent;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HttpStart} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HttpStart instance) {
      return from((_HttpStart) instance);
    }

    /**
     * Copy abstract value type {@code _HttpStart} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_HttpStart instance) {
      Objects.requireNonNull(instance, "instance");
      UUID applicationIdValue = instance.getApplicationId();
      if (applicationIdValue != null) {
        applicationId(applicationIdValue);
      }
      String instanceIdValue = instance.getInstanceId();
      if (instanceIdValue != null) {
        instanceId(instanceIdValue);
      }
      Integer instanceIndexValue = instance.getInstanceIndex();
      if (instanceIndexValue != null) {
        instanceIndex(instanceIndexValue);
      }
      method(instance.getMethod());
      UUID parentRequestIdValue = instance.getParentRequestId();
      if (parentRequestIdValue != null) {
        parentRequestId(parentRequestIdValue);
      }
      peerType(instance.getPeerType());
      remoteAddress(instance.getRemoteAddress());
      requestId(instance.getRequestId());
      timestamp(instance.getTimestamp());
      uri(instance.getUri());
      userAgent(instance.getUserAgent());
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStart#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(@Nullable UUID applicationId) {
      this.applicationId = applicationId;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStart#getInstanceId() instanceId} attribute.
     * @param instanceId The value for instanceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceId(@Nullable String instanceId) {
      this.instanceId = instanceId;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStart#getInstanceIndex() instanceIndex} attribute.
     * @param instanceIndex The value for instanceIndex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instanceIndex(@Nullable Integer instanceIndex) {
      this.instanceIndex = instanceIndex;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStart#getMethod() method} attribute.
     * @param method The value for method 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder method(Method method) {
      this.method = Objects.requireNonNull(method, "method");
      initBits &= ~INIT_BIT_METHOD;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStart#getParentRequestId() parentRequestId} attribute.
     * @param parentRequestId The value for parentRequestId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parentRequestId(@Nullable UUID parentRequestId) {
      this.parentRequestId = parentRequestId;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStart#getPeerType() peerType} attribute.
     * @param peerType The value for peerType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder peerType(PeerType peerType) {
      this.peerType = Objects.requireNonNull(peerType, "peerType");
      initBits &= ~INIT_BIT_PEER_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStart#getRemoteAddress() remoteAddress} attribute.
     * @param remoteAddress The value for remoteAddress 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder remoteAddress(String remoteAddress) {
      this.remoteAddress = Objects.requireNonNull(remoteAddress, "remoteAddress");
      initBits &= ~INIT_BIT_REMOTE_ADDRESS;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStart#getRequestId() requestId} attribute.
     * @param requestId The value for requestId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requestId(UUID requestId) {
      this.requestId = Objects.requireNonNull(requestId, "requestId");
      initBits &= ~INIT_BIT_REQUEST_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStart#getTimestamp() timestamp} attribute.
     * @param timestamp The value for timestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timestamp(Long timestamp) {
      this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
      initBits &= ~INIT_BIT_TIMESTAMP;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStart#getUri() uri} attribute.
     * @param uri The value for uri 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder uri(String uri) {
      this.uri = Objects.requireNonNull(uri, "uri");
      initBits &= ~INIT_BIT_URI;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStart#getUserAgent() userAgent} attribute.
     * @param userAgent The value for userAgent 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userAgent(String userAgent) {
      this.userAgent = Objects.requireNonNull(userAgent, "userAgent");
      initBits &= ~INIT_BIT_USER_AGENT;
      return this;
    }

    /**
     * Builds a new {@link HttpStart HttpStart}.
     * @return An immutable instance of HttpStart
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public HttpStart build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new HttpStart(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_METHOD) != 0) attributes.add("method");
      if ((initBits & INIT_BIT_PEER_TYPE) != 0) attributes.add("peerType");
      if ((initBits & INIT_BIT_REMOTE_ADDRESS) != 0) attributes.add("remoteAddress");
      if ((initBits & INIT_BIT_REQUEST_ID) != 0) attributes.add("requestId");
      if ((initBits & INIT_BIT_TIMESTAMP) != 0) attributes.add("timestamp");
      if ((initBits & INIT_BIT_URI) != 0) attributes.add("uri");
      if ((initBits & INIT_BIT_USER_AGENT) != 0) attributes.add("userAgent");
      return "Cannot build HttpStart, some of required attributes are not set " + attributes;
    }
  }
}
