package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _HttpStop}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code HttpStop.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_HttpStop"})
public final class HttpStop extends org.cloudfoundry.doppler._HttpStop {
  private final @Nullable UUID applicationId;
  private final Long contentLength;
  private final PeerType peerType;
  private final UUID requestId;
  private final Integer statusCode;
  private final Long timestamp;
  private final String uri;

  private HttpStop(HttpStop.Builder builder) {
    this.applicationId = builder.applicationId;
    this.contentLength = builder.contentLength;
    this.peerType = builder.peerType;
    this.requestId = builder.requestId;
    this.statusCode = builder.statusCode;
    this.timestamp = builder.timestamp;
    this.uri = builder.uri;
  }

  /**
   * The application id
   */
  @Override
  public @Nullable UUID getApplicationId() {
    return applicationId;
  }

  /**
   * The length of the response in bytes
   */
  @Override
  public Long getContentLength() {
    return contentLength;
  }

  /**
   * The role of the emitting process in the request cycle
   */
  @Override
  public PeerType getPeerType() {
    return peerType;
  }

  /**
   * The ID for tracking lifecycle of request. Should match requestId of a {@link HttpStop} event
   */
  @Override
  public UUID getRequestId() {
    return requestId;
  }

  /**
   * The status code returned with the response to the request
   */
  @Override
  public Integer getStatusCode() {
    return statusCode;
  }

  /**
   * The UNIX timestamp (in nanoseconds) when the request was received
   */
  @Override
  public Long getTimestamp() {
    return timestamp;
  }

  /**
   * The uri of the request
   */
  @Override
  public String getUri() {
    return uri;
  }

  /**
   * This instance is equal to all instances of {@code HttpStop} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof HttpStop
        && equalTo((HttpStop) another);
  }

  private boolean equalTo(HttpStop another) {
    return Objects.equals(applicationId, another.applicationId)
        && contentLength.equals(another.contentLength)
        && peerType.equals(another.peerType)
        && requestId.equals(another.requestId)
        && statusCode.equals(another.statusCode)
        && timestamp.equals(another.timestamp)
        && uri.equals(another.uri);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code contentLength}, {@code peerType}, {@code requestId}, {@code statusCode}, {@code timestamp}, {@code uri}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(applicationId);
    h = h * 17 + contentLength.hashCode();
    h = h * 17 + peerType.hashCode();
    h = h * 17 + requestId.hashCode();
    h = h * 17 + statusCode.hashCode();
    h = h * 17 + timestamp.hashCode();
    h = h * 17 + uri.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code HttpStop} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "HttpStop{"
        + "applicationId=" + applicationId
        + ", contentLength=" + contentLength
        + ", peerType=" + peerType
        + ", requestId=" + requestId
        + ", statusCode=" + statusCode
        + ", timestamp=" + timestamp
        + ", uri=" + uri
        + "}";
  }

  /**
   * Creates a builder for {@link HttpStop HttpStop}.
   * @return A new HttpStop builder
   */
  public static HttpStop.Builder builder() {
    return new HttpStop.Builder();
  }

  /**
   * Builds instances of type {@link HttpStop HttpStop}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CONTENT_LENGTH = 0x1L;
    private static final long INIT_BIT_PEER_TYPE = 0x2L;
    private static final long INIT_BIT_REQUEST_ID = 0x4L;
    private static final long INIT_BIT_STATUS_CODE = 0x8L;
    private static final long INIT_BIT_TIMESTAMP = 0x10L;
    private static final long INIT_BIT_URI = 0x20L;
    private long initBits = 0x3fL;

    private UUID applicationId;
    private Long contentLength;
    private PeerType peerType;
    private UUID requestId;
    private Integer statusCode;
    private Long timestamp;
    private String uri;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HttpStop} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HttpStop instance) {
      return from((_HttpStop) instance);
    }

    /**
     * Copy abstract value type {@code _HttpStop} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_HttpStop instance) {
      Objects.requireNonNull(instance, "instance");
      UUID applicationIdValue = instance.getApplicationId();
      if (applicationIdValue != null) {
        applicationId(applicationIdValue);
      }
      contentLength(instance.getContentLength());
      peerType(instance.getPeerType());
      requestId(instance.getRequestId());
      statusCode(instance.getStatusCode());
      timestamp(instance.getTimestamp());
      uri(instance.getUri());
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStop#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(@Nullable UUID applicationId) {
      this.applicationId = applicationId;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStop#getContentLength() contentLength} attribute.
     * @param contentLength The value for contentLength 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder contentLength(Long contentLength) {
      this.contentLength = Objects.requireNonNull(contentLength, "contentLength");
      initBits &= ~INIT_BIT_CONTENT_LENGTH;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStop#getPeerType() peerType} attribute.
     * @param peerType The value for peerType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder peerType(PeerType peerType) {
      this.peerType = Objects.requireNonNull(peerType, "peerType");
      initBits &= ~INIT_BIT_PEER_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStop#getRequestId() requestId} attribute.
     * @param requestId The value for requestId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requestId(UUID requestId) {
      this.requestId = Objects.requireNonNull(requestId, "requestId");
      initBits &= ~INIT_BIT_REQUEST_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStop#getStatusCode() statusCode} attribute.
     * @param statusCode The value for statusCode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder statusCode(Integer statusCode) {
      this.statusCode = Objects.requireNonNull(statusCode, "statusCode");
      initBits &= ~INIT_BIT_STATUS_CODE;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStop#getTimestamp() timestamp} attribute.
     * @param timestamp The value for timestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder timestamp(Long timestamp) {
      this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
      initBits &= ~INIT_BIT_TIMESTAMP;
      return this;
    }

    /**
     * Initializes the value for the {@link _HttpStop#getUri() uri} attribute.
     * @param uri The value for uri 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder uri(String uri) {
      this.uri = Objects.requireNonNull(uri, "uri");
      initBits &= ~INIT_BIT_URI;
      return this;
    }

    /**
     * Builds a new {@link HttpStop HttpStop}.
     * @return An immutable instance of HttpStop
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public HttpStop build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new HttpStop(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_CONTENT_LENGTH) != 0) attributes.add("contentLength");
      if ((initBits & INIT_BIT_PEER_TYPE) != 0) attributes.add("peerType");
      if ((initBits & INIT_BIT_REQUEST_ID) != 0) attributes.add("requestId");
      if ((initBits & INIT_BIT_STATUS_CODE) != 0) attributes.add("statusCode");
      if ((initBits & INIT_BIT_TIMESTAMP) != 0) attributes.add("timestamp");
      if ((initBits & INIT_BIT_URI) != 0) attributes.add("uri");
      return "Cannot build HttpStop, some of required attributes are not set " + attributes;
    }
  }
}
