// Code generated by Wire protocol buffer compiler, do not edit.
// Source file: http.proto at 64:1
package org.cloudfoundry.dropsonde.events;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import okio.ByteString;

/**
 * / An HttpStart event is emitted when a client sends a request (or immediately when a server receives the request).
 */
public final class HttpStart extends Message<HttpStart, HttpStart.Builder> {
  public static final ProtoAdapter<HttpStart> ADAPTER = new ProtoAdapter_HttpStart();

  private static final long serialVersionUID = 0L;

  public static final Long DEFAULT_TIMESTAMP = 0L;

  public static final PeerType DEFAULT_PEERTYPE = PeerType.Client;

  public static final Method DEFAULT_METHOD = Method.GET;

  public static final String DEFAULT_URI = "";

  public static final String DEFAULT_REMOTEADDRESS = "";

  public static final String DEFAULT_USERAGENT = "";

  public static final Integer DEFAULT_INSTANCEINDEX = 0;

  public static final String DEFAULT_INSTANCEID = "";

  /**
   * / UNIX timestamp (in nanoseconds) when the request was sent (by a client) or received (by a server).
   */
  @WireField(
      tag = 1,
      adapter = "com.squareup.wire.ProtoAdapter#INT64",
      label = WireField.Label.REQUIRED
  )
  public final Long timestamp;

  /**
   * / ID for tracking lifecycle of request.
   */
  @WireField(
      tag = 2,
      adapter = "org.cloudfoundry.dropsonde.events.UUID#ADAPTER",
      label = WireField.Label.REQUIRED
  )
  public final UUID requestId;

  /**
   * / Role of the emitting process in the request cycle.
   */
  @WireField(
      tag = 3,
      adapter = "org.cloudfoundry.dropsonde.events.PeerType#ADAPTER",
      label = WireField.Label.REQUIRED
  )
  public final PeerType peerType;

  /**
   * / Method of the request.
   */
  @WireField(
      tag = 4,
      adapter = "org.cloudfoundry.dropsonde.events.Method#ADAPTER",
      label = WireField.Label.REQUIRED
  )
  public final Method method;

  /**
   * / Destination of the request.
   */
  @WireField(
      tag = 5,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.REQUIRED
  )
  public final String uri;

  /**
   * / Remote address of the request. (For a server, this should be the origin of the request.)
   */
  @WireField(
      tag = 6,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.REQUIRED
  )
  public final String remoteAddress;

  /**
   * / Contents of the UserAgent header on the request.
   */
  @WireField(
      tag = 7,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.REQUIRED
  )
  public final String userAgent;

  /**
   * / If this request was made in order to service an incoming request, this field should track the ID of the parent.
   */
  @WireField(
      tag = 8,
      adapter = "org.cloudfoundry.dropsonde.events.UUID#ADAPTER"
  )
  public final UUID parentRequestId;

  /**
   * / If this request was made in relation to an appliciation, this field should track that application's ID.
   */
  @WireField(
      tag = 9,
      adapter = "org.cloudfoundry.dropsonde.events.UUID#ADAPTER"
  )
  public final UUID applicationId;

  /**
   * / Index of the application instance.
   */
  @WireField(
      tag = 10,
      adapter = "com.squareup.wire.ProtoAdapter#INT32"
  )
  public final Integer instanceIndex;

  /**
   * / ID of the application instance.
   */
  @WireField(
      tag = 11,
      adapter = "com.squareup.wire.ProtoAdapter#STRING"
  )
  public final String instanceId;

  public HttpStart(Long timestamp, UUID requestId, PeerType peerType, Method method, String uri, String remoteAddress, String userAgent, UUID parentRequestId, UUID applicationId, Integer instanceIndex, String instanceId) {
    this(timestamp, requestId, peerType, method, uri, remoteAddress, userAgent, parentRequestId, applicationId, instanceIndex, instanceId, ByteString.EMPTY);
  }

  public HttpStart(Long timestamp, UUID requestId, PeerType peerType, Method method, String uri, String remoteAddress, String userAgent, UUID parentRequestId, UUID applicationId, Integer instanceIndex, String instanceId, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.timestamp = timestamp;
    this.requestId = requestId;
    this.peerType = peerType;
    this.method = method;
    this.uri = uri;
    this.remoteAddress = remoteAddress;
    this.userAgent = userAgent;
    this.parentRequestId = parentRequestId;
    this.applicationId = applicationId;
    this.instanceIndex = instanceIndex;
    this.instanceId = instanceId;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.timestamp = timestamp;
    builder.requestId = requestId;
    builder.peerType = peerType;
    builder.method = method;
    builder.uri = uri;
    builder.remoteAddress = remoteAddress;
    builder.userAgent = userAgent;
    builder.parentRequestId = parentRequestId;
    builder.applicationId = applicationId;
    builder.instanceIndex = instanceIndex;
    builder.instanceId = instanceId;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof HttpStart)) return false;
    HttpStart o = (HttpStart) other;
    return unknownFields().equals(o.unknownFields())
        && timestamp.equals(o.timestamp)
        && requestId.equals(o.requestId)
        && peerType.equals(o.peerType)
        && method.equals(o.method)
        && uri.equals(o.uri)
        && remoteAddress.equals(o.remoteAddress)
        && userAgent.equals(o.userAgent)
        && Internal.equals(parentRequestId, o.parentRequestId)
        && Internal.equals(applicationId, o.applicationId)
        && Internal.equals(instanceIndex, o.instanceIndex)
        && Internal.equals(instanceId, o.instanceId);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + timestamp.hashCode();
      result = result * 37 + requestId.hashCode();
      result = result * 37 + peerType.hashCode();
      result = result * 37 + method.hashCode();
      result = result * 37 + uri.hashCode();
      result = result * 37 + remoteAddress.hashCode();
      result = result * 37 + userAgent.hashCode();
      result = result * 37 + (parentRequestId != null ? parentRequestId.hashCode() : 0);
      result = result * 37 + (applicationId != null ? applicationId.hashCode() : 0);
      result = result * 37 + (instanceIndex != null ? instanceIndex.hashCode() : 0);
      result = result * 37 + (instanceId != null ? instanceId.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    builder.append(", timestamp=").append(timestamp);
    builder.append(", requestId=").append(requestId);
    builder.append(", peerType=").append(peerType);
    builder.append(", method=").append(method);
    builder.append(", uri=").append(uri);
    builder.append(", remoteAddress=").append(remoteAddress);
    builder.append(", userAgent=").append(userAgent);
    if (parentRequestId != null) builder.append(", parentRequestId=").append(parentRequestId);
    if (applicationId != null) builder.append(", applicationId=").append(applicationId);
    if (instanceIndex != null) builder.append(", instanceIndex=").append(instanceIndex);
    if (instanceId != null) builder.append(", instanceId=").append(instanceId);
    return builder.replace(0, 2, "HttpStart{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<HttpStart, Builder> {
    public Long timestamp;

    public UUID requestId;

    public PeerType peerType;

    public Method method;

    public String uri;

    public String remoteAddress;

    public String userAgent;

    public UUID parentRequestId;

    public UUID applicationId;

    public Integer instanceIndex;

    public String instanceId;

    public Builder() {
    }

    /**
     * / UNIX timestamp (in nanoseconds) when the request was sent (by a client) or received (by a server).
     */
    public Builder timestamp(Long timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    /**
     * / ID for tracking lifecycle of request.
     */
    public Builder requestId(UUID requestId) {
      this.requestId = requestId;
      return this;
    }

    /**
     * / Role of the emitting process in the request cycle.
     */
    public Builder peerType(PeerType peerType) {
      this.peerType = peerType;
      return this;
    }

    /**
     * / Method of the request.
     */
    public Builder method(Method method) {
      this.method = method;
      return this;
    }

    /**
     * / Destination of the request.
     */
    public Builder uri(String uri) {
      this.uri = uri;
      return this;
    }

    /**
     * / Remote address of the request. (For a server, this should be the origin of the request.)
     */
    public Builder remoteAddress(String remoteAddress) {
      this.remoteAddress = remoteAddress;
      return this;
    }

    /**
     * / Contents of the UserAgent header on the request.
     */
    public Builder userAgent(String userAgent) {
      this.userAgent = userAgent;
      return this;
    }

    /**
     * / If this request was made in order to service an incoming request, this field should track the ID of the parent.
     */
    public Builder parentRequestId(UUID parentRequestId) {
      this.parentRequestId = parentRequestId;
      return this;
    }

    /**
     * / If this request was made in relation to an appliciation, this field should track that application's ID.
     */
    public Builder applicationId(UUID applicationId) {
      this.applicationId = applicationId;
      return this;
    }

    /**
     * / Index of the application instance.
     */
    public Builder instanceIndex(Integer instanceIndex) {
      this.instanceIndex = instanceIndex;
      return this;
    }

    /**
     * / ID of the application instance.
     */
    public Builder instanceId(String instanceId) {
      this.instanceId = instanceId;
      return this;
    }

    @Override
    public HttpStart build() {
      if (timestamp == null
          || requestId == null
          || peerType == null
          || method == null
          || uri == null
          || remoteAddress == null
          || userAgent == null) {
        throw Internal.missingRequiredFields(timestamp, "timestamp",
            requestId, "requestId",
            peerType, "peerType",
            method, "method",
            uri, "uri",
            remoteAddress, "remoteAddress",
            userAgent, "userAgent");
      }
      return new HttpStart(timestamp, requestId, peerType, method, uri, remoteAddress, userAgent, parentRequestId, applicationId, instanceIndex, instanceId, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_HttpStart extends ProtoAdapter<HttpStart> {
    ProtoAdapter_HttpStart() {
      super(FieldEncoding.LENGTH_DELIMITED, HttpStart.class);
    }

    @Override
    public int encodedSize(HttpStart value) {
      return ProtoAdapter.INT64.encodedSizeWithTag(1, value.timestamp)
          + UUID.ADAPTER.encodedSizeWithTag(2, value.requestId)
          + PeerType.ADAPTER.encodedSizeWithTag(3, value.peerType)
          + Method.ADAPTER.encodedSizeWithTag(4, value.method)
          + ProtoAdapter.STRING.encodedSizeWithTag(5, value.uri)
          + ProtoAdapter.STRING.encodedSizeWithTag(6, value.remoteAddress)
          + ProtoAdapter.STRING.encodedSizeWithTag(7, value.userAgent)
          + (value.parentRequestId != null ? UUID.ADAPTER.encodedSizeWithTag(8, value.parentRequestId) : 0)
          + (value.applicationId != null ? UUID.ADAPTER.encodedSizeWithTag(9, value.applicationId) : 0)
          + (value.instanceIndex != null ? ProtoAdapter.INT32.encodedSizeWithTag(10, value.instanceIndex) : 0)
          + (value.instanceId != null ? ProtoAdapter.STRING.encodedSizeWithTag(11, value.instanceId) : 0)
          + value.unknownFields().size();
    }

    @Override
    public void encode(ProtoWriter writer, HttpStart value) throws IOException {
      ProtoAdapter.INT64.encodeWithTag(writer, 1, value.timestamp);
      UUID.ADAPTER.encodeWithTag(writer, 2, value.requestId);
      PeerType.ADAPTER.encodeWithTag(writer, 3, value.peerType);
      Method.ADAPTER.encodeWithTag(writer, 4, value.method);
      ProtoAdapter.STRING.encodeWithTag(writer, 5, value.uri);
      ProtoAdapter.STRING.encodeWithTag(writer, 6, value.remoteAddress);
      ProtoAdapter.STRING.encodeWithTag(writer, 7, value.userAgent);
      if (value.parentRequestId != null) UUID.ADAPTER.encodeWithTag(writer, 8, value.parentRequestId);
      if (value.applicationId != null) UUID.ADAPTER.encodeWithTag(writer, 9, value.applicationId);
      if (value.instanceIndex != null) ProtoAdapter.INT32.encodeWithTag(writer, 10, value.instanceIndex);
      if (value.instanceId != null) ProtoAdapter.STRING.encodeWithTag(writer, 11, value.instanceId);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public HttpStart decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.timestamp(ProtoAdapter.INT64.decode(reader)); break;
          case 2: builder.requestId(UUID.ADAPTER.decode(reader)); break;
          case 3: {
            try {
              builder.peerType(PeerType.ADAPTER.decode(reader));
            } catch (ProtoAdapter.EnumConstantNotFoundException e) {
              builder.addUnknownField(tag, FieldEncoding.VARINT, (long) e.value);
            }
            break;
          }
          case 4: {
            try {
              builder.method(Method.ADAPTER.decode(reader));
            } catch (ProtoAdapter.EnumConstantNotFoundException e) {
              builder.addUnknownField(tag, FieldEncoding.VARINT, (long) e.value);
            }
            break;
          }
          case 5: builder.uri(ProtoAdapter.STRING.decode(reader)); break;
          case 6: builder.remoteAddress(ProtoAdapter.STRING.decode(reader)); break;
          case 7: builder.userAgent(ProtoAdapter.STRING.decode(reader)); break;
          case 8: builder.parentRequestId(UUID.ADAPTER.decode(reader)); break;
          case 9: builder.applicationId(UUID.ADAPTER.decode(reader)); break;
          case 10: builder.instanceIndex(ProtoAdapter.INT32.decode(reader)); break;
          case 11: builder.instanceId(ProtoAdapter.STRING.decode(reader)); break;
          default: {
            FieldEncoding fieldEncoding = reader.peekFieldEncoding();
            Object value = fieldEncoding.rawProtoAdapter().decode(reader);
            builder.addUnknownField(tag, fieldEncoding, value);
          }
        }
      }
      reader.endMessage(token);
      return builder.build();
    }

    @Override
    public HttpStart redact(HttpStart value) {
      Builder builder = value.newBuilder();
      builder.requestId = UUID.ADAPTER.redact(builder.requestId);
      if (builder.parentRequestId != null) builder.parentRequestId = UUID.ADAPTER.redact(builder.parentRequestId);
      if (builder.applicationId != null) builder.applicationId = UUID.ADAPTER.redact(builder.applicationId);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
