// Code generated by Wire protocol buffer compiler, do not edit.
// Source file: http.proto at 92:1
package org.cloudfoundry.dropsonde.events;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.List;
import okio.ByteString;

/**
 * / An HttpStartStop event represents the whole lifecycle of an HTTP request.
 */
public final class HttpStartStop extends Message<HttpStartStop, HttpStartStop.Builder> {
  public static final ProtoAdapter<HttpStartStop> ADAPTER = new ProtoAdapter_HttpStartStop();

  private static final long serialVersionUID = 0L;

  public static final Long DEFAULT_STARTTIMESTAMP = 0L;

  public static final Long DEFAULT_STOPTIMESTAMP = 0L;

  public static final PeerType DEFAULT_PEERTYPE = PeerType.Client;

  public static final Method DEFAULT_METHOD = Method.GET;

  public static final String DEFAULT_URI = "";

  public static final String DEFAULT_REMOTEADDRESS = "";

  public static final String DEFAULT_USERAGENT = "";

  public static final Integer DEFAULT_STATUSCODE = 0;

  public static final Long DEFAULT_CONTENTLENGTH = 0L;

  public static final Integer DEFAULT_INSTANCEINDEX = 0;

  public static final String DEFAULT_INSTANCEID = "";

  /**
   * / UNIX timestamp (in nanoseconds) when the request was sent (by a client) or received (by a server).
   */
  @WireField(
      tag = 1,
      adapter = "com.squareup.wire.ProtoAdapter#INT64",
      label = WireField.Label.REQUIRED
  )
  public final Long startTimestamp;

  /**
   * / UNIX timestamp (in nanoseconds) when the request was received.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#INT64",
      label = WireField.Label.REQUIRED
  )
  public final Long stopTimestamp;

  /**
   * / ID for tracking lifecycle of request. Should match requestId of a HttpStart event.
   */
  @WireField(
      tag = 3,
      adapter = "org.cloudfoundry.dropsonde.events.UUID#ADAPTER",
      label = WireField.Label.REQUIRED
  )
  public final UUID requestId;

  /**
   * / Role of the emitting process in the request cycle.
   */
  @WireField(
      tag = 4,
      adapter = "org.cloudfoundry.dropsonde.events.PeerType#ADAPTER",
      label = WireField.Label.REQUIRED
  )
  public final PeerType peerType;

  /**
   * / Method of the request.
   */
  @WireField(
      tag = 5,
      adapter = "org.cloudfoundry.dropsonde.events.Method#ADAPTER",
      label = WireField.Label.REQUIRED
  )
  public final Method method;

  /**
   * / Destination of the request.
   */
  @WireField(
      tag = 6,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.REQUIRED
  )
  public final String uri;

  /**
   * / Remote address of the request. (For a server, this should be the origin of the request.)
   */
  @WireField(
      tag = 7,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.REQUIRED
  )
  public final String remoteAddress;

  /**
   * / Contents of the UserAgent header on the request.
   */
  @WireField(
      tag = 8,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.REQUIRED
  )
  public final String userAgent;

  /**
   * / Status code returned with the response to the request.
   */
  @WireField(
      tag = 9,
      adapter = "com.squareup.wire.ProtoAdapter#INT32",
      label = WireField.Label.REQUIRED
  )
  public final Integer statusCode;

  /**
   * / Length of response (bytes).
   */
  @WireField(
      tag = 10,
      adapter = "com.squareup.wire.ProtoAdapter#INT64",
      label = WireField.Label.REQUIRED
  )
  public final Long contentLength;

  /**
   * / 11 used to be ParentRequestID which has been deprecated.
   * / If this request was made in relation to an appliciation, this field should track that application's ID.
   */
  @WireField(
      tag = 12,
      adapter = "org.cloudfoundry.dropsonde.events.UUID#ADAPTER"
  )
  public final UUID applicationId;

  /**
   * / Index of the application instance.
   */
  @WireField(
      tag = 13,
      adapter = "com.squareup.wire.ProtoAdapter#INT32"
  )
  public final Integer instanceIndex;

  /**
   * / ID of the application instance.
   */
  @WireField(
      tag = 14,
      adapter = "com.squareup.wire.ProtoAdapter#STRING"
  )
  public final String instanceId;

  /**
   * / This contains http forwarded-for [x-forwarded-for] header from the request.
   */
  @WireField(
      tag = 15,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.REPEATED
  )
  public final List<String> forwarded;

  public HttpStartStop(Long startTimestamp, Long stopTimestamp, UUID requestId, PeerType peerType, Method method, String uri, String remoteAddress, String userAgent, Integer statusCode, Long contentLength, UUID applicationId, Integer instanceIndex, String instanceId, List<String> forwarded) {
    this(startTimestamp, stopTimestamp, requestId, peerType, method, uri, remoteAddress, userAgent, statusCode, contentLength, applicationId, instanceIndex, instanceId, forwarded, ByteString.EMPTY);
  }

  public HttpStartStop(Long startTimestamp, Long stopTimestamp, UUID requestId, PeerType peerType, Method method, String uri, String remoteAddress, String userAgent, Integer statusCode, Long contentLength, UUID applicationId, Integer instanceIndex, String instanceId, List<String> forwarded, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.startTimestamp = startTimestamp;
    this.stopTimestamp = stopTimestamp;
    this.requestId = requestId;
    this.peerType = peerType;
    this.method = method;
    this.uri = uri;
    this.remoteAddress = remoteAddress;
    this.userAgent = userAgent;
    this.statusCode = statusCode;
    this.contentLength = contentLength;
    this.applicationId = applicationId;
    this.instanceIndex = instanceIndex;
    this.instanceId = instanceId;
    this.forwarded = Internal.immutableCopyOf("forwarded", forwarded);
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.startTimestamp = startTimestamp;
    builder.stopTimestamp = stopTimestamp;
    builder.requestId = requestId;
    builder.peerType = peerType;
    builder.method = method;
    builder.uri = uri;
    builder.remoteAddress = remoteAddress;
    builder.userAgent = userAgent;
    builder.statusCode = statusCode;
    builder.contentLength = contentLength;
    builder.applicationId = applicationId;
    builder.instanceIndex = instanceIndex;
    builder.instanceId = instanceId;
    builder.forwarded = Internal.copyOf("forwarded", forwarded);
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof HttpStartStop)) return false;
    HttpStartStop o = (HttpStartStop) other;
    return unknownFields().equals(o.unknownFields())
        && startTimestamp.equals(o.startTimestamp)
        && stopTimestamp.equals(o.stopTimestamp)
        && requestId.equals(o.requestId)
        && peerType.equals(o.peerType)
        && method.equals(o.method)
        && uri.equals(o.uri)
        && remoteAddress.equals(o.remoteAddress)
        && userAgent.equals(o.userAgent)
        && statusCode.equals(o.statusCode)
        && contentLength.equals(o.contentLength)
        && Internal.equals(applicationId, o.applicationId)
        && Internal.equals(instanceIndex, o.instanceIndex)
        && Internal.equals(instanceId, o.instanceId)
        && forwarded.equals(o.forwarded);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + startTimestamp.hashCode();
      result = result * 37 + stopTimestamp.hashCode();
      result = result * 37 + requestId.hashCode();
      result = result * 37 + peerType.hashCode();
      result = result * 37 + method.hashCode();
      result = result * 37 + uri.hashCode();
      result = result * 37 + remoteAddress.hashCode();
      result = result * 37 + userAgent.hashCode();
      result = result * 37 + statusCode.hashCode();
      result = result * 37 + contentLength.hashCode();
      result = result * 37 + (applicationId != null ? applicationId.hashCode() : 0);
      result = result * 37 + (instanceIndex != null ? instanceIndex.hashCode() : 0);
      result = result * 37 + (instanceId != null ? instanceId.hashCode() : 0);
      result = result * 37 + forwarded.hashCode();
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    builder.append(", startTimestamp=").append(startTimestamp);
    builder.append(", stopTimestamp=").append(stopTimestamp);
    builder.append(", requestId=").append(requestId);
    builder.append(", peerType=").append(peerType);
    builder.append(", method=").append(method);
    builder.append(", uri=").append(uri);
    builder.append(", remoteAddress=").append(remoteAddress);
    builder.append(", userAgent=").append(userAgent);
    builder.append(", statusCode=").append(statusCode);
    builder.append(", contentLength=").append(contentLength);
    if (applicationId != null) builder.append(", applicationId=").append(applicationId);
    if (instanceIndex != null) builder.append(", instanceIndex=").append(instanceIndex);
    if (instanceId != null) builder.append(", instanceId=").append(instanceId);
    if (!forwarded.isEmpty()) builder.append(", forwarded=").append(forwarded);
    return builder.replace(0, 2, "HttpStartStop{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<HttpStartStop, Builder> {
    public Long startTimestamp;

    public Long stopTimestamp;

    public UUID requestId;

    public PeerType peerType;

    public Method method;

    public String uri;

    public String remoteAddress;

    public String userAgent;

    public Integer statusCode;

    public Long contentLength;

    public UUID applicationId;

    public Integer instanceIndex;

    public String instanceId;

    public List<String> forwarded;

    public Builder() {
      forwarded = Internal.newMutableList();
    }

    /**
     * / UNIX timestamp (in nanoseconds) when the request was sent (by a client) or received (by a server).
     */
    public Builder startTimestamp(Long startTimestamp) {
      this.startTimestamp = startTimestamp;
      return this;
    }

    /**
     * / UNIX timestamp (in nanoseconds) when the request was received.
     */
    public Builder stopTimestamp(Long stopTimestamp) {
      this.stopTimestamp = stopTimestamp;
      return this;
    }

    /**
     * / ID for tracking lifecycle of request. Should match requestId of a HttpStart event.
     */
    public Builder requestId(UUID requestId) {
      this.requestId = requestId;
      return this;
    }

    /**
     * / Role of the emitting process in the request cycle.
     */
    public Builder peerType(PeerType peerType) {
      this.peerType = peerType;
      return this;
    }

    /**
     * / Method of the request.
     */
    public Builder method(Method method) {
      this.method = method;
      return this;
    }

    /**
     * / Destination of the request.
     */
    public Builder uri(String uri) {
      this.uri = uri;
      return this;
    }

    /**
     * / Remote address of the request. (For a server, this should be the origin of the request.)
     */
    public Builder remoteAddress(String remoteAddress) {
      this.remoteAddress = remoteAddress;
      return this;
    }

    /**
     * / Contents of the UserAgent header on the request.
     */
    public Builder userAgent(String userAgent) {
      this.userAgent = userAgent;
      return this;
    }

    /**
     * / Status code returned with the response to the request.
     */
    public Builder statusCode(Integer statusCode) {
      this.statusCode = statusCode;
      return this;
    }

    /**
     * / Length of response (bytes).
     */
    public Builder contentLength(Long contentLength) {
      this.contentLength = contentLength;
      return this;
    }

    /**
     * / 11 used to be ParentRequestID which has been deprecated.
     * / If this request was made in relation to an appliciation, this field should track that application's ID.
     */
    public Builder applicationId(UUID applicationId) {
      this.applicationId = applicationId;
      return this;
    }

    /**
     * / Index of the application instance.
     */
    public Builder instanceIndex(Integer instanceIndex) {
      this.instanceIndex = instanceIndex;
      return this;
    }

    /**
     * / ID of the application instance.
     */
    public Builder instanceId(String instanceId) {
      this.instanceId = instanceId;
      return this;
    }

    /**
     * / This contains http forwarded-for [x-forwarded-for] header from the request.
     */
    public Builder forwarded(List<String> forwarded) {
      Internal.checkElementsNotNull(forwarded);
      this.forwarded = forwarded;
      return this;
    }

    @Override
    public HttpStartStop build() {
      if (startTimestamp == null
          || stopTimestamp == null
          || requestId == null
          || peerType == null
          || method == null
          || uri == null
          || remoteAddress == null
          || userAgent == null
          || statusCode == null
          || contentLength == null) {
        throw Internal.missingRequiredFields(startTimestamp, "startTimestamp",
            stopTimestamp, "stopTimestamp",
            requestId, "requestId",
            peerType, "peerType",
            method, "method",
            uri, "uri",
            remoteAddress, "remoteAddress",
            userAgent, "userAgent",
            statusCode, "statusCode",
            contentLength, "contentLength");
      }
      return new HttpStartStop(startTimestamp, stopTimestamp, requestId, peerType, method, uri, remoteAddress, userAgent, statusCode, contentLength, applicationId, instanceIndex, instanceId, forwarded, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_HttpStartStop extends ProtoAdapter<HttpStartStop> {
    ProtoAdapter_HttpStartStop() {
      super(FieldEncoding.LENGTH_DELIMITED, HttpStartStop.class);
    }

    @Override
    public int encodedSize(HttpStartStop value) {
      return ProtoAdapter.INT64.encodedSizeWithTag(1, value.startTimestamp)
          + ProtoAdapter.INT64.encodedSizeWithTag(2, value.stopTimestamp)
          + UUID.ADAPTER.encodedSizeWithTag(3, value.requestId)
          + PeerType.ADAPTER.encodedSizeWithTag(4, value.peerType)
          + Method.ADAPTER.encodedSizeWithTag(5, value.method)
          + ProtoAdapter.STRING.encodedSizeWithTag(6, value.uri)
          + ProtoAdapter.STRING.encodedSizeWithTag(7, value.remoteAddress)
          + ProtoAdapter.STRING.encodedSizeWithTag(8, value.userAgent)
          + ProtoAdapter.INT32.encodedSizeWithTag(9, value.statusCode)
          + ProtoAdapter.INT64.encodedSizeWithTag(10, value.contentLength)
          + (value.applicationId != null ? UUID.ADAPTER.encodedSizeWithTag(12, value.applicationId) : 0)
          + (value.instanceIndex != null ? ProtoAdapter.INT32.encodedSizeWithTag(13, value.instanceIndex) : 0)
          + (value.instanceId != null ? ProtoAdapter.STRING.encodedSizeWithTag(14, value.instanceId) : 0)
          + ProtoAdapter.STRING.asRepeated().encodedSizeWithTag(15, value.forwarded)
          + value.unknownFields().size();
    }

    @Override
    public void encode(ProtoWriter writer, HttpStartStop value) throws IOException {
      ProtoAdapter.INT64.encodeWithTag(writer, 1, value.startTimestamp);
      ProtoAdapter.INT64.encodeWithTag(writer, 2, value.stopTimestamp);
      UUID.ADAPTER.encodeWithTag(writer, 3, value.requestId);
      PeerType.ADAPTER.encodeWithTag(writer, 4, value.peerType);
      Method.ADAPTER.encodeWithTag(writer, 5, value.method);
      ProtoAdapter.STRING.encodeWithTag(writer, 6, value.uri);
      ProtoAdapter.STRING.encodeWithTag(writer, 7, value.remoteAddress);
      ProtoAdapter.STRING.encodeWithTag(writer, 8, value.userAgent);
      ProtoAdapter.INT32.encodeWithTag(writer, 9, value.statusCode);
      ProtoAdapter.INT64.encodeWithTag(writer, 10, value.contentLength);
      if (value.applicationId != null) UUID.ADAPTER.encodeWithTag(writer, 12, value.applicationId);
      if (value.instanceIndex != null) ProtoAdapter.INT32.encodeWithTag(writer, 13, value.instanceIndex);
      if (value.instanceId != null) ProtoAdapter.STRING.encodeWithTag(writer, 14, value.instanceId);
      ProtoAdapter.STRING.asRepeated().encodeWithTag(writer, 15, value.forwarded);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public HttpStartStop decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.startTimestamp(ProtoAdapter.INT64.decode(reader)); break;
          case 2: builder.stopTimestamp(ProtoAdapter.INT64.decode(reader)); break;
          case 3: builder.requestId(UUID.ADAPTER.decode(reader)); break;
          case 4: {
            try {
              builder.peerType(PeerType.ADAPTER.decode(reader));
            } catch (ProtoAdapter.EnumConstantNotFoundException e) {
              builder.addUnknownField(tag, FieldEncoding.VARINT, (long) e.value);
            }
            break;
          }
          case 5: {
            try {
              builder.method(Method.ADAPTER.decode(reader));
            } catch (ProtoAdapter.EnumConstantNotFoundException e) {
              builder.addUnknownField(tag, FieldEncoding.VARINT, (long) e.value);
            }
            break;
          }
          case 6: builder.uri(ProtoAdapter.STRING.decode(reader)); break;
          case 7: builder.remoteAddress(ProtoAdapter.STRING.decode(reader)); break;
          case 8: builder.userAgent(ProtoAdapter.STRING.decode(reader)); break;
          case 9: builder.statusCode(ProtoAdapter.INT32.decode(reader)); break;
          case 10: builder.contentLength(ProtoAdapter.INT64.decode(reader)); break;
          case 12: builder.applicationId(UUID.ADAPTER.decode(reader)); break;
          case 13: builder.instanceIndex(ProtoAdapter.INT32.decode(reader)); break;
          case 14: builder.instanceId(ProtoAdapter.STRING.decode(reader)); break;
          case 15: builder.forwarded.add(ProtoAdapter.STRING.decode(reader)); break;
          default: {
            FieldEncoding fieldEncoding = reader.peekFieldEncoding();
            Object value = fieldEncoding.rawProtoAdapter().decode(reader);
            builder.addUnknownField(tag, fieldEncoding, value);
          }
        }
      }
      reader.endMessage(token);
      return builder.build();
    }

    @Override
    public HttpStartStop redact(HttpStartStop value) {
      Builder builder = value.newBuilder();
      builder.requestId = UUID.ADAPTER.redact(builder.requestId);
      if (builder.applicationId != null) builder.applicationId = UUID.ADAPTER.redact(builder.applicationId);
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
