package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * Immutable implementation of {@link _BatchCreateClientsRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code BatchCreateClientsRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_BatchCreateClientsRequest"})
public final class BatchCreateClientsRequest extends org.cloudfoundry.uaa.clients._BatchCreateClientsRequest {
  private final @Nullable List<CreateClient> clients;
  private final @Nullable String identityZoneId;

  private BatchCreateClientsRequest(BatchCreateClientsRequest.Builder builder) {
    this.clients = builder.clients == null ? null : createUnmodifiableList(true, builder.clients);
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * A list of clients to create
   */
  @JsonProperty("clients")
  @JsonIgnore
  @Override
  public @Nullable List<CreateClient> getClients() {
    return clients;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code BatchCreateClientsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BatchCreateClientsRequest
        && equalTo((BatchCreateClientsRequest) another);
  }

  private boolean equalTo(BatchCreateClientsRequest another) {
    return Objects.equals(clients, another.clients)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code clients}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(clients);
    h = h * 17 + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code BatchCreateClientsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BatchCreateClientsRequest{"
        + "clients=" + clients
        + ", identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.clients._BatchCreateClientsRequest {
    List<CreateClient> clients = null;
    String identityZoneId;
    @JsonProperty("clients")
    @JsonIgnore
    public void setClients(@Nullable List<CreateClient> clients) {
      this.clients = clients;
    }
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @Override
    public List<CreateClient> getClients() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static BatchCreateClientsRequest fromJson(Json json) {
    BatchCreateClientsRequest.Builder builder = BatchCreateClientsRequest.builder();
    if (json.clients != null) {
      builder.addAllClients(json.clients);
    }
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    return builder.build();
  }

  private static BatchCreateClientsRequest validate(BatchCreateClientsRequest instance) {
    instance.checkClients();
    return instance;
  }

  /**
   * Creates a builder for {@link BatchCreateClientsRequest BatchCreateClientsRequest}.
   * @return A new BatchCreateClientsRequest builder
   */
  public static BatchCreateClientsRequest.Builder builder() {
    return new BatchCreateClientsRequest.Builder();
  }

  /**
   * Builds instances of type {@link BatchCreateClientsRequest BatchCreateClientsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<CreateClient> clients = null;
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code BatchCreateClientsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BatchCreateClientsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _BatchCreateClientsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_BatchCreateClientsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.clients._BatchCreateClientsRequest) {
        org.cloudfoundry.uaa.clients._BatchCreateClientsRequest instance = (org.cloudfoundry.uaa.clients._BatchCreateClientsRequest) object;
        List<CreateClient> clientsValue = instance.getClients();
        if (clientsValue != null) {
          addAllClients(clientsValue);
        }
      }
    }

    /**
     * Adds one element to {@link _BatchCreateClientsRequest#getClients() clients} list.
     * @param element A clients element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder client(CreateClient element) {
      if (this.clients == null) {
        this.clients = new ArrayList<CreateClient>();
      }
      this.clients.add(Objects.requireNonNull(element, "clients element"));
      return this;
    }

    /**
     * Adds elements to {@link _BatchCreateClientsRequest#getClients() clients} list.
     * @param elements An array of clients elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder client(CreateClient... elements) {
      if (this.clients == null) {
        this.clients = new ArrayList<CreateClient>();
      }
      for (CreateClient element : elements) {
        this.clients.add(Objects.requireNonNull(element, "clients element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _BatchCreateClientsRequest#getClients() clients} list.
     * @param elements An iterable of clients elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clients(@Nullable Iterable<? extends CreateClient> elements) {
      if (elements == null) {
        this.clients = null;
        return this;
      }
      this.clients = new ArrayList<CreateClient>();
      return addAllClients(elements);
    }

    /**
     * Adds elements to {@link _BatchCreateClientsRequest#getClients() clients} list.
     * @param elements An iterable of clients elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllClients(Iterable<? extends CreateClient> elements) {
      Objects.requireNonNull(elements, "clients element");
      if (this.clients == null) {
        this.clients = new ArrayList<CreateClient>();
      }
      for (CreateClient element : elements) {
        this.clients.add(Objects.requireNonNull(element, "clients element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _BatchCreateClientsRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link BatchCreateClientsRequest BatchCreateClientsRequest}.
     * @return An immutable instance of BatchCreateClientsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BatchCreateClientsRequest build() {
      return BatchCreateClientsRequest.validate(new BatchCreateClientsRequest(this));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
