package org.cloudfoundry.uaa.groups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * Immutable implementation of {@link _GetGroupRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GetGroupRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_GetGroupRequest"})
public final class GetGroupRequest extends org.cloudfoundry.uaa.groups._GetGroupRequest {
  private final String groupId;
  private final @Nullable String identityZoneId;

  private GetGroupRequest(GetGroupRequest.Builder builder) {
    this.groupId = builder.groupId;
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * The group id
   */
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code GetGroupRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetGroupRequest
        && equalTo((GetGroupRequest) another);
  }

  private boolean equalTo(GetGroupRequest another) {
    return groupId.equals(another.groupId)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code groupId}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + groupId.hashCode();
    h = h * 17 + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code GetGroupRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetGroupRequest{"
        + "groupId=" + groupId
        + ", identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Creates a builder for {@link GetGroupRequest GetGroupRequest}.
   * @return A new GetGroupRequest builder
   */
  public static GetGroupRequest.Builder builder() {
    return new GetGroupRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetGroupRequest GetGroupRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_GROUP_ID = 0x1L;
    private long initBits = 0x1L;

    private String groupId;
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetGroupRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetGroupRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.groups._GetGroupRequest) {
        org.cloudfoundry.uaa.groups._GetGroupRequest instance = (org.cloudfoundry.uaa.groups._GetGroupRequest) object;
        groupId(instance.getGroupId());
      }
    }

    /**
     * Initializes the value for the {@link _GetGroupRequest#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetGroupRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link GetGroupRequest GetGroupRequest}.
     * @return An immutable instance of GetGroupRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetGroupRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetGroupRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      return "Cannot build GetGroupRequest, some of required attributes are not set " + attributes;
    }
  }
}
