package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _LdapConfiguration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code LdapConfiguration.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_LdapConfiguration"})
public final class LdapConfiguration extends org.cloudfoundry.uaa.identityproviders._LdapConfiguration {
  private final @Nullable Boolean addShadowUserOnLogin;
  private final @Nullable Boolean autoAddGroups;
  private final String baseUrl;
  private final @Nullable String bindPassword;
  private final @Nullable String bindUserDistinguishedName;
  private final @Nullable String groupRoleAttribute;
  private final @Nullable String groupSearchBase;
  private final @Nullable Integer groupSearchDepthLimit;
  private final @Nullable String groupSearchFilter;
  private final @Nullable Boolean groupSearchSubTree;
  private final @Nullable Boolean groupsIgnorePartialResults;
  private final LdapGroupFile ldapGroupFile;
  private final LdapProfileFile ldapProfileFile;
  private final @Nullable Boolean localPasswordCompare;
  private final @Nullable String mailAttributeName;
  private final @Nullable String mailSubstitute;
  private final @Nullable Boolean mailSubstituteOverridesLdap;
  private final @Nullable String passwordAttributeName;
  private final @Nullable String passwordEncoder;
  private final @Nullable String referral;
  private final @Nullable Boolean skipSSLVerification;
  private final @Nullable TlsConfiguration tlsConfiguration;
  private final @Nullable String userDistinguishedNamePattern;
  private final @Nullable String userDistinguishedNamePatternDelimiter;
  private final @Nullable String userSearchBase;
  private final @Nullable String userSearchFilter;
  private final @Nullable AttributeMappings attributeMappings;
  private final @Nullable List<String> externalGroupsWhitelist;
  private final @Nullable List<String> emailDomains;
  private final @Nullable String providerDescription;

  private LdapConfiguration(LdapConfiguration.Builder builder) {
    this.addShadowUserOnLogin = builder.addShadowUserOnLogin;
    this.autoAddGroups = builder.autoAddGroups;
    this.baseUrl = builder.baseUrl;
    this.bindPassword = builder.bindPassword;
    this.bindUserDistinguishedName = builder.bindUserDistinguishedName;
    this.groupRoleAttribute = builder.groupRoleAttribute;
    this.groupSearchBase = builder.groupSearchBase;
    this.groupSearchDepthLimit = builder.groupSearchDepthLimit;
    this.groupSearchFilter = builder.groupSearchFilter;
    this.groupSearchSubTree = builder.groupSearchSubTree;
    this.groupsIgnorePartialResults = builder.groupsIgnorePartialResults;
    this.ldapGroupFile = builder.ldapGroupFile;
    this.ldapProfileFile = builder.ldapProfileFile;
    this.localPasswordCompare = builder.localPasswordCompare;
    this.mailAttributeName = builder.mailAttributeName;
    this.mailSubstitute = builder.mailSubstitute;
    this.mailSubstituteOverridesLdap = builder.mailSubstituteOverridesLdap;
    this.passwordAttributeName = builder.passwordAttributeName;
    this.passwordEncoder = builder.passwordEncoder;
    this.referral = builder.referral;
    this.skipSSLVerification = builder.skipSSLVerification;
    this.tlsConfiguration = builder.tlsConfiguration;
    this.userDistinguishedNamePattern = builder.userDistinguishedNamePattern;
    this.userDistinguishedNamePatternDelimiter = builder.userDistinguishedNamePatternDelimiter;
    this.userSearchBase = builder.userSearchBase;
    this.userSearchFilter = builder.userSearchFilter;
    this.attributeMappings = builder.attributeMappings;
    this.externalGroupsWhitelist = builder.externalGroupsWhitelist == null ? null : createUnmodifiableList(true, builder.externalGroupsWhitelist);
    this.emailDomains = builder.emailDomains == null ? null : createUnmodifiableList(true, builder.emailDomains);
    this.providerDescription = builder.providerDescription;
  }

  /**
   * Determines whether or not shadow users must be created before login by an administrator.
   */
  @JsonProperty("addShadowUserOnLogin")
  @Override
  public @Nullable Boolean getAddShadowUserOnLogin() {
    return addShadowUserOnLogin;
  }

  /**
   * The auto add group flag
   */
  @JsonProperty("autoAddGroups")
  @Override
  public @Nullable Boolean getAutoAddGroups() {
    return autoAddGroups;
  }

  /**
   * The URL to the ldap server, must start with ldap:// or ldaps://
   */
  @JsonProperty("baseUrl")
  @Override
  public String getBaseUrl() {
    return baseUrl;
  }

  /**
   * If you specified BindUserDN, then specify the corresponding password to be used for binding here.
   */
  @JsonProperty("bindPassword")
  @Override
  public @Nullable String getBindPassword() {
    return bindPassword;
  }

  /**
   * The distinguished name the gatekeeper uses to bind to the LDAP server.
   */
  @JsonProperty("bindUserDn")
  @Override
  public @Nullable String getBindUserDistinguishedName() {
    return bindUserDistinguishedName;
  }

  /**
   * The group role attribute
   */
  @JsonProperty("groupRoleAttribute")
  @Override
  public @Nullable String getGroupRoleAttribute() {
    return groupRoleAttribute;
  }

  /**
   * The group search base
   */
  @JsonProperty("groupSearchBase")
  @Override
  public @Nullable String getGroupSearchBase() {
    return groupSearchBase;
  }

  /**
   * The maximum group search depth limit
   */
  @JsonProperty("maxGroupSearchDepth")
  @Override
  public @Nullable Integer getGroupSearchDepthLimit() {
    return groupSearchDepthLimit;
  }

  /**
   * The group search filter
   */
  @JsonProperty("groupSearchFilter")
  @Override
  public @Nullable String getGroupSearchFilter() {
    return groupSearchFilter;
  }

  /**
   * The group search subtree
   */
  @JsonProperty("groupSearchSubTree")
  @Override
  public @Nullable Boolean getGroupSearchSubTree() {
    return groupSearchSubTree;
  }

  /**
   * The group ignore partial search result flag
   */
  @JsonProperty("groupsIgnorePartialResults")
  @Override
  public @Nullable Boolean getGroupsIgnorePartialResults() {
    return groupsIgnorePartialResults;
  }

  /**
   * The file to be used for group integration.
   */
  @JsonProperty("ldapGroupFile")
  @Override
  public LdapGroupFile getLdapGroupFile() {
    return ldapGroupFile;
  }

  /**
   * The file to be used for configuring the LDAP authentication.
   */
  @JsonProperty("ldapProfileFile")
  @Override
  public LdapProfileFile getLdapProfileFile() {
    return ldapProfileFile;
  }

  /**
   * @return The value of the {@code localPasswordCompare} attribute
   */
  @JsonProperty("localPasswordCompare")
  @Override
  public @Nullable Boolean getLocalPasswordCompare() {
    return localPasswordCompare;
  }

  /**
   * The name of the LDAP attribute that contains the user’s email address
   */
  @JsonProperty("mailAttributeName")
  @Override
  public @Nullable String getMailAttributeName() {
    return mailAttributeName;
  }

  /**
   * Defines an email pattern containing a {0} to generate an email address for an LDAP user during authentication
   */
  @JsonProperty("mailSubstitute")
  @Override
  public @Nullable String getMailSubstitute() {
    return mailSubstitute;
  }

  /**
   * Set to true if you wish to override an LDAP user email address with a generated one
   */
  @JsonProperty("mailSubstituteOverridesLdap")
  @Override
  public @Nullable Boolean getMailSubstituteOverridesLdap() {
    return mailSubstituteOverridesLdap;
  }

  /**
   * The password attribute name
   */
  @JsonProperty("passwordAttributeName")
  @Override
  public @Nullable String getPasswordAttributeName() {
    return passwordAttributeName;
  }

  /**
   * The password encoder
   */
  @JsonProperty("passwordEncoder")
  @Override
  public @Nullable String getPasswordEncoder() {
    return passwordEncoder;
  }

  /**
   * Configures the UAA LDAP referral behavior. The following values are possible: - follow → Referrals are followed - ignore → Referrals are ignored and the partial result is returned - throw → An
   * error is thrown and the authentication is aborted
   */
  @JsonProperty("referral")
  @Override
  public @Nullable String getReferral() {
    return referral;
  }

  /**
   * Skips validation of the LDAP cert if set to true.
   */
  @JsonProperty("skipSSLVerification")
  @Override
  public @Nullable Boolean getSkipSSLVerification() {
    return skipSSLVerification;
  }

  /**
   * The StartTLS options
   */
  @JsonProperty("tlsConfiguration")
  @Override
  public @Nullable TlsConfiguration getTlsConfiguration() {
    return tlsConfiguration;
  }

  /**
   * The user distinguished name pattern
   */
  @JsonProperty("userDNPattern")
  @Override
  public @Nullable String getUserDistinguishedNamePattern() {
    return userDistinguishedNamePattern;
  }

  /**
   * The user distinguished name pattern delimiter
   */
  @JsonProperty("userDNPatternDelimiter")
  @Override
  public @Nullable String getUserDistinguishedNamePatternDelimiter() {
    return userDistinguishedNamePatternDelimiter;
  }

  /**
   * The user search base
   */
  @JsonProperty("userSearchBase")
  @Override
  public @Nullable String getUserSearchBase() {
    return userSearchBase;
  }

  /**
   * The user search filter
   */
  @JsonProperty("userSearchFilter")
  @Override
  public @Nullable String getUserSearchFilter() {
    return userSearchFilter;
  }

  /**
   * @return The value of the {@code attributeMappings} attribute
   */
  @JsonProperty("attributeMappings")
  @Override
  public @Nullable AttributeMappings getAttributeMappings() {
    return attributeMappings;
  }

  /**
   * The external group white list
   */
  @JsonProperty("externalGroupsWhitelist")
  @Override
  public @Nullable List<String> getExternalGroupsWhitelist() {
    return externalGroupsWhitelist;
  }

  /**
   * List of email domains associated with the provider for the purpose of associating users to the correct origin upon invitation. If empty list, no invitations are accepted. Wildcards supported.
   */
  @JsonProperty("emailDomain")
  @Override
  public @Nullable List<String> getEmailDomains() {
    return emailDomains;
  }

  /**
   * Human readable name/description of this provider
   */
  @JsonProperty("providerDescription")
  @Override
  public @Nullable String getProviderDescription() {
    return providerDescription;
  }

  /**
   * This instance is equal to all instances of {@code LdapConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof LdapConfiguration
        && equalTo((LdapConfiguration) another);
  }

  private boolean equalTo(LdapConfiguration another) {
    return Objects.equals(addShadowUserOnLogin, another.addShadowUserOnLogin)
        && Objects.equals(autoAddGroups, another.autoAddGroups)
        && baseUrl.equals(another.baseUrl)
        && Objects.equals(bindPassword, another.bindPassword)
        && Objects.equals(bindUserDistinguishedName, another.bindUserDistinguishedName)
        && Objects.equals(groupRoleAttribute, another.groupRoleAttribute)
        && Objects.equals(groupSearchBase, another.groupSearchBase)
        && Objects.equals(groupSearchDepthLimit, another.groupSearchDepthLimit)
        && Objects.equals(groupSearchFilter, another.groupSearchFilter)
        && Objects.equals(groupSearchSubTree, another.groupSearchSubTree)
        && Objects.equals(groupsIgnorePartialResults, another.groupsIgnorePartialResults)
        && ldapGroupFile.equals(another.ldapGroupFile)
        && ldapProfileFile.equals(another.ldapProfileFile)
        && Objects.equals(localPasswordCompare, another.localPasswordCompare)
        && Objects.equals(mailAttributeName, another.mailAttributeName)
        && Objects.equals(mailSubstitute, another.mailSubstitute)
        && Objects.equals(mailSubstituteOverridesLdap, another.mailSubstituteOverridesLdap)
        && Objects.equals(passwordAttributeName, another.passwordAttributeName)
        && Objects.equals(passwordEncoder, another.passwordEncoder)
        && Objects.equals(referral, another.referral)
        && Objects.equals(skipSSLVerification, another.skipSSLVerification)
        && Objects.equals(tlsConfiguration, another.tlsConfiguration)
        && Objects.equals(userDistinguishedNamePattern, another.userDistinguishedNamePattern)
        && Objects.equals(userDistinguishedNamePatternDelimiter, another.userDistinguishedNamePatternDelimiter)
        && Objects.equals(userSearchBase, another.userSearchBase)
        && Objects.equals(userSearchFilter, another.userSearchFilter)
        && Objects.equals(attributeMappings, another.attributeMappings)
        && Objects.equals(externalGroupsWhitelist, another.externalGroupsWhitelist)
        && Objects.equals(emailDomains, another.emailDomains)
        && Objects.equals(providerDescription, another.providerDescription);
  }

  /**
   * Computes a hash code from attributes: {@code addShadowUserOnLogin}, {@code autoAddGroups}, {@code baseUrl}, {@code bindPassword}, {@code bindUserDistinguishedName}, {@code groupRoleAttribute}, {@code groupSearchBase}, {@code groupSearchDepthLimit}, {@code groupSearchFilter}, {@code groupSearchSubTree}, {@code groupsIgnorePartialResults}, {@code ldapGroupFile}, {@code ldapProfileFile}, {@code localPasswordCompare}, {@code mailAttributeName}, {@code mailSubstitute}, {@code mailSubstituteOverridesLdap}, {@code passwordAttributeName}, {@code passwordEncoder}, {@code referral}, {@code skipSSLVerification}, {@code tlsConfiguration}, {@code userDistinguishedNamePattern}, {@code userDistinguishedNamePatternDelimiter}, {@code userSearchBase}, {@code userSearchFilter}, {@code attributeMappings}, {@code externalGroupsWhitelist}, {@code emailDomains}, {@code providerDescription}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(addShadowUserOnLogin);
    h = h * 17 + Objects.hashCode(autoAddGroups);
    h = h * 17 + baseUrl.hashCode();
    h = h * 17 + Objects.hashCode(bindPassword);
    h = h * 17 + Objects.hashCode(bindUserDistinguishedName);
    h = h * 17 + Objects.hashCode(groupRoleAttribute);
    h = h * 17 + Objects.hashCode(groupSearchBase);
    h = h * 17 + Objects.hashCode(groupSearchDepthLimit);
    h = h * 17 + Objects.hashCode(groupSearchFilter);
    h = h * 17 + Objects.hashCode(groupSearchSubTree);
    h = h * 17 + Objects.hashCode(groupsIgnorePartialResults);
    h = h * 17 + ldapGroupFile.hashCode();
    h = h * 17 + ldapProfileFile.hashCode();
    h = h * 17 + Objects.hashCode(localPasswordCompare);
    h = h * 17 + Objects.hashCode(mailAttributeName);
    h = h * 17 + Objects.hashCode(mailSubstitute);
    h = h * 17 + Objects.hashCode(mailSubstituteOverridesLdap);
    h = h * 17 + Objects.hashCode(passwordAttributeName);
    h = h * 17 + Objects.hashCode(passwordEncoder);
    h = h * 17 + Objects.hashCode(referral);
    h = h * 17 + Objects.hashCode(skipSSLVerification);
    h = h * 17 + Objects.hashCode(tlsConfiguration);
    h = h * 17 + Objects.hashCode(userDistinguishedNamePattern);
    h = h * 17 + Objects.hashCode(userDistinguishedNamePatternDelimiter);
    h = h * 17 + Objects.hashCode(userSearchBase);
    h = h * 17 + Objects.hashCode(userSearchFilter);
    h = h * 17 + Objects.hashCode(attributeMappings);
    h = h * 17 + Objects.hashCode(externalGroupsWhitelist);
    h = h * 17 + Objects.hashCode(emailDomains);
    h = h * 17 + Objects.hashCode(providerDescription);
    return h;
  }

  /**
   * Prints the immutable value {@code LdapConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LdapConfiguration{"
        + "addShadowUserOnLogin=" + addShadowUserOnLogin
        + ", autoAddGroups=" + autoAddGroups
        + ", baseUrl=" + baseUrl
        + ", bindPassword=" + bindPassword
        + ", bindUserDistinguishedName=" + bindUserDistinguishedName
        + ", groupRoleAttribute=" + groupRoleAttribute
        + ", groupSearchBase=" + groupSearchBase
        + ", groupSearchDepthLimit=" + groupSearchDepthLimit
        + ", groupSearchFilter=" + groupSearchFilter
        + ", groupSearchSubTree=" + groupSearchSubTree
        + ", groupsIgnorePartialResults=" + groupsIgnorePartialResults
        + ", ldapGroupFile=" + ldapGroupFile
        + ", ldapProfileFile=" + ldapProfileFile
        + ", localPasswordCompare=" + localPasswordCompare
        + ", mailAttributeName=" + mailAttributeName
        + ", mailSubstitute=" + mailSubstitute
        + ", mailSubstituteOverridesLdap=" + mailSubstituteOverridesLdap
        + ", passwordAttributeName=" + passwordAttributeName
        + ", passwordEncoder=" + passwordEncoder
        + ", referral=" + referral
        + ", skipSSLVerification=" + skipSSLVerification
        + ", tlsConfiguration=" + tlsConfiguration
        + ", userDistinguishedNamePattern=" + userDistinguishedNamePattern
        + ", userDistinguishedNamePatternDelimiter=" + userDistinguishedNamePatternDelimiter
        + ", userSearchBase=" + userSearchBase
        + ", userSearchFilter=" + userSearchFilter
        + ", attributeMappings=" + attributeMappings
        + ", externalGroupsWhitelist=" + externalGroupsWhitelist
        + ", emailDomains=" + emailDomains
        + ", providerDescription=" + providerDescription
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityproviders._LdapConfiguration {
    Boolean addShadowUserOnLogin;
    Boolean autoAddGroups;
    String baseUrl;
    String bindPassword;
    String bindUserDistinguishedName;
    String groupRoleAttribute;
    String groupSearchBase;
    Integer groupSearchDepthLimit;
    String groupSearchFilter;
    Boolean groupSearchSubTree;
    Boolean groupsIgnorePartialResults;
    LdapGroupFile ldapGroupFile;
    LdapProfileFile ldapProfileFile;
    Boolean localPasswordCompare;
    String mailAttributeName;
    String mailSubstitute;
    Boolean mailSubstituteOverridesLdap;
    String passwordAttributeName;
    String passwordEncoder;
    String referral;
    Boolean skipSSLVerification;
    TlsConfiguration tlsConfiguration;
    String userDistinguishedNamePattern;
    String userDistinguishedNamePatternDelimiter;
    String userSearchBase;
    String userSearchFilter;
    AttributeMappings attributeMappings;
    List<String> externalGroupsWhitelist = null;
    List<String> emailDomains = null;
    String providerDescription;
    @JsonProperty("addShadowUserOnLogin")
    public void setAddShadowUserOnLogin(@Nullable Boolean addShadowUserOnLogin) {
      this.addShadowUserOnLogin = addShadowUserOnLogin;
    }
    @JsonProperty("autoAddGroups")
    public void setAutoAddGroups(@Nullable Boolean autoAddGroups) {
      this.autoAddGroups = autoAddGroups;
    }
    @JsonProperty("baseUrl")
    public void setBaseUrl(String baseUrl) {
      this.baseUrl = baseUrl;
    }
    @JsonProperty("bindPassword")
    public void setBindPassword(@Nullable String bindPassword) {
      this.bindPassword = bindPassword;
    }
    @JsonProperty("bindUserDn")
    public void setBindUserDistinguishedName(@Nullable String bindUserDistinguishedName) {
      this.bindUserDistinguishedName = bindUserDistinguishedName;
    }
    @JsonProperty("groupRoleAttribute")
    public void setGroupRoleAttribute(@Nullable String groupRoleAttribute) {
      this.groupRoleAttribute = groupRoleAttribute;
    }
    @JsonProperty("groupSearchBase")
    public void setGroupSearchBase(@Nullable String groupSearchBase) {
      this.groupSearchBase = groupSearchBase;
    }
    @JsonProperty("maxGroupSearchDepth")
    public void setGroupSearchDepthLimit(@Nullable Integer groupSearchDepthLimit) {
      this.groupSearchDepthLimit = groupSearchDepthLimit;
    }
    @JsonProperty("groupSearchFilter")
    public void setGroupSearchFilter(@Nullable String groupSearchFilter) {
      this.groupSearchFilter = groupSearchFilter;
    }
    @JsonProperty("groupSearchSubTree")
    public void setGroupSearchSubTree(@Nullable Boolean groupSearchSubTree) {
      this.groupSearchSubTree = groupSearchSubTree;
    }
    @JsonProperty("groupsIgnorePartialResults")
    public void setGroupsIgnorePartialResults(@Nullable Boolean groupsIgnorePartialResults) {
      this.groupsIgnorePartialResults = groupsIgnorePartialResults;
    }
    @JsonProperty("ldapGroupFile")
    public void setLdapGroupFile(LdapGroupFile ldapGroupFile) {
      this.ldapGroupFile = ldapGroupFile;
    }
    @JsonProperty("ldapProfileFile")
    public void setLdapProfileFile(LdapProfileFile ldapProfileFile) {
      this.ldapProfileFile = ldapProfileFile;
    }
    @JsonProperty("localPasswordCompare")
    public void setLocalPasswordCompare(@Nullable Boolean localPasswordCompare) {
      this.localPasswordCompare = localPasswordCompare;
    }
    @JsonProperty("mailAttributeName")
    public void setMailAttributeName(@Nullable String mailAttributeName) {
      this.mailAttributeName = mailAttributeName;
    }
    @JsonProperty("mailSubstitute")
    public void setMailSubstitute(@Nullable String mailSubstitute) {
      this.mailSubstitute = mailSubstitute;
    }
    @JsonProperty("mailSubstituteOverridesLdap")
    public void setMailSubstituteOverridesLdap(@Nullable Boolean mailSubstituteOverridesLdap) {
      this.mailSubstituteOverridesLdap = mailSubstituteOverridesLdap;
    }
    @JsonProperty("passwordAttributeName")
    public void setPasswordAttributeName(@Nullable String passwordAttributeName) {
      this.passwordAttributeName = passwordAttributeName;
    }
    @JsonProperty("passwordEncoder")
    public void setPasswordEncoder(@Nullable String passwordEncoder) {
      this.passwordEncoder = passwordEncoder;
    }
    @JsonProperty("referral")
    public void setReferral(@Nullable String referral) {
      this.referral = referral;
    }
    @JsonProperty("skipSSLVerification")
    public void setSkipSSLVerification(@Nullable Boolean skipSSLVerification) {
      this.skipSSLVerification = skipSSLVerification;
    }
    @JsonProperty("tlsConfiguration")
    public void setTlsConfiguration(@Nullable TlsConfiguration tlsConfiguration) {
      this.tlsConfiguration = tlsConfiguration;
    }
    @JsonProperty("userDNPattern")
    public void setUserDistinguishedNamePattern(@Nullable String userDistinguishedNamePattern) {
      this.userDistinguishedNamePattern = userDistinguishedNamePattern;
    }
    @JsonProperty("userDNPatternDelimiter")
    public void setUserDistinguishedNamePatternDelimiter(@Nullable String userDistinguishedNamePatternDelimiter) {
      this.userDistinguishedNamePatternDelimiter = userDistinguishedNamePatternDelimiter;
    }
    @JsonProperty("userSearchBase")
    public void setUserSearchBase(@Nullable String userSearchBase) {
      this.userSearchBase = userSearchBase;
    }
    @JsonProperty("userSearchFilter")
    public void setUserSearchFilter(@Nullable String userSearchFilter) {
      this.userSearchFilter = userSearchFilter;
    }
    @JsonProperty("attributeMappings")
    public void setAttributeMappings(@Nullable AttributeMappings attributeMappings) {
      this.attributeMappings = attributeMappings;
    }
    @JsonProperty("externalGroupsWhitelist")
    public void setExternalGroupsWhitelist(@Nullable List<String> externalGroupsWhitelist) {
      this.externalGroupsWhitelist = externalGroupsWhitelist;
    }
    @JsonProperty("emailDomain")
    public void setEmailDomains(@Nullable List<String> emailDomains) {
      this.emailDomains = emailDomains;
    }
    @JsonProperty("providerDescription")
    public void setProviderDescription(@Nullable String providerDescription) {
      this.providerDescription = providerDescription;
    }
    @Override
    public Boolean getAddShadowUserOnLogin() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getAutoAddGroups() { throw new UnsupportedOperationException(); }
    @Override
    public String getBaseUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getBindPassword() { throw new UnsupportedOperationException(); }
    @Override
    public String getBindUserDistinguishedName() { throw new UnsupportedOperationException(); }
    @Override
    public String getGroupRoleAttribute() { throw new UnsupportedOperationException(); }
    @Override
    public String getGroupSearchBase() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getGroupSearchDepthLimit() { throw new UnsupportedOperationException(); }
    @Override
    public String getGroupSearchFilter() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getGroupSearchSubTree() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getGroupsIgnorePartialResults() { throw new UnsupportedOperationException(); }
    @Override
    public LdapGroupFile getLdapGroupFile() { throw new UnsupportedOperationException(); }
    @Override
    public LdapProfileFile getLdapProfileFile() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getLocalPasswordCompare() { throw new UnsupportedOperationException(); }
    @Override
    public String getMailAttributeName() { throw new UnsupportedOperationException(); }
    @Override
    public String getMailSubstitute() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getMailSubstituteOverridesLdap() { throw new UnsupportedOperationException(); }
    @Override
    public String getPasswordAttributeName() { throw new UnsupportedOperationException(); }
    @Override
    public String getPasswordEncoder() { throw new UnsupportedOperationException(); }
    @Override
    public String getReferral() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getSkipSSLVerification() { throw new UnsupportedOperationException(); }
    @Override
    public TlsConfiguration getTlsConfiguration() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserDistinguishedNamePattern() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserDistinguishedNamePatternDelimiter() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserSearchBase() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserSearchFilter() { throw new UnsupportedOperationException(); }
    @Override
    public AttributeMappings getAttributeMappings() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getExternalGroupsWhitelist() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getEmailDomains() { throw new UnsupportedOperationException(); }
    @Override
    public String getProviderDescription() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static LdapConfiguration fromJson(Json json) {
    LdapConfiguration.Builder builder = LdapConfiguration.builder();
    if (json.addShadowUserOnLogin != null) {
      builder.addShadowUserOnLogin(json.addShadowUserOnLogin);
    }
    if (json.autoAddGroups != null) {
      builder.autoAddGroups(json.autoAddGroups);
    }
    if (json.baseUrl != null) {
      builder.baseUrl(json.baseUrl);
    }
    if (json.bindPassword != null) {
      builder.bindPassword(json.bindPassword);
    }
    if (json.bindUserDistinguishedName != null) {
      builder.bindUserDistinguishedName(json.bindUserDistinguishedName);
    }
    if (json.groupRoleAttribute != null) {
      builder.groupRoleAttribute(json.groupRoleAttribute);
    }
    if (json.groupSearchBase != null) {
      builder.groupSearchBase(json.groupSearchBase);
    }
    if (json.groupSearchDepthLimit != null) {
      builder.groupSearchDepthLimit(json.groupSearchDepthLimit);
    }
    if (json.groupSearchFilter != null) {
      builder.groupSearchFilter(json.groupSearchFilter);
    }
    if (json.groupSearchSubTree != null) {
      builder.groupSearchSubTree(json.groupSearchSubTree);
    }
    if (json.groupsIgnorePartialResults != null) {
      builder.groupsIgnorePartialResults(json.groupsIgnorePartialResults);
    }
    if (json.ldapGroupFile != null) {
      builder.ldapGroupFile(json.ldapGroupFile);
    }
    if (json.ldapProfileFile != null) {
      builder.ldapProfileFile(json.ldapProfileFile);
    }
    if (json.localPasswordCompare != null) {
      builder.localPasswordCompare(json.localPasswordCompare);
    }
    if (json.mailAttributeName != null) {
      builder.mailAttributeName(json.mailAttributeName);
    }
    if (json.mailSubstitute != null) {
      builder.mailSubstitute(json.mailSubstitute);
    }
    if (json.mailSubstituteOverridesLdap != null) {
      builder.mailSubstituteOverridesLdap(json.mailSubstituteOverridesLdap);
    }
    if (json.passwordAttributeName != null) {
      builder.passwordAttributeName(json.passwordAttributeName);
    }
    if (json.passwordEncoder != null) {
      builder.passwordEncoder(json.passwordEncoder);
    }
    if (json.referral != null) {
      builder.referral(json.referral);
    }
    if (json.skipSSLVerification != null) {
      builder.skipSSLVerification(json.skipSSLVerification);
    }
    if (json.tlsConfiguration != null) {
      builder.tlsConfiguration(json.tlsConfiguration);
    }
    if (json.userDistinguishedNamePattern != null) {
      builder.userDistinguishedNamePattern(json.userDistinguishedNamePattern);
    }
    if (json.userDistinguishedNamePatternDelimiter != null) {
      builder.userDistinguishedNamePatternDelimiter(json.userDistinguishedNamePatternDelimiter);
    }
    if (json.userSearchBase != null) {
      builder.userSearchBase(json.userSearchBase);
    }
    if (json.userSearchFilter != null) {
      builder.userSearchFilter(json.userSearchFilter);
    }
    if (json.attributeMappings != null) {
      builder.attributeMappings(json.attributeMappings);
    }
    if (json.externalGroupsWhitelist != null) {
      builder.addAllExternalGroupsWhitelist(json.externalGroupsWhitelist);
    }
    if (json.emailDomains != null) {
      builder.addAllEmailDomains(json.emailDomains);
    }
    if (json.providerDescription != null) {
      builder.providerDescription(json.providerDescription);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link LdapConfiguration LdapConfiguration}.
   * @return A new LdapConfiguration builder
   */
  public static LdapConfiguration.Builder builder() {
    return new LdapConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link LdapConfiguration LdapConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_BASE_URL = 0x1L;
    private static final long INIT_BIT_LDAP_GROUP_FILE = 0x2L;
    private static final long INIT_BIT_LDAP_PROFILE_FILE = 0x4L;
    private long initBits = 0x7L;

    private Boolean addShadowUserOnLogin;
    private Boolean autoAddGroups;
    private String baseUrl;
    private String bindPassword;
    private String bindUserDistinguishedName;
    private String groupRoleAttribute;
    private String groupSearchBase;
    private Integer groupSearchDepthLimit;
    private String groupSearchFilter;
    private Boolean groupSearchSubTree;
    private Boolean groupsIgnorePartialResults;
    private LdapGroupFile ldapGroupFile;
    private LdapProfileFile ldapProfileFile;
    private Boolean localPasswordCompare;
    private String mailAttributeName;
    private String mailSubstitute;
    private Boolean mailSubstituteOverridesLdap;
    private String passwordAttributeName;
    private String passwordEncoder;
    private String referral;
    private Boolean skipSSLVerification;
    private TlsConfiguration tlsConfiguration;
    private String userDistinguishedNamePattern;
    private String userDistinguishedNamePatternDelimiter;
    private String userSearchBase;
    private String userSearchFilter;
    private AttributeMappings attributeMappings;
    private List<String> externalGroupsWhitelist = null;
    private List<String> emailDomains = null;
    private String providerDescription;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractIdentityProviderConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractIdentityProviderConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.identityproviders.AbstractExternalIdentityProviderConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractExternalIdentityProviderConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code LdapConfiguration} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(LdapConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _LdapConfiguration} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_LdapConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractIdentityProviderConfiguration) {
        AbstractIdentityProviderConfiguration instance = (AbstractIdentityProviderConfiguration) object;
        List<String> emailDomainsValue = instance.getEmailDomains();
        if (emailDomainsValue != null) {
          addAllEmailDomains(emailDomainsValue);
        }
        String providerDescriptionValue = instance.getProviderDescription();
        if (providerDescriptionValue != null) {
          providerDescription(providerDescriptionValue);
        }
      }
      if (object instanceof AbstractExternalIdentityProviderConfiguration) {
        AbstractExternalIdentityProviderConfiguration instance = (AbstractExternalIdentityProviderConfiguration) object;
        List<String> externalGroupsWhitelistValue = instance.getExternalGroupsWhitelist();
        if (externalGroupsWhitelistValue != null) {
          addAllExternalGroupsWhitelist(externalGroupsWhitelistValue);
        }
        AttributeMappings attributeMappingsValue = instance.getAttributeMappings();
        if (attributeMappingsValue != null) {
          attributeMappings(attributeMappingsValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.identityproviders._LdapConfiguration) {
        org.cloudfoundry.uaa.identityproviders._LdapConfiguration instance = (org.cloudfoundry.uaa.identityproviders._LdapConfiguration) object;
        String bindPasswordValue = instance.getBindPassword();
        if (bindPasswordValue != null) {
          bindPassword(bindPasswordValue);
        }
        Boolean mailSubstituteOverridesLdapValue = instance.getMailSubstituteOverridesLdap();
        if (mailSubstituteOverridesLdapValue != null) {
          mailSubstituteOverridesLdap(mailSubstituteOverridesLdapValue);
        }
        Boolean skipSSLVerificationValue = instance.getSkipSSLVerification();
        if (skipSSLVerificationValue != null) {
          skipSSLVerification(skipSSLVerificationValue);
        }
        ldapGroupFile(instance.getLdapGroupFile());
        Boolean autoAddGroupsValue = instance.getAutoAddGroups();
        if (autoAddGroupsValue != null) {
          autoAddGroups(autoAddGroupsValue);
        }
        ldapProfileFile(instance.getLdapProfileFile());
        String userSearchBaseValue = instance.getUserSearchBase();
        if (userSearchBaseValue != null) {
          userSearchBase(userSearchBaseValue);
        }
        String groupRoleAttributeValue = instance.getGroupRoleAttribute();
        if (groupRoleAttributeValue != null) {
          groupRoleAttribute(groupRoleAttributeValue);
        }
        String userSearchFilterValue = instance.getUserSearchFilter();
        if (userSearchFilterValue != null) {
          userSearchFilter(userSearchFilterValue);
        }
        String groupSearchFilterValue = instance.getGroupSearchFilter();
        if (groupSearchFilterValue != null) {
          groupSearchFilter(groupSearchFilterValue);
        }
        Integer groupSearchDepthLimitValue = instance.getGroupSearchDepthLimit();
        if (groupSearchDepthLimitValue != null) {
          groupSearchDepthLimit(groupSearchDepthLimitValue);
        }
        String mailSubstituteValue = instance.getMailSubstitute();
        if (mailSubstituteValue != null) {
          mailSubstitute(mailSubstituteValue);
        }
        String bindUserDistinguishedNameValue = instance.getBindUserDistinguishedName();
        if (bindUserDistinguishedNameValue != null) {
          bindUserDistinguishedName(bindUserDistinguishedNameValue);
        }
        TlsConfiguration tlsConfigurationValue = instance.getTlsConfiguration();
        if (tlsConfigurationValue != null) {
          tlsConfiguration(tlsConfigurationValue);
        }
        Boolean groupsIgnorePartialResultsValue = instance.getGroupsIgnorePartialResults();
        if (groupsIgnorePartialResultsValue != null) {
          groupsIgnorePartialResults(groupsIgnorePartialResultsValue);
        }
        String userDistinguishedNamePatternValue = instance.getUserDistinguishedNamePattern();
        if (userDistinguishedNamePatternValue != null) {
          userDistinguishedNamePattern(userDistinguishedNamePatternValue);
        }
        Boolean groupSearchSubTreeValue = instance.getGroupSearchSubTree();
        if (groupSearchSubTreeValue != null) {
          groupSearchSubTree(groupSearchSubTreeValue);
        }
        Boolean addShadowUserOnLoginValue = instance.getAddShadowUserOnLogin();
        if (addShadowUserOnLoginValue != null) {
          addShadowUserOnLogin(addShadowUserOnLoginValue);
        }
        Boolean localPasswordCompareValue = instance.getLocalPasswordCompare();
        if (localPasswordCompareValue != null) {
          localPasswordCompare(localPasswordCompareValue);
        }
        String userDistinguishedNamePatternDelimiterValue = instance.getUserDistinguishedNamePatternDelimiter();
        if (userDistinguishedNamePatternDelimiterValue != null) {
          userDistinguishedNamePatternDelimiter(userDistinguishedNamePatternDelimiterValue);
        }
        String passwordEncoderValue = instance.getPasswordEncoder();
        if (passwordEncoderValue != null) {
          passwordEncoder(passwordEncoderValue);
        }
        baseUrl(instance.getBaseUrl());
        String groupSearchBaseValue = instance.getGroupSearchBase();
        if (groupSearchBaseValue != null) {
          groupSearchBase(groupSearchBaseValue);
        }
        String referralValue = instance.getReferral();
        if (referralValue != null) {
          referral(referralValue);
        }
        String mailAttributeNameValue = instance.getMailAttributeName();
        if (mailAttributeNameValue != null) {
          mailAttributeName(mailAttributeNameValue);
        }
        String passwordAttributeNameValue = instance.getPasswordAttributeName();
        if (passwordAttributeNameValue != null) {
          passwordAttributeName(passwordAttributeNameValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getAddShadowUserOnLogin() addShadowUserOnLogin} attribute.
     * @param addShadowUserOnLogin The value for addShadowUserOnLogin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addShadowUserOnLogin(@Nullable Boolean addShadowUserOnLogin) {
      this.addShadowUserOnLogin = addShadowUserOnLogin;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getAutoAddGroups() autoAddGroups} attribute.
     * @param autoAddGroups The value for autoAddGroups (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder autoAddGroups(@Nullable Boolean autoAddGroups) {
      this.autoAddGroups = autoAddGroups;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getBaseUrl() baseUrl} attribute.
     * @param baseUrl The value for baseUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder baseUrl(String baseUrl) {
      this.baseUrl = Objects.requireNonNull(baseUrl, "baseUrl");
      initBits &= ~INIT_BIT_BASE_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getBindPassword() bindPassword} attribute.
     * @param bindPassword The value for bindPassword (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bindPassword(@Nullable String bindPassword) {
      this.bindPassword = bindPassword;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getBindUserDistinguishedName() bindUserDistinguishedName} attribute.
     * @param bindUserDistinguishedName The value for bindUserDistinguishedName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder bindUserDistinguishedName(@Nullable String bindUserDistinguishedName) {
      this.bindUserDistinguishedName = bindUserDistinguishedName;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getGroupRoleAttribute() groupRoleAttribute} attribute.
     * @param groupRoleAttribute The value for groupRoleAttribute (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupRoleAttribute(@Nullable String groupRoleAttribute) {
      this.groupRoleAttribute = groupRoleAttribute;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getGroupSearchBase() groupSearchBase} attribute.
     * @param groupSearchBase The value for groupSearchBase (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupSearchBase(@Nullable String groupSearchBase) {
      this.groupSearchBase = groupSearchBase;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getGroupSearchDepthLimit() groupSearchDepthLimit} attribute.
     * @param groupSearchDepthLimit The value for groupSearchDepthLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupSearchDepthLimit(@Nullable Integer groupSearchDepthLimit) {
      this.groupSearchDepthLimit = groupSearchDepthLimit;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getGroupSearchFilter() groupSearchFilter} attribute.
     * @param groupSearchFilter The value for groupSearchFilter (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupSearchFilter(@Nullable String groupSearchFilter) {
      this.groupSearchFilter = groupSearchFilter;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getGroupSearchSubTree() groupSearchSubTree} attribute.
     * @param groupSearchSubTree The value for groupSearchSubTree (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupSearchSubTree(@Nullable Boolean groupSearchSubTree) {
      this.groupSearchSubTree = groupSearchSubTree;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getGroupsIgnorePartialResults() groupsIgnorePartialResults} attribute.
     * @param groupsIgnorePartialResults The value for groupsIgnorePartialResults (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupsIgnorePartialResults(@Nullable Boolean groupsIgnorePartialResults) {
      this.groupsIgnorePartialResults = groupsIgnorePartialResults;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getLdapGroupFile() ldapGroupFile} attribute.
     * @param ldapGroupFile The value for ldapGroupFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ldapGroupFile(LdapGroupFile ldapGroupFile) {
      this.ldapGroupFile = Objects.requireNonNull(ldapGroupFile, "ldapGroupFile");
      initBits &= ~INIT_BIT_LDAP_GROUP_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getLdapProfileFile() ldapProfileFile} attribute.
     * @param ldapProfileFile The value for ldapProfileFile 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ldapProfileFile(LdapProfileFile ldapProfileFile) {
      this.ldapProfileFile = Objects.requireNonNull(ldapProfileFile, "ldapProfileFile");
      initBits &= ~INIT_BIT_LDAP_PROFILE_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getLocalPasswordCompare() localPasswordCompare} attribute.
     * @param localPasswordCompare The value for localPasswordCompare (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder localPasswordCompare(@Nullable Boolean localPasswordCompare) {
      this.localPasswordCompare = localPasswordCompare;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getMailAttributeName() mailAttributeName} attribute.
     * @param mailAttributeName The value for mailAttributeName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mailAttributeName(@Nullable String mailAttributeName) {
      this.mailAttributeName = mailAttributeName;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getMailSubstitute() mailSubstitute} attribute.
     * @param mailSubstitute The value for mailSubstitute (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mailSubstitute(@Nullable String mailSubstitute) {
      this.mailSubstitute = mailSubstitute;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getMailSubstituteOverridesLdap() mailSubstituteOverridesLdap} attribute.
     * @param mailSubstituteOverridesLdap The value for mailSubstituteOverridesLdap (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mailSubstituteOverridesLdap(@Nullable Boolean mailSubstituteOverridesLdap) {
      this.mailSubstituteOverridesLdap = mailSubstituteOverridesLdap;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getPasswordAttributeName() passwordAttributeName} attribute.
     * @param passwordAttributeName The value for passwordAttributeName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder passwordAttributeName(@Nullable String passwordAttributeName) {
      this.passwordAttributeName = passwordAttributeName;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getPasswordEncoder() passwordEncoder} attribute.
     * @param passwordEncoder The value for passwordEncoder (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder passwordEncoder(@Nullable String passwordEncoder) {
      this.passwordEncoder = passwordEncoder;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getReferral() referral} attribute.
     * @param referral The value for referral (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder referral(@Nullable String referral) {
      this.referral = referral;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getSkipSSLVerification() skipSSLVerification} attribute.
     * @param skipSSLVerification The value for skipSSLVerification (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder skipSSLVerification(@Nullable Boolean skipSSLVerification) {
      this.skipSSLVerification = skipSSLVerification;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getTlsConfiguration() tlsConfiguration} attribute.
     * @param tlsConfiguration The value for tlsConfiguration (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder tlsConfiguration(@Nullable TlsConfiguration tlsConfiguration) {
      this.tlsConfiguration = tlsConfiguration;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getUserDistinguishedNamePattern() userDistinguishedNamePattern} attribute.
     * @param userDistinguishedNamePattern The value for userDistinguishedNamePattern (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userDistinguishedNamePattern(@Nullable String userDistinguishedNamePattern) {
      this.userDistinguishedNamePattern = userDistinguishedNamePattern;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getUserDistinguishedNamePatternDelimiter() userDistinguishedNamePatternDelimiter} attribute.
     * @param userDistinguishedNamePatternDelimiter The value for userDistinguishedNamePatternDelimiter (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userDistinguishedNamePatternDelimiter(@Nullable String userDistinguishedNamePatternDelimiter) {
      this.userDistinguishedNamePatternDelimiter = userDistinguishedNamePatternDelimiter;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getUserSearchBase() userSearchBase} attribute.
     * @param userSearchBase The value for userSearchBase (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userSearchBase(@Nullable String userSearchBase) {
      this.userSearchBase = userSearchBase;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getUserSearchFilter() userSearchFilter} attribute.
     * @param userSearchFilter The value for userSearchFilter (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userSearchFilter(@Nullable String userSearchFilter) {
      this.userSearchFilter = userSearchFilter;
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getAttributeMappings() attributeMappings} attribute.
     * @param attributeMappings The value for attributeMappings (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder attributeMappings(@Nullable AttributeMappings attributeMappings) {
      this.attributeMappings = attributeMappings;
      return this;
    }

    /**
     * Adds one element to {@link _LdapConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param element A externalGroupsWhitelist element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroupsWhitelist(String element) {
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      return this;
    }

    /**
     * Adds elements to {@link _LdapConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An array of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroupsWhitelist(String... elements) {
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      for (String element : elements) {
        this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _LdapConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An iterable of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroupsWhitelist(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.externalGroupsWhitelist = null;
        return this;
      }
      this.externalGroupsWhitelist = new ArrayList<String>();
      return addAllExternalGroupsWhitelist(elements);
    }

    /**
     * Adds elements to {@link _LdapConfiguration#getExternalGroupsWhitelist() externalGroupsWhitelist} list.
     * @param elements An iterable of externalGroupsWhitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllExternalGroupsWhitelist(Iterable<String> elements) {
      Objects.requireNonNull(elements, "externalGroupsWhitelist element");
      if (this.externalGroupsWhitelist == null) {
        this.externalGroupsWhitelist = new ArrayList<String>();
      }
      for (String element : elements) {
        this.externalGroupsWhitelist.add(Objects.requireNonNull(element, "externalGroupsWhitelist element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _LdapConfiguration#getEmailDomains() emailDomains} list.
     * @param element A emailDomains element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emailDomain(String element) {
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      return this;
    }

    /**
     * Adds elements to {@link _LdapConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An array of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emailDomain(String... elements) {
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _LdapConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An iterable of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emailDomains(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.emailDomains = null;
        return this;
      }
      this.emailDomains = new ArrayList<String>();
      return addAllEmailDomains(elements);
    }

    /**
     * Adds elements to {@link _LdapConfiguration#getEmailDomains() emailDomains} list.
     * @param elements An iterable of emailDomains elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmailDomains(Iterable<String> elements) {
      Objects.requireNonNull(elements, "emailDomains element");
      if (this.emailDomains == null) {
        this.emailDomains = new ArrayList<String>();
      }
      for (String element : elements) {
        this.emailDomains.add(Objects.requireNonNull(element, "emailDomains element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _LdapConfiguration#getProviderDescription() providerDescription} attribute.
     * @param providerDescription The value for providerDescription (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder providerDescription(@Nullable String providerDescription) {
      this.providerDescription = providerDescription;
      return this;
    }

    /**
     * Builds a new {@link LdapConfiguration LdapConfiguration}.
     * @return An immutable instance of LdapConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public LdapConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new LdapConfiguration(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_BASE_URL) != 0) attributes.add("baseUrl");
      if ((initBits & INIT_BIT_LDAP_GROUP_FILE) != 0) attributes.add("ldapGroupFile");
      if ((initBits & INIT_BIT_LDAP_PROFILE_FILE) != 0) attributes.add("ldapProfileFile");
      return "Cannot build LdapConfiguration, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
