package org.cloudfoundry.uaa.identityproviders;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _PasswordPolicy}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code PasswordPolicy.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_PasswordPolicy"})
public final class PasswordPolicy extends org.cloudfoundry.uaa.identityproviders._PasswordPolicy {
  private final Integer maximumLength;
  private final Integer minimumDigit;
  private final Integer minimumLength;
  private final Integer minimumLowerCaseCharacter;
  private final Integer minimumSpecialCharacter;
  private final Integer minimumUpperCaseCharacter;
  private final Integer passwordExpirationInMonth;

  private PasswordPolicy(PasswordPolicy.Builder builder) {
    this.maximumLength = builder.maximumLength;
    this.minimumDigit = builder.minimumDigit;
    this.minimumLength = builder.minimumLength;
    this.minimumLowerCaseCharacter = builder.minimumLowerCaseCharacter;
    this.minimumSpecialCharacter = builder.minimumSpecialCharacter;
    this.minimumUpperCaseCharacter = builder.minimumUpperCaseCharacter;
    this.passwordExpirationInMonth = builder.passwordExpirationInMonth;
  }

  /**
   * Maximum number of characters required for password to be considered valid (defaults to 255).
   */
  @JsonProperty("maxLength")
  @Override
  public Integer getMaximumLength() {
    return maximumLength;
  }

  /**
   * Minimum number of digits required for password to be considered valid (defaults to 0).
   */
  @JsonProperty("requireDigit")
  @Override
  public Integer getMinimumDigit() {
    return minimumDigit;
  }

  /**
   * Minimum number of characters required for password to be considered valid (defaults to 0).
   */
  @JsonProperty("minLength")
  @Override
  public Integer getMinimumLength() {
    return minimumLength;
  }

  /**
   * Minimum number of lower characters required for password to be considered valid (defaults to 0).
   */
  @JsonProperty("requireLowerCaseCharacter")
  @Override
  public Integer getMinimumLowerCaseCharacter() {
    return minimumLowerCaseCharacter;
  }

  /**
   * Minimum number of special characters required for password to be considered valid (defaults to 0).
   */
  @JsonProperty("requireSpecialCharacter")
  @Override
  public Integer getMinimumSpecialCharacter() {
    return minimumSpecialCharacter;
  }

  /**
   * Minimum number of uppercase characters required for password to be considered valid (defaults to 0).
   */
  @JsonProperty("requireUpperCaseCharacter")
  @Override
  public Integer getMinimumUpperCaseCharacter() {
    return minimumUpperCaseCharacter;
  }

  /**
   * Number of months after which current password expires (defaults to 0).
   */
  @JsonProperty("expirePasswordInMonths")
  @Override
  public Integer getPasswordExpirationInMonth() {
    return passwordExpirationInMonth;
  }

  /**
   * This instance is equal to all instances of {@code PasswordPolicy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof PasswordPolicy
        && equalTo((PasswordPolicy) another);
  }

  private boolean equalTo(PasswordPolicy another) {
    return maximumLength.equals(another.maximumLength)
        && minimumDigit.equals(another.minimumDigit)
        && minimumLength.equals(another.minimumLength)
        && minimumLowerCaseCharacter.equals(another.minimumLowerCaseCharacter)
        && minimumSpecialCharacter.equals(another.minimumSpecialCharacter)
        && minimumUpperCaseCharacter.equals(another.minimumUpperCaseCharacter)
        && passwordExpirationInMonth.equals(another.passwordExpirationInMonth);
  }

  /**
   * Computes a hash code from attributes: {@code maximumLength}, {@code minimumDigit}, {@code minimumLength}, {@code minimumLowerCaseCharacter}, {@code minimumSpecialCharacter}, {@code minimumUpperCaseCharacter}, {@code passwordExpirationInMonth}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + maximumLength.hashCode();
    h = h * 17 + minimumDigit.hashCode();
    h = h * 17 + minimumLength.hashCode();
    h = h * 17 + minimumLowerCaseCharacter.hashCode();
    h = h * 17 + minimumSpecialCharacter.hashCode();
    h = h * 17 + minimumUpperCaseCharacter.hashCode();
    h = h * 17 + passwordExpirationInMonth.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PasswordPolicy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PasswordPolicy{"
        + "maximumLength=" + maximumLength
        + ", minimumDigit=" + minimumDigit
        + ", minimumLength=" + minimumLength
        + ", minimumLowerCaseCharacter=" + minimumLowerCaseCharacter
        + ", minimumSpecialCharacter=" + minimumSpecialCharacter
        + ", minimumUpperCaseCharacter=" + minimumUpperCaseCharacter
        + ", passwordExpirationInMonth=" + passwordExpirationInMonth
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityproviders._PasswordPolicy {
    Integer maximumLength;
    Integer minimumDigit;
    Integer minimumLength;
    Integer minimumLowerCaseCharacter;
    Integer minimumSpecialCharacter;
    Integer minimumUpperCaseCharacter;
    Integer passwordExpirationInMonth;
    @JsonProperty("maxLength")
    public void setMaximumLength(Integer maximumLength) {
      this.maximumLength = maximumLength;
    }
    @JsonProperty("requireDigit")
    public void setMinimumDigit(Integer minimumDigit) {
      this.minimumDigit = minimumDigit;
    }
    @JsonProperty("minLength")
    public void setMinimumLength(Integer minimumLength) {
      this.minimumLength = minimumLength;
    }
    @JsonProperty("requireLowerCaseCharacter")
    public void setMinimumLowerCaseCharacter(Integer minimumLowerCaseCharacter) {
      this.minimumLowerCaseCharacter = minimumLowerCaseCharacter;
    }
    @JsonProperty("requireSpecialCharacter")
    public void setMinimumSpecialCharacter(Integer minimumSpecialCharacter) {
      this.minimumSpecialCharacter = minimumSpecialCharacter;
    }
    @JsonProperty("requireUpperCaseCharacter")
    public void setMinimumUpperCaseCharacter(Integer minimumUpperCaseCharacter) {
      this.minimumUpperCaseCharacter = minimumUpperCaseCharacter;
    }
    @JsonProperty("expirePasswordInMonths")
    public void setPasswordExpirationInMonth(Integer passwordExpirationInMonth) {
      this.passwordExpirationInMonth = passwordExpirationInMonth;
    }
    @Override
    public Integer getMaximumLength() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMinimumDigit() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMinimumLength() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMinimumLowerCaseCharacter() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMinimumSpecialCharacter() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMinimumUpperCaseCharacter() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPasswordExpirationInMonth() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static PasswordPolicy fromJson(Json json) {
    PasswordPolicy.Builder builder = PasswordPolicy.builder();
    if (json.maximumLength != null) {
      builder.maximumLength(json.maximumLength);
    }
    if (json.minimumDigit != null) {
      builder.minimumDigit(json.minimumDigit);
    }
    if (json.minimumLength != null) {
      builder.minimumLength(json.minimumLength);
    }
    if (json.minimumLowerCaseCharacter != null) {
      builder.minimumLowerCaseCharacter(json.minimumLowerCaseCharacter);
    }
    if (json.minimumSpecialCharacter != null) {
      builder.minimumSpecialCharacter(json.minimumSpecialCharacter);
    }
    if (json.minimumUpperCaseCharacter != null) {
      builder.minimumUpperCaseCharacter(json.minimumUpperCaseCharacter);
    }
    if (json.passwordExpirationInMonth != null) {
      builder.passwordExpirationInMonth(json.passwordExpirationInMonth);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link PasswordPolicy PasswordPolicy}.
   * @return A new PasswordPolicy builder
   */
  public static PasswordPolicy.Builder builder() {
    return new PasswordPolicy.Builder();
  }

  /**
   * Builds instances of type {@link PasswordPolicy PasswordPolicy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_MAXIMUM_LENGTH = 0x1L;
    private static final long INIT_BIT_MINIMUM_DIGIT = 0x2L;
    private static final long INIT_BIT_MINIMUM_LENGTH = 0x4L;
    private static final long INIT_BIT_MINIMUM_LOWER_CASE_CHARACTER = 0x8L;
    private static final long INIT_BIT_MINIMUM_SPECIAL_CHARACTER = 0x10L;
    private static final long INIT_BIT_MINIMUM_UPPER_CASE_CHARACTER = 0x20L;
    private static final long INIT_BIT_PASSWORD_EXPIRATION_IN_MONTH = 0x40L;
    private long initBits = 0x7fL;

    private Integer maximumLength;
    private Integer minimumDigit;
    private Integer minimumLength;
    private Integer minimumLowerCaseCharacter;
    private Integer minimumSpecialCharacter;
    private Integer minimumUpperCaseCharacter;
    private Integer passwordExpirationInMonth;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PasswordPolicy} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PasswordPolicy instance) {
      return from((_PasswordPolicy) instance);
    }

    /**
     * Copy abstract value type {@code _PasswordPolicy} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_PasswordPolicy instance) {
      Objects.requireNonNull(instance, "instance");
      maximumLength(instance.getMaximumLength());
      minimumDigit(instance.getMinimumDigit());
      minimumLength(instance.getMinimumLength());
      minimumLowerCaseCharacter(instance.getMinimumLowerCaseCharacter());
      minimumSpecialCharacter(instance.getMinimumSpecialCharacter());
      minimumUpperCaseCharacter(instance.getMinimumUpperCaseCharacter());
      passwordExpirationInMonth(instance.getPasswordExpirationInMonth());
      return this;
    }

    /**
     * Initializes the value for the {@link _PasswordPolicy#getMaximumLength() maximumLength} attribute.
     * @param maximumLength The value for maximumLength 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder maximumLength(Integer maximumLength) {
      this.maximumLength = Objects.requireNonNull(maximumLength, "maximumLength");
      initBits &= ~INIT_BIT_MAXIMUM_LENGTH;
      return this;
    }

    /**
     * Initializes the value for the {@link _PasswordPolicy#getMinimumDigit() minimumDigit} attribute.
     * @param minimumDigit The value for minimumDigit 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder minimumDigit(Integer minimumDigit) {
      this.minimumDigit = Objects.requireNonNull(minimumDigit, "minimumDigit");
      initBits &= ~INIT_BIT_MINIMUM_DIGIT;
      return this;
    }

    /**
     * Initializes the value for the {@link _PasswordPolicy#getMinimumLength() minimumLength} attribute.
     * @param minimumLength The value for minimumLength 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder minimumLength(Integer minimumLength) {
      this.minimumLength = Objects.requireNonNull(minimumLength, "minimumLength");
      initBits &= ~INIT_BIT_MINIMUM_LENGTH;
      return this;
    }

    /**
     * Initializes the value for the {@link _PasswordPolicy#getMinimumLowerCaseCharacter() minimumLowerCaseCharacter} attribute.
     * @param minimumLowerCaseCharacter The value for minimumLowerCaseCharacter 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder minimumLowerCaseCharacter(Integer minimumLowerCaseCharacter) {
      this.minimumLowerCaseCharacter = Objects.requireNonNull(minimumLowerCaseCharacter, "minimumLowerCaseCharacter");
      initBits &= ~INIT_BIT_MINIMUM_LOWER_CASE_CHARACTER;
      return this;
    }

    /**
     * Initializes the value for the {@link _PasswordPolicy#getMinimumSpecialCharacter() minimumSpecialCharacter} attribute.
     * @param minimumSpecialCharacter The value for minimumSpecialCharacter 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder minimumSpecialCharacter(Integer minimumSpecialCharacter) {
      this.minimumSpecialCharacter = Objects.requireNonNull(minimumSpecialCharacter, "minimumSpecialCharacter");
      initBits &= ~INIT_BIT_MINIMUM_SPECIAL_CHARACTER;
      return this;
    }

    /**
     * Initializes the value for the {@link _PasswordPolicy#getMinimumUpperCaseCharacter() minimumUpperCaseCharacter} attribute.
     * @param minimumUpperCaseCharacter The value for minimumUpperCaseCharacter 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder minimumUpperCaseCharacter(Integer minimumUpperCaseCharacter) {
      this.minimumUpperCaseCharacter = Objects.requireNonNull(minimumUpperCaseCharacter, "minimumUpperCaseCharacter");
      initBits &= ~INIT_BIT_MINIMUM_UPPER_CASE_CHARACTER;
      return this;
    }

    /**
     * Initializes the value for the {@link _PasswordPolicy#getPasswordExpirationInMonth() passwordExpirationInMonth} attribute.
     * @param passwordExpirationInMonth The value for passwordExpirationInMonth 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder passwordExpirationInMonth(Integer passwordExpirationInMonth) {
      this.passwordExpirationInMonth = Objects.requireNonNull(passwordExpirationInMonth, "passwordExpirationInMonth");
      initBits &= ~INIT_BIT_PASSWORD_EXPIRATION_IN_MONTH;
      return this;
    }

    /**
     * Builds a new {@link PasswordPolicy PasswordPolicy}.
     * @return An immutable instance of PasswordPolicy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public PasswordPolicy build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new PasswordPolicy(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_MAXIMUM_LENGTH) != 0) attributes.add("maximumLength");
      if ((initBits & INIT_BIT_MINIMUM_DIGIT) != 0) attributes.add("minimumDigit");
      if ((initBits & INIT_BIT_MINIMUM_LENGTH) != 0) attributes.add("minimumLength");
      if ((initBits & INIT_BIT_MINIMUM_LOWER_CASE_CHARACTER) != 0) attributes.add("minimumLowerCaseCharacter");
      if ((initBits & INIT_BIT_MINIMUM_SPECIAL_CHARACTER) != 0) attributes.add("minimumSpecialCharacter");
      if ((initBits & INIT_BIT_MINIMUM_UPPER_CASE_CHARACTER) != 0) attributes.add("minimumUpperCaseCharacter");
      if ((initBits & INIT_BIT_PASSWORD_EXPIRATION_IN_MONTH) != 0) attributes.add("passwordExpirationInMonth");
      return "Cannot build PasswordPolicy, some of required attributes are not set " + attributes;
    }
  }
}
