package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _LogoutLink}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code LogoutLink.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_LogoutLink"})
public final class LogoutLink extends org.cloudfoundry.uaa.identityzones._LogoutLink {
  private final @Nullable Boolean disableRedirectParameter;
  private final @Nullable String redirectParameterName;
  private final @Nullable String redirectUrl;
  private final @Nullable List<String> whitelist;

  private LogoutLink(LogoutLink.Builder builder) {
    this.disableRedirectParameter = builder.disableRedirectParameter;
    this.redirectParameterName = builder.redirectParameterName;
    this.redirectUrl = builder.redirectUrl;
    this.whitelist = builder.whitelist == null ? null : createUnmodifiableList(true, builder.whitelist);
  }

  /**
   * Whether or not to allow the redirect parameter on logout.
   */
  @JsonProperty("disableRedirectParameter")
  @Override
  public @Nullable Boolean getDisableRedirectParameter() {
    return disableRedirectParameter;
  }

  /**
   * Changes the name of the redirect parameter.
   */
  @JsonProperty("redirectParameterName")
  @Override
  public @Nullable String getRedirectParameterName() {
    return redirectParameterName;
  }

  /**
   * Logout redirect url.
   */
  @JsonProperty("redirectUrl")
  @Override
  public @Nullable String getRedirectUrl() {
    return redirectUrl;
  }

  /**
   * List of allowed whitelist redirects.
   */
  @JsonProperty("whitelist")
  @Override
  public @Nullable List<String> getWhitelist() {
    return whitelist;
  }

  /**
   * This instance is equal to all instances of {@code LogoutLink} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof LogoutLink
        && equalTo((LogoutLink) another);
  }

  private boolean equalTo(LogoutLink another) {
    return Objects.equals(disableRedirectParameter, another.disableRedirectParameter)
        && Objects.equals(redirectParameterName, another.redirectParameterName)
        && Objects.equals(redirectUrl, another.redirectUrl)
        && Objects.equals(whitelist, another.whitelist);
  }

  /**
   * Computes a hash code from attributes: {@code disableRedirectParameter}, {@code redirectParameterName}, {@code redirectUrl}, {@code whitelist}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(disableRedirectParameter);
    h = h * 17 + Objects.hashCode(redirectParameterName);
    h = h * 17 + Objects.hashCode(redirectUrl);
    h = h * 17 + Objects.hashCode(whitelist);
    return h;
  }

  /**
   * Prints the immutable value {@code LogoutLink} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LogoutLink{"
        + "disableRedirectParameter=" + disableRedirectParameter
        + ", redirectParameterName=" + redirectParameterName
        + ", redirectUrl=" + redirectUrl
        + ", whitelist=" + whitelist
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._LogoutLink {
    Boolean disableRedirectParameter;
    String redirectParameterName;
    String redirectUrl;
    List<String> whitelist = null;
    @JsonProperty("disableRedirectParameter")
    public void setDisableRedirectParameter(@Nullable Boolean disableRedirectParameter) {
      this.disableRedirectParameter = disableRedirectParameter;
    }
    @JsonProperty("redirectParameterName")
    public void setRedirectParameterName(@Nullable String redirectParameterName) {
      this.redirectParameterName = redirectParameterName;
    }
    @JsonProperty("redirectUrl")
    public void setRedirectUrl(@Nullable String redirectUrl) {
      this.redirectUrl = redirectUrl;
    }
    @JsonProperty("whitelist")
    public void setWhitelist(@Nullable List<String> whitelist) {
      this.whitelist = whitelist;
    }
    @Override
    public Boolean getDisableRedirectParameter() { throw new UnsupportedOperationException(); }
    @Override
    public String getRedirectParameterName() { throw new UnsupportedOperationException(); }
    @Override
    public String getRedirectUrl() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getWhitelist() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static LogoutLink fromJson(Json json) {
    LogoutLink.Builder builder = LogoutLink.builder();
    if (json.disableRedirectParameter != null) {
      builder.disableRedirectParameter(json.disableRedirectParameter);
    }
    if (json.redirectParameterName != null) {
      builder.redirectParameterName(json.redirectParameterName);
    }
    if (json.redirectUrl != null) {
      builder.redirectUrl(json.redirectUrl);
    }
    if (json.whitelist != null) {
      builder.addAllWhitelist(json.whitelist);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link LogoutLink LogoutLink}.
   * @return A new LogoutLink builder
   */
  public static LogoutLink.Builder builder() {
    return new LogoutLink.Builder();
  }

  /**
   * Builds instances of type {@link LogoutLink LogoutLink}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Boolean disableRedirectParameter;
    private String redirectParameterName;
    private String redirectUrl;
    private List<String> whitelist = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LogoutLink} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(LogoutLink instance) {
      return from((_LogoutLink) instance);
    }

    /**
     * Copy abstract value type {@code _LogoutLink} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_LogoutLink instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean disableRedirectParameterValue = instance.getDisableRedirectParameter();
      if (disableRedirectParameterValue != null) {
        disableRedirectParameter(disableRedirectParameterValue);
      }
      String redirectParameterNameValue = instance.getRedirectParameterName();
      if (redirectParameterNameValue != null) {
        redirectParameterName(redirectParameterNameValue);
      }
      String redirectUrlValue = instance.getRedirectUrl();
      if (redirectUrlValue != null) {
        redirectUrl(redirectUrlValue);
      }
      List<String> whitelistValue = instance.getWhitelist();
      if (whitelistValue != null) {
        addAllWhitelist(whitelistValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _LogoutLink#getDisableRedirectParameter() disableRedirectParameter} attribute.
     * @param disableRedirectParameter The value for disableRedirectParameter (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder disableRedirectParameter(@Nullable Boolean disableRedirectParameter) {
      this.disableRedirectParameter = disableRedirectParameter;
      return this;
    }

    /**
     * Initializes the value for the {@link _LogoutLink#getRedirectParameterName() redirectParameterName} attribute.
     * @param redirectParameterName The value for redirectParameterName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder redirectParameterName(@Nullable String redirectParameterName) {
      this.redirectParameterName = redirectParameterName;
      return this;
    }

    /**
     * Initializes the value for the {@link _LogoutLink#getRedirectUrl() redirectUrl} attribute.
     * @param redirectUrl The value for redirectUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder redirectUrl(@Nullable String redirectUrl) {
      this.redirectUrl = redirectUrl;
      return this;
    }

    /**
     * Adds one element to {@link _LogoutLink#getWhitelist() whitelist} list.
     * @param element A whitelist element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder whitelist(String element) {
      if (this.whitelist == null) {
        this.whitelist = new ArrayList<String>();
      }
      this.whitelist.add(Objects.requireNonNull(element, "whitelist element"));
      return this;
    }

    /**
     * Adds elements to {@link _LogoutLink#getWhitelist() whitelist} list.
     * @param elements An array of whitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder whitelist(String... elements) {
      if (this.whitelist == null) {
        this.whitelist = new ArrayList<String>();
      }
      for (String element : elements) {
        this.whitelist.add(Objects.requireNonNull(element, "whitelist element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _LogoutLink#getWhitelist() whitelist} list.
     * @param elements An iterable of whitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder whitelist(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.whitelist = null;
        return this;
      }
      this.whitelist = new ArrayList<String>();
      return addAllWhitelist(elements);
    }

    /**
     * Adds elements to {@link _LogoutLink#getWhitelist() whitelist} list.
     * @param elements An iterable of whitelist elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllWhitelist(Iterable<String> elements) {
      Objects.requireNonNull(elements, "whitelist element");
      if (this.whitelist == null) {
        this.whitelist = new ArrayList<String>();
      }
      for (String element : elements) {
        this.whitelist.add(Objects.requireNonNull(element, "whitelist element"));
      }
      return this;
    }

    /**
     * Builds a new {@link LogoutLink LogoutLink}.
     * @return An immutable instance of LogoutLink
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public LogoutLink build() {
      return new LogoutLink(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
