package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _Invite}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Invite.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_Invite"})
public final class Invite extends org.cloudfoundry.uaa.users._Invite {
  private final String email;
  private final @Nullable String errorCode;
  private final @Nullable String errorMessage;
  private final @Nullable String inviteLink;
  private final @Nullable String origin;
  private final Boolean success;
  private final @Nullable String userId;

  private Invite(Invite.Builder builder) {
    this.email = builder.email;
    this.errorCode = builder.errorCode;
    this.errorMessage = builder.errorMessage;
    this.inviteLink = builder.inviteLink;
    this.origin = builder.origin;
    this.success = builder.success;
    this.userId = builder.userId;
  }

  /**
   * The email address
   */
  @JsonProperty("email")
  @Override
  public String getEmail() {
    return email;
  }

  /**
   * The error code
   */
  @JsonProperty("errorCode")
  @Override
  public @Nullable String getErrorCode() {
    return errorCode;
  }

  /**
   * The error message
   */
  @JsonProperty("errorMessage")
  @Override
  public @Nullable String getErrorMessage() {
    return errorMessage;
  }

  /**
   * The invite link
   */
  @JsonProperty("inviteLink")
  @Override
  public @Nullable String getInviteLink() {
    return inviteLink;
  }

  /**
   * The origin
   */
  @JsonProperty("origin")
  @Override
  public @Nullable String getOrigin() {
    return origin;
  }

  /**
   * Whether the invite was sent successfully
   */
  @JsonProperty("success")
  @Override
  public Boolean getSuccess() {
    return success;
  }

  /**
   * The user id
   */
  @JsonProperty("userId")
  @Override
  public @Nullable String getUserId() {
    return userId;
  }

  /**
   * This instance is equal to all instances of {@code Invite} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Invite
        && equalTo((Invite) another);
  }

  private boolean equalTo(Invite another) {
    return email.equals(another.email)
        && Objects.equals(errorCode, another.errorCode)
        && Objects.equals(errorMessage, another.errorMessage)
        && Objects.equals(inviteLink, another.inviteLink)
        && Objects.equals(origin, another.origin)
        && success.equals(another.success)
        && Objects.equals(userId, another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code email}, {@code errorCode}, {@code errorMessage}, {@code inviteLink}, {@code origin}, {@code success}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + email.hashCode();
    h = h * 17 + Objects.hashCode(errorCode);
    h = h * 17 + Objects.hashCode(errorMessage);
    h = h * 17 + Objects.hashCode(inviteLink);
    h = h * 17 + Objects.hashCode(origin);
    h = h * 17 + success.hashCode();
    h = h * 17 + Objects.hashCode(userId);
    return h;
  }

  /**
   * Prints the immutable value {@code Invite} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Invite{"
        + "email=" + email
        + ", errorCode=" + errorCode
        + ", errorMessage=" + errorMessage
        + ", inviteLink=" + inviteLink
        + ", origin=" + origin
        + ", success=" + success
        + ", userId=" + userId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._Invite {
    String email;
    String errorCode;
    String errorMessage;
    String inviteLink;
    String origin;
    Boolean success;
    String userId;
    @JsonProperty("email")
    public void setEmail(String email) {
      this.email = email;
    }
    @JsonProperty("errorCode")
    public void setErrorCode(@Nullable String errorCode) {
      this.errorCode = errorCode;
    }
    @JsonProperty("errorMessage")
    public void setErrorMessage(@Nullable String errorMessage) {
      this.errorMessage = errorMessage;
    }
    @JsonProperty("inviteLink")
    public void setInviteLink(@Nullable String inviteLink) {
      this.inviteLink = inviteLink;
    }
    @JsonProperty("origin")
    public void setOrigin(@Nullable String origin) {
      this.origin = origin;
    }
    @JsonProperty("success")
    public void setSuccess(Boolean success) {
      this.success = success;
    }
    @JsonProperty("userId")
    public void setUserId(@Nullable String userId) {
      this.userId = userId;
    }
    @Override
    public String getEmail() { throw new UnsupportedOperationException(); }
    @Override
    public String getErrorCode() { throw new UnsupportedOperationException(); }
    @Override
    public String getErrorMessage() { throw new UnsupportedOperationException(); }
    @Override
    public String getInviteLink() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getSuccess() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Invite fromJson(Json json) {
    Invite.Builder builder = Invite.builder();
    if (json.email != null) {
      builder.email(json.email);
    }
    if (json.errorCode != null) {
      builder.errorCode(json.errorCode);
    }
    if (json.errorMessage != null) {
      builder.errorMessage(json.errorMessage);
    }
    if (json.inviteLink != null) {
      builder.inviteLink(json.inviteLink);
    }
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.success != null) {
      builder.success(json.success);
    }
    if (json.userId != null) {
      builder.userId(json.userId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Invite Invite}.
   * @return A new Invite builder
   */
  public static Invite.Builder builder() {
    return new Invite.Builder();
  }

  /**
   * Builds instances of type {@link Invite Invite}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_EMAIL = 0x1L;
    private static final long INIT_BIT_SUCCESS = 0x2L;
    private long initBits = 0x3L;

    private String email;
    private String errorCode;
    private String errorMessage;
    private String inviteLink;
    private String origin;
    private Boolean success;
    private String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Invite} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Invite instance) {
      return from((_Invite) instance);
    }

    /**
     * Copy abstract value type {@code _Invite} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Invite instance) {
      Objects.requireNonNull(instance, "instance");
      email(instance.getEmail());
      String errorCodeValue = instance.getErrorCode();
      if (errorCodeValue != null) {
        errorCode(errorCodeValue);
      }
      String errorMessageValue = instance.getErrorMessage();
      if (errorMessageValue != null) {
        errorMessage(errorMessageValue);
      }
      String inviteLinkValue = instance.getInviteLink();
      if (inviteLinkValue != null) {
        inviteLink(inviteLinkValue);
      }
      String originValue = instance.getOrigin();
      if (originValue != null) {
        origin(originValue);
      }
      success(instance.getSuccess());
      String userIdValue = instance.getUserId();
      if (userIdValue != null) {
        userId(userIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Invite#getEmail() email} attribute.
     * @param email The value for email 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(String email) {
      this.email = Objects.requireNonNull(email, "email");
      initBits &= ~INIT_BIT_EMAIL;
      return this;
    }

    /**
     * Initializes the value for the {@link _Invite#getErrorCode() errorCode} attribute.
     * @param errorCode The value for errorCode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder errorCode(@Nullable String errorCode) {
      this.errorCode = errorCode;
      return this;
    }

    /**
     * Initializes the value for the {@link _Invite#getErrorMessage() errorMessage} attribute.
     * @param errorMessage The value for errorMessage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder errorMessage(@Nullable String errorMessage) {
      this.errorMessage = errorMessage;
      return this;
    }

    /**
     * Initializes the value for the {@link _Invite#getInviteLink() inviteLink} attribute.
     * @param inviteLink The value for inviteLink (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder inviteLink(@Nullable String inviteLink) {
      this.inviteLink = inviteLink;
      return this;
    }

    /**
     * Initializes the value for the {@link _Invite#getOrigin() origin} attribute.
     * @param origin The value for origin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(@Nullable String origin) {
      this.origin = origin;
      return this;
    }

    /**
     * Initializes the value for the {@link _Invite#getSuccess() success} attribute.
     * @param success The value for success 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder success(Boolean success) {
      this.success = Objects.requireNonNull(success, "success");
      initBits &= ~INIT_BIT_SUCCESS;
      return this;
    }

    /**
     * Initializes the value for the {@link _Invite#getUserId() userId} attribute.
     * @param userId The value for userId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(@Nullable String userId) {
      this.userId = userId;
      return this;
    }

    /**
     * Builds a new {@link Invite Invite}.
     * @return An immutable instance of Invite
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Invite build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Invite(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_EMAIL) != 0) attributes.add("email");
      if ((initBits & INIT_BIT_SUCCESS) != 0) attributes.add("success");
      return "Cannot build Invite, some of required attributes are not set " + attributes;
    }
  }
}
