package org.cloudfoundry.uaa.users;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _InviteUsersRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code InviteUsersRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_InviteUsersRequest"})
public final class InviteUsersRequest extends org.cloudfoundry.uaa.users._InviteUsersRequest {
  private final @Nullable String clientId;
  private final List<String> emails;
  private final String redirectUri;

  private InviteUsersRequest(InviteUsersRequest.Builder builder) {
    this.clientId = builder.clientId;
    this.emails = createUnmodifiableList(true, builder.emails);
    this.redirectUri = builder.redirectUri;
  }

  /**
   * The client registration information
   */
  @Override
  public @Nullable String getClientId() {
    return clientId;
  }

  /**
   * The emails to invite
   */
  @Override
  public List<String> getEmails() {
    return emails;
  }

  /**
   * The redirect URI
   */
  @Override
  public String getRedirectUri() {
    return redirectUri;
  }

  /**
   * This instance is equal to all instances of {@code InviteUsersRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InviteUsersRequest
        && equalTo((InviteUsersRequest) another);
  }

  private boolean equalTo(InviteUsersRequest another) {
    return Objects.equals(clientId, another.clientId)
        && emails.equals(another.emails)
        && redirectUri.equals(another.redirectUri);
  }

  /**
   * Computes a hash code from attributes: {@code clientId}, {@code emails}, {@code redirectUri}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(clientId);
    h = h * 17 + emails.hashCode();
    h = h * 17 + redirectUri.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InviteUsersRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InviteUsersRequest{"
        + "clientId=" + clientId
        + ", emails=" + emails
        + ", redirectUri=" + redirectUri
        + "}";
  }

  private static InviteUsersRequest validate(InviteUsersRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link InviteUsersRequest InviteUsersRequest}.
   * @return A new InviteUsersRequest builder
   */
  public static InviteUsersRequest.Builder builder() {
    return new InviteUsersRequest.Builder();
  }

  /**
   * Builds instances of type {@link InviteUsersRequest InviteUsersRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_REDIRECT_URI = 0x1L;
    private long initBits = 0x1L;

    private String clientId;
    private List<String> emails = new ArrayList<String>();
    private String redirectUri;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InviteUsersRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InviteUsersRequest instance) {
      return from((_InviteUsersRequest) instance);
    }

    /**
     * Copy abstract value type {@code _InviteUsersRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_InviteUsersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String clientIdValue = instance.getClientId();
      if (clientIdValue != null) {
        clientId(clientIdValue);
      }
      addAllEmails(instance.getEmails());
      redirectUri(instance.getRedirectUri());
      return this;
    }

    /**
     * Initializes the value for the {@link _InviteUsersRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(@Nullable String clientId) {
      this.clientId = clientId;
      return this;
    }

    /**
     * Adds one element to {@link _InviteUsersRequest#getEmails() emails} list.
     * @param element A emails element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(String element) {
      this.emails.add(Objects.requireNonNull(element, "emails element"));
      return this;
    }

    /**
     * Adds elements to {@link _InviteUsersRequest#getEmails() emails} list.
     * @param elements An array of emails elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(String... elements) {
      for (String element : elements) {
        this.emails.add(Objects.requireNonNull(element, "emails element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _InviteUsersRequest#getEmails() emails} list.
     * @param elements An iterable of emails elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emails(Iterable<String> elements) {
      this.emails.clear();
      return addAllEmails(elements);
    }

    /**
     * Adds elements to {@link _InviteUsersRequest#getEmails() emails} list.
     * @param elements An iterable of emails elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmails(Iterable<String> elements) {
      for (String element : elements) {
        this.emails.add(Objects.requireNonNull(element, "emails element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _InviteUsersRequest#getRedirectUri() redirectUri} attribute.
     * @param redirectUri The value for redirectUri 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder redirectUri(String redirectUri) {
      this.redirectUri = Objects.requireNonNull(redirectUri, "redirectUri");
      initBits &= ~INIT_BIT_REDIRECT_URI;
      return this;
    }

    /**
     * Builds a new {@link InviteUsersRequest InviteUsersRequest}.
     * @return An immutable instance of InviteUsersRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public InviteUsersRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return InviteUsersRequest.validate(new InviteUsersRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_REDIRECT_URI) != 0) attributes.add("redirectUri");
      return "Cannot build InviteUsersRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
